/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.BasePanel;
import com.ibm.ws.wssecurity.util.WSSMessageTranslator;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginPanel
extends BasePanel
implements FocusListener,
ComponentListener,
Runnable {
    private static final long serialVersionUID = -1247185376229621879L;
    JPanel TopPanel = null;
    JPanel BottomPanel = null;
    JPanel EntryFieldPanel = null;
    JLabel mainlabel = null;
    JLabel id_label = null;
    JLabel cell_label = null;
    JLabel pwd_label = null;
    JTextField id_field = null;
    JTextField cell_field = null;
    JPasswordField pwd_field = null;
    int textfield_length = 15;
    JButton OKButton = null;
    JButton CancelButton = null;
    private boolean firstTimeFocus = true;

    public LoginPanel(String s_name, String r_name, String p_word, JFrame parent) {
        this(s_name, r_name, p_word, 60, parent);
    }

    public LoginPanel(String s_name, String r_name, String p_word, int timeout, JFrame parent) {
        super(WSSMessageTranslator.getMsgOrUseDefault("LoginPanelTitle", "Login at the Target Server"), s_name, r_name, p_word, timeout, parent);
    }

    public void actionPerformed(ActionEvent eve) {
        if (eve.getSource() instanceof JButton) {
            if (eve.getSource() == this.OKButton) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), this.pwd_field.getText());
            } else if (eve.getSource() == this.CancelButton) {
                this.cancel_pressed();
            }
        }
    }

    private void cancel_pressed() {
        this.selectionMade = 3;
        super.setVisible(false);
        this.dispose();
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    public void componentResized(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    protected void createWindow() {
        this.TopPanel = new JPanel();
        this.BottomPanel = new JPanel();
        this.EntryFieldPanel = new JPanel();
        this.mainlabel = this.defaultCellName == null || this.defaultCellName.trim().length() == 0 ? new JLabel(WSSMessageTranslator.getMsgOrUseDefault("GenericLoginPrompt", "Enter login information")) : new JLabel(WSSMessageTranslator.getMsgOrUseDefault("LoginPromptForRealm", "Enter login information for") + " " + this.defaultCellName);
        this.cell_label = new JLabel(WSSMessageTranslator.getMsgOrUseDefault("RealmName", "Realm/Cell Name"), 0);
        this.id_label = new JLabel(WSSMessageTranslator.getMsgOrUseDefault("UserID", "User Identity"), 0);
        this.pwd_label = new JLabel(WSSMessageTranslator.getMsgOrUseDefault("Password", "User Password"), 0);
        if (this.defaultUserID != null) {
            this.id_field = new JTextField(this.defaultUserID);
            this.id_field.setColumns(this.defaultUserID.length() / 2 + 1);
        } else {
            this.id_field = new JTextField();
        }
        if (this.defaultCellName != null) {
            this.cell_field = new JTextField(this.defaultCellName);
            this.cell_field.setColumns(this.defaultCellName.length() / 2 + 1);
            this.cell_field.setEnabled(false);
        } else {
            this.cell_field = new JTextField();
        }
        if (this.defaultPassword != null) {
            this.pwd_field = new JPasswordField(this.defaultPassword);
            this.pwd_field.setColumns(this.defaultPassword.length() / 2 + 1);
        } else {
            this.pwd_field = new JPasswordField();
        }
        this.pwd_field.setEchoChar('*');
        this.cell_field.addFocusListener(this);
        this.id_field.addFocusListener(this);
        this.pwd_field.addFocusListener(this);
        this.OKButton = new JButton(WSSMessageTranslator.getMsgOrUseDefault("OK", "OK"));
        this.CancelButton = new JButton(WSSMessageTranslator.getMsgOrUseDefault("Cancel", "Cancel"));
        this.TopPanel.setLayout(new FlowLayout(1));
        this.TopPanel.add(this.mainlabel);
        this.EntryFieldPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = new Insets(3, 6, 3, 6);
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_label, constraints);
        this.EntryFieldPanel.add(this.cell_label);
        constraints.gridx = 0;
        constraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_label, constraints);
        this.EntryFieldPanel.add(this.id_label);
        constraints.gridx = 0;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_label, constraints);
        this.EntryFieldPanel.add(this.pwd_label);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.ipadx = 120;
        constraints.fill = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_field, constraints);
        this.EntryFieldPanel.add(this.cell_field);
        constraints.gridx = 1;
        constraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_field, constraints);
        this.EntryFieldPanel.add(this.id_field);
        constraints.gridx = 1;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_field, constraints);
        this.EntryFieldPanel.add(this.pwd_field);
        this.BottomPanel.setLayout(new FlowLayout(1));
        this.BottomPanel.add(this.OKButton);
        this.BottomPanel.add(this.CancelButton);
        this.getContentPane().add("North", this.TopPanel);
        this.getContentPane().add("Center", this.EntryFieldPanel);
        this.getContentPane().add("South", this.BottomPanel);
        this.OKButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.OKButton.addKeyListener(this);
        this.CancelButton.addKeyListener(this);
        this.id_field.addKeyListener(this);
        this.cell_field.addKeyListener(this);
        this.pwd_field.addKeyListener(this);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.firstTimeFocus = true;
        this.inputThread = new Thread(this);
        this.inputThread.setDaemon(true);
        this.inputThread.start();
        super.createWindow();
    }

    public boolean done() {
        return !this.isVisible();
    }

    public void focusGained(FocusEvent evt) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0 && this.cell_field.isEnabled()) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    public void focusLost(FocusEvent evt) {
    }

    public String getCell() {
        return this.cellstr;
    }

    public String getId() {
        return this.idstr;
    }

    public String getPassword() {
        return this.pwdstr;
    }

    public void keyPressed(KeyEvent evt) {
        super.keyPressed(evt);
        if (evt.getSource() instanceof Button && evt.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(evt.getSource(), 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 27) {
            this.actionPerformed(new ActionEvent(this.CancelButton, 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 10) {
            if (this.id_field.getText().length() > 0) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), this.pwd_field.getText());
            } else {
                this.cancel_pressed();
            }
            evt.consume();
        }
        this.firstTimeFocus = false;
    }

    private void ok_pressed(String idFld, String cellFld, String pwdFld) {
        this.idstr = idFld != null && idFld.length() > 0 ? idFld : null;
        this.cellstr = cellFld != null && cellFld.length() > 0 ? cellFld : null;
        this.pwdstr = pwdFld != null && pwdFld.length() > 0 ? pwdFld : null;
        this.selectionMade = 2;
        this.requestFocus();
        this.hide();
        this.setVisible(false);
        this.dispose();
    }

    public String ret_cellstr() {
        return this.cellstr;
    }

    public String ret_idstr() {
        return this.idstr;
    }

    public String ret_pwdstr() {
        return this.pwdstr;
    }

    public void run() {
        try {
            int sleepInterval = 5000;
            for (int i = 0; i < this.timeout; i += sleepInterval) {
                Thread.sleep(sleepInterval);
                if (this.selectionMade != 0) {
                    return;
                }
                if ((this.id_field.hasFocus() || this.pwd_field.hasFocus()) && !this.firstTimeFocus) continue;
                super.setVisible(true);
                this.requestFocus();
                this.firstTimeFocus = false;
            }
            if (this.selectionMade == 0) {
                this.selectionMade = 1;
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }
}

