/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.io.OutputStream;

public class LogOutputStream
extends OutputStream {
    private byte[] temp = new byte[1];
    private long count = 0L;
    private TraceComponent tc;
    private int BUFFER_LEN = 4096;
    private byte[] buffer = new byte[this.BUFFER_LEN];
    private int bufferIndex = 0;
    private int limit;
    private String encoding = "UTF-8";

    public LogOutputStream(TraceComponent tc, int limit) {
        this.tc = tc;
        this.limit = limit;
    }

    public long getLength() {
        return this.count;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void close() throws IOException {
        if (this.bufferIndex > 0) {
            Tr.debug(this.tc, new String(this.buffer, 0, this.bufferIndex));
            this.bufferIndex = 0;
        }
        this.buffer = null;
        this.temp = null;
        this.tc = null;
    }

    public void flush() throws IOException {
        if (this.bufferIndex > 0) {
            Tr.debug(this.tc, new String(this.buffer, 0, this.bufferIndex, this.encoding));
            this.bufferIndex = 0;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.count >= (long)this.limit) {
            this.count += (long)len;
            return;
        }
        if (this.count + (long)len >= (long)this.limit) {
            this.count += (long)len;
            len = (int)((long)len - ((long)this.limit - this.count));
        } else {
            this.count += (long)len;
        }
        if (len + this.bufferIndex < this.BUFFER_LEN) {
            System.arraycopy(b, off, this.buffer, this.bufferIndex, len);
            this.bufferIndex += len;
        } else {
            if (this.bufferIndex > 0) {
                Tr.debug(this.tc, new String(this.buffer, 0, this.bufferIndex, this.encoding));
                this.bufferIndex = 0;
            }
            if (len + this.bufferIndex < this.BUFFER_LEN) {
                System.arraycopy(b, off, this.buffer, this.bufferIndex, len);
                this.bufferIndex += len;
            } else {
                Tr.debug(this.tc, new String(b, off, len));
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.temp[0] = (byte)b;
        this.write(this.temp, 0, 1);
    }
}

