/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.security.jgss.TokenHeader;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.APReq;
import com.ibm.security.krb5.internal.EncTicketPart;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.wss.KerberosTokenConsumer;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.util.KRBSPNList;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class KRB5Util {
    private static Object _lock = new Object();
    private static final TraceComponent tc = Tr.register(KRB5Util.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char TILDA = '~';
    private static final char DOT = '.';
    public static final String STR_TOKENID = "tokenID";
    public static final String ATTR_ENCODINGTYPE = "EncodingType";
    public static final int TOK_ID_LEN = 2;
    public static final byte[] AP_REQ_TOK_ID = new byte[]{1, 0};
    public static final int Des3EType_KD_KDC_REP_TICKET = 2;
    public static final int AES128_KD_KDC_REP_TICKET = 2;
    public static final int AES256_KD_KDC_REP_TICKET = 2;
    public static final int Rc4HMac_KD_AS_REP_SERV = 2;
    public static final int Rc4HMac_KD_AP_REQ_AUTHN = 11;
    public static final int Des3EType_KD_AP_REQ_AUTH = 11;
    public static final int AES128_KD_AP_REQ_AUTH = 11;
    public static final int AES256_KD_AP_REQ_AUTH = 11;
    public static final int Rc4HMac_KD_TGS_REP = 8;
    public static final int WRAPPED = 1;
    public static final int NOT_WRAPPED = 0;
    public static final int JAAS_LOGIN_CONFIG = 0;
    public static final int TOKEN_CONSUMER_CONFIG = 1;
    public static final int TOKEN_GENERATOR_CONFIG = 2;
    public static final String JAAS_LOGIN_CONFIG_LABEL = "JAAS Login Module";
    public static final String TOKEN_CONSUMER_CONFIG_LABEL = "Token Consumer";
    public static final String TOKEN_GENERATOR_CONFIG_LABEL = "Token Generator";
    public static final String DEFAULT_JAAS_LOGIN_CONFIG = "JAASClient";
    private static KRBSPNList servicePrincipalNameList = new KRBSPNList();
    private static ResourceBundle nls = null;
    private static final GSSManager _gssMgr = GSSManager.getInstance();
    private static Oid krb5Oid = null;

    public static ResourceBundle getNLS() {
        if (nls == null) {
            try {
                nls = ResourceBundle.getBundle("com.ibm.ws.wssecurity.resources.wssmessages");
            }
            catch (MissingResourceException ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.wssecurity.util.KRBUtil", "1");
            }
        }
        return nls;
    }

    public static String showHex(byte[] buffer) {
        int i;
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        int nBytes = buffer.length;
        StringBuffer sb = new StringBuffer(nBytes);
        StringBuffer pb = new StringBuffer(nBytes << 1);
        StringBuffer hb = new StringBuffer(nBytes << 1);
        StringBuffer tb = new StringBuffer(nBytes << 1);
        int j = 0;
        int k = 0;
        float f = 0.0f;
        for (i = 0; i < nBytes; ++i) {
            int value = buffer[i] & 0xFF;
            if (value == 13 || value == 10 || value == 9 || value >= 32 && value <= 126) {
                sb.append((char)value);
            } else {
                sb.append('[' + KRB5Util.hexPad(Integer.toHexString(value), 2) + ']');
                f += 1.0f;
            }
            if (value >= 32 && value <= 126) {
                tb.append((char)value);
            } else {
                tb.append('.');
            }
            hb.append(KRB5Util.hexPad(Integer.toHexString(value), 2));
            if (j == 3 || j == 7 || j == 11) {
                hb.append(' ');
                tb.append(' ');
            }
            if (j == 15) {
                pb.append(KRB5Util.hexPad(Integer.toHexString(k), 4)).append(":  ").append(hb).append("    ").append(tb).append("\n");
                j = 0;
                k += 16;
                hb.setLength(0);
                tb.setLength(0);
                continue;
            }
            ++j;
        }
        for (i = hb.length(); i < 35; ++i) {
            hb.append(' ');
        }
        pb.append(KRB5Util.hexPad(Integer.toHexString(k), 4)).append(":  ").append(hb).append("    ").append(tb).append("\n");
        return pb.toString();
    }

    private static String hexPad(String aString, int aPadLength) {
        if (aString == null || aString.length() == 0) {
            return "";
        }
        int stringSize = aString.length();
        StringBuffer buffer = new StringBuffer(stringSize + aPadLength);
        for (int i = stringSize; i < aPadLength; ++i) {
            buffer.append('0');
        }
        buffer.append(aString);
        return buffer.toString();
    }

    public static boolean isTGTInSubject(Subject subject) {
        Iterator credIt;
        boolean tgtExists = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTGTInSubject()");
        }
        if (subject != null && (credIt = KRB5Util.getTokens(subject, KerberosTicket.class).iterator()) != null && credIt.hasNext()) {
            tgtExists = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Kerberor Ticket Exists In Subject [" + tgtExists + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTGTInSubject()");
        }
        return tgtExists;
    }

    public static KerberosTicket getTGTInSubject(Subject subject) {
        Iterator credIt;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTGTInSubject()");
        }
        KerberosTicket cred = null;
        if (subject != null && (credIt = KRB5Util.getTokens(subject, KerberosTicket.class).iterator()) != null && credIt.hasNext()) {
            cred = (KerberosTicket)credIt.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Kerberor Ticket Exists In Subject [" + (cred != null) + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTGTInSubject()");
        }
        return cred;
    }

    public static boolean isTokenInSubject(Subject subject, Class tokenClass) {
        boolean tokenExists = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTokenInSubject()");
        }
        if (subject != null && KRB5Util.getTokens(subject, tokenClass).size() > 0) {
            tokenExists = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token Exists In Subject [" + tokenExists + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenInSubject()");
        }
        return tokenExists;
    }

    public static String getKerberosPrincipalFromSubject(Subject subject) {
        Object principalObj;
        Iterator principalIt;
        String was_principal = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrincipalFromSubject()");
        }
        if (subject != null && (principalIt = KRB5Util.getPrincipals(subject, KerberosPrincipal.class).iterator()) != null && principalIt.hasNext() && (was_principal = ((KerberosPrincipal)(principalObj = principalIt.next())).getName()) != null) {
            int idx = was_principal.indexOf(64);
            if (idx > 0) {
                was_principal = was_principal.substring(0, idx);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Kerberos Principal (realm stripped): " + was_principal);
            }
        }
        if (was_principal == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "No Kerberos Principal Found In Subject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipalFromSubject()");
        }
        return was_principal;
    }

    private static Set getTokens(Subject subject, Class tokenClass) {
        boolean bGetCreds = true;
        return KRB5Util.getSubjectObjects(subject, tokenClass, bGetCreds);
    }

    private static Set getPrincipals(Subject subject, Class principalClass) {
        boolean bGetCreds = false;
        return KRB5Util.getSubjectObjects(subject, principalClass, bGetCreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getSubjectObjects(final Subject subject, final Class objectClass, final boolean bGetCreds) {
        String methodName = "getSubjectObjects";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        Set set = new HashSet();
        if (subject == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"subject", methodName});
            return set;
        }
        if (objectClass == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"objectClass", methodName});
            return set;
        }
        Object object = _lock;
        synchronized (object) {
            set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Object> result = new HashSet();
                    try {
                        result = bGetCreds ? subject.getPrivateCredentials(objectClass) : subject.getPrincipals(objectClass);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Number of subject objects retrived = " + result.size());
                        }
                    }
                    catch (Throwable t) {
                        Tr.error(tc, "kerberos.unexpected.exception", t.getMessage());
                    }
                    return result;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addCredentialToSubject(final Subject subject, final Object obj) {
        Boolean addedCredentials = Boolean.FALSE;
        String methodName = "addCredentialToSubject";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        if (subject == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"subject", methodName});
            return addedCredentials;
        }
        if (obj == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"crendential", methodName});
            return addedCredentials;
        }
        Object object = _lock;
        synchronized (object) {
            addedCredentials = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Boolean bResult;
                    block4: {
                        bResult = Boolean.FALSE;
                        try {
                            if (subject != null) {
                                subject.getPrivateCredentials().add(obj);
                                bResult = Boolean.TRUE;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Credential added successfully to the subject. ");
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug(tc, "Credential is NOT added to the subject. ");
                        }
                    }
                    return bResult;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return addedCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addPrincipalToSubject(final Subject subject, final Principal principal) {
        Boolean addedCredentials = Boolean.FALSE;
        String methodName = "addPrincipalToSubject";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        if (subject == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"subject", methodName});
            return addedCredentials;
        }
        if (principal == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"principal", methodName});
            return addedCredentials;
        }
        Object object = _lock;
        synchronized (object) {
            addedCredentials = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Boolean bResult;
                    block4: {
                        bResult = Boolean.FALSE;
                        try {
                            if (subject != null) {
                                subject.getPrincipals().add(principal);
                                bResult = Boolean.TRUE;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Principal added successfully to the subject. ");
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug(tc, "Principal is NOT added to the subject. ");
                        }
                    }
                    return bResult;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return addedCredentials;
    }

    private static HashMap getKerberosTicketProperties(byte[] token, Credentials serverCreds) {
        String methodName = "getKerberosTokenExpiryTime";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        if (token == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"token", methodName});
            return null;
        }
        if (serverCreds == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"serverCreds", methodName});
            return null;
        }
        HashMap<String, String> ticketProperties = new HashMap<String, String>();
        try {
            byte[] temp1;
            APReq apreq = KRB5Util.getAPReq(token);
            Ticket ticket = apreq.getTicket();
            EncryptedData encPart = ticket.getEncryptedPart();
            boolean desKey = encPart.isDesEncType();
            int encodingType = encPart.getEType();
            byte[] temp = null;
            if (desKey) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else if (encodingType == 17) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else if (encodingType == 18) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else {
                try {
                    temp = encPart.decrypt(serverCreds.getServiceKey(), 2);
                }
                catch (KrbException exc) {
                    temp = encPart.decrypt(serverCreds.getServiceKey(), 8);
                }
            }
            EncTicketPart decTicket = new EncTicketPart(temp);
            ticketProperties.put("ExpiryTime", Long.toString(decTicket.getEndTime().getTime()));
            ticketProperties.put("WASPrincipal", decTicket.getClient().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The kerberos ticket properties  = " + ticketProperties.toString());
            }
        }
        catch (Throwable t) {
            Tr.error(tc, "kerberos.unexpected.exception", t.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return ticketProperties;
    }

    private static APReq getAPReq(byte[] token) {
        APReq apreq;
        String methodName;
        block12: {
            methodName = "getAPReq";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAPReq");
            }
            if (token == null) {
                Tr.error(tc, "kerberos.invalid.parm", new Object[]{"token", methodName});
                return null;
            }
            apreq = null;
            try {
                if (token[0] == 110) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decoded an AP_REQ input token");
                    }
                    apreq = new APReq(token);
                    break block12;
                }
                if (token[0] == 96) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decoded a GSS Wrapped input token");
                    }
                    ByteArrayInputStream inStream = new ByteArrayInputStream(token);
                    TokenHeader header = new TokenHeader((InputStream)inStream);
                    Oid mechOid = header.getMechanism();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The Mechanism OID =\n" + mechOid.toString());
                    }
                    if (!mechOid.equals(KerberosTokenConsumer.MECH_TYPE_KRB5) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos mechanics not passed" + mechOid.toString());
                    }
                    int mechTokenSize = header.getMechTokenLen();
                    byte[] buff = KRB5Util.stream2Bytes(inStream, mechTokenSize);
                    byte[] innerToken = new byte[mechTokenSize];
                    System.arraycopy(buff, 0, innerToken, 0, mechTokenSize);
                    byte[] tokenId = new byte[2];
                    System.arraycopy(innerToken, 0, tokenId, 0, 2);
                    int krbMsgLen = innerToken.length - 2;
                    byte[] krbMsg = new byte[krbMsgLen];
                    System.arraycopy(innerToken, 2, krbMsg, 0, krbMsgLen);
                    if (Arrays.equals(tokenId, AP_REQ_TOK_ID)) {
                        apreq = new APReq(krbMsg);
                        break block12;
                    }
                    throw new RuntimeException("GSS Token was not an APReq message");
                }
                throw new RuntimeException("Input Token not of type GSS_Kerberosv5_AP_REQ or Kerberosv5_AP_REQ");
            }
            catch (Throwable t) {
                Tr.error(tc, "kerberos.unexpected.exception", t.getMessage());
                FFDCFilter.processException(t, KRB5Util.class.getName(), "1");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return apreq;
    }

    private static KerberosKey getServiceKerberosKey(EncryptionKey serviceKey, String servicePrincipal) {
        String methodName = "getServiceKerberosKey";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        KerberosKey kkey = null;
        try {
            if (serviceKey != null) {
                Integer kvno = serviceKey.getKeyVersionNumber();
                kkey = new KerberosKey(new KerberosPrincipal(servicePrincipal), serviceKey.getBytes(), serviceKey.getEType(), kvno != null ? kvno : 0);
            }
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, KRB5Util.class.getName(), "2");
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return kkey;
    }

    private static byte[] stream2Bytes(InputStream in, int len) throws GSSException {
        String methodName = "stream2Bytes";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        if (in == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"InputStream", methodName});
            return null;
        }
        byte[] buffer = new byte[len];
        int readLen = 0;
        try {
            readLen = in.read(buffer, 0, len);
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamReadError", (Object[])new String[]{exc.toString()});
        }
        if (readLen != len) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamDataLenMismatch", (Object[])new Integer[]{new Integer(len), new Integer(readLen)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return buffer;
    }

    public static String getFormattedMessage(ResourceBundle nls, String key, Object[] args) {
        String message = null;
        try {
            message = nls.getString(key);
            if (message != null) {
                message = MessageFormat.format(message, args);
            }
        }
        catch (MissingResourceException e) {
            Tr.debug(tc, "Cannot find message key in resource bundle " + nls.toString());
        }
        catch (NullPointerException npe) {
            Tr.debug(tc, "Null pointer exception caught trying to find message key " + key + " in resource bundle " + nls.toString());
        }
        return message;
    }

    public static KRBSPNList getSPNList() {
        return servicePrincipalNameList;
    }

    public static String stripOutPrincipalName(String principalNameFQ) {
        int idx;
        String strippedPrincipal = principalNameFQ;
        if (principalNameFQ != null && (idx = principalNameFQ.indexOf(64)) > 0) {
            strippedPrincipal = principalNameFQ.substring(0, idx);
        }
        return strippedPrincipal;
    }

    public static String stripOutRealmName(String principalNameFQ) {
        int idx0;
        String kerberosRealm = "";
        if (principalNameFQ != null && (idx0 = principalNameFQ.indexOf(64)) > 0) {
            kerberosRealm = principalNameFQ.substring(idx0 + 1);
        }
        return kerberosRealm;
    }

    public static String getUniqueID(String was_principal, boolean subjectHasPrincipal, WSSContextManager ctxMgr) {
        String methodName = "getUniqueID";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        String uniqueID = "";
        if (was_principal == null) {
            Tr.error(tc, "kerberos.invalid.parm", new Object[]{"was_principal", methodName});
            return "";
        }
        if (subjectHasPrincipal) {
            try {
                uniqueID = ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUniqueUserId(was_principal);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (uniqueID.equals("")) {
            uniqueID = String.valueOf(was_principal.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uniqueID: " + uniqueID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueID()");
        }
        return uniqueID;
    }

    public static String getCurrentLoggedOnUser() {
        String userID;
        String methodName = "getCurrentLoggedOnUser";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName);
        }
        if ((userID = System.getProperty("user.name")) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get the logged on userID.");
            }
            userID = "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Logged on userID-" + userID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName);
        }
        return userID;
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasValue(char[] chars) {
        return chars != null && chars.length > 0;
    }

    public static boolean hasValue(byte[] bytes) {
        return bytes != null && bytes.length > 0;
    }

    public static GSSCredential createInitGSSCred(KerberosTicket kticket) throws GSSException {
        String clientName = kticket.getClient().getName();
        if (KRB5Util.hasValue(clientName)) {
            GSSName gssName = _gssMgr.createName(clientName, GSSName.NT_USER_NAME, KRB5Util.getKerberos5Oid());
            GSSCredential _gssCred = _gssMgr.createCredential(gssName.canonicalize(KRB5Util.getKerberos5Oid()), Integer.MAX_VALUE, KRB5Util.getKerberos5Oid(), 1);
            return _gssCred;
        }
        return null;
    }

    public static Oid getKerberos5Oid() throws GSSException {
        if (krb5Oid == null) {
            krb5Oid = new Oid(KRB5_OID);
        }
        return krb5Oid;
    }

    public static synchronized boolean spnValid(String spn) {
        boolean result = true;
        String[] strs = spn.split("/");
        if (strs == null || strs.length != 2) {
            result = false;
        } else if (strs[1].contains("@")) {
            result = false;
        }
        return result;
    }

    public static synchronized boolean isSubKeyEncTypeSupported(Integer subKeyEncType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSubKeyEncTypeSupported()...");
        }
        boolean subKeySupported = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CONTEXT_SUB_KEY_ENC: " + subKeyEncType);
        }
        if (subKeyEncType != null) {
            int subKeyEncTypeInt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CONTEXT_SUB_KEY_ENC: " + subKeyEncType.getClass().getName());
                Tr.debug(tc, "Current Kerberos subkey encryption type value: " + subKeyEncType.toString());
                Tr.debug(tc, "Current Kerberos subkey encryption type: " + EncryptedData.encTypeToString((int)subKeyEncType));
            }
            if ((subKeyEncTypeInt = subKeyEncType.intValue()) == 16 || subKeyEncTypeInt == 17 || subKeyEncTypeInt == 18 || subKeyEncTypeInt == 23) {
                subKeySupported = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: Do not support - " + EncryptedData.encTypeToString((int)subKeyEncTypeInt));
            }
            if (subKeyEncTypeInt == 23 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Kerberos encryption type: " + EncryptedData.encTypeToString((int)23) + " is tolerated.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Supported Kerberos sub key encryption type in Web services security: " + EncryptedData.encTypeToString((int)17) + ", " + EncryptedData.encTypeToString((int)18) + ", " + EncryptedData.encTypeToString((int)16));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSubKeyEncTypeSupported()...");
        }
        return subKeySupported;
    }

    public static synchronized boolean isSessKeyEncTypeSupported(Integer sessionKeyEncType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSessKeyEncTypeSupported()...");
        }
        boolean sessionKeySupported = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CONTEXT_SESSION_KEY_ENC: " + sessionKeyEncType);
        }
        if (sessionKeyEncType != null) {
            int sessionKeyEncTypeInt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CONTEXT_SESSION_KEY_ENC: " + sessionKeyEncType.getClass().getName());
                Tr.debug(tc, "Current Kerberos session key encryption type value: " + sessionKeyEncType.toString());
                Tr.debug(tc, "Current Kerberos session key encryption type: " + EncryptedData.encTypeToString((int)sessionKeyEncType));
            }
            if ((sessionKeyEncTypeInt = sessionKeyEncType.intValue()) == 16 || sessionKeyEncTypeInt == 17 || sessionKeyEncTypeInt == 18 || sessionKeyEncTypeInt == 23) {
                sessionKeySupported = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: Do not support - " + EncryptedData.encTypeToString((int)sessionKeyEncTypeInt));
            }
            if (sessionKeyEncTypeInt == 23 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Kerberos encryption type: " + EncryptedData.encTypeToString((int)23) + " is tolerated.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Supported Kerberos session key encryption type in Web services security: " + EncryptedData.encTypeToString((int)17) + ", " + EncryptedData.encTypeToString((int)18) + ", " + EncryptedData.encTypeToString((int)16));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSessKeyEncTypeSupported()...");
        }
        return sessionKeySupported;
    }

    public static String printTGT(KerberosTicket kt) {
        if (kt == null) {
            return "Kerberos TGT is null.";
        }
        if (kt.isDestroyed()) {
            return "Kerberos TGT is destroyed.";
        }
        return kt.toString();
    }
}

