/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class GetJAASConfigInfo {
    private static TraceComponent tc = Tr.register(GetJAASConfigInfo.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean jaasConfigAvail = false;
    private static boolean conUseDefaultSCTJAASLoginCfg = false;
    private static boolean genUseDefaultSCTJAASLoginCfg = false;
    private static boolean conUseDefaultX509JAASLoginCfg = false;
    private static boolean genUseDefaultX509JAASLoginCfg = false;
    private static boolean conUseDefaultUNTJAASLoginCfg = false;
    private static boolean genUseDefaultUNTJAASLoginCfg = false;
    private static Map jaasConfigMap = null;

    public static void getJAASConfigInformation(String cfgName, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJAASConfigInformation(String cfgName, Map context) : " + cfgName);
        }
        if (!jaasConfigAvail) {
            GetJAASConfigInfo.readJAASConfigInformation();
        }
        if ("generate".equals(cfgName)) {
            context.put("com.ibm.ws.wssecurity.sct.jaasLogin", genUseDefaultSCTJAASLoginCfg);
            context.put("com.ibm.ws.wssecurity.x509.jaasLogin", genUseDefaultX509JAASLoginCfg);
            context.put("com.ibm.ws.wssecurity.unt.jaasLogin", genUseDefaultUNTJAASLoginCfg);
        } else if ("consume".equals(cfgName)) {
            context.put("com.ibm.ws.wssecurity.sct.jaasLogin", conUseDefaultSCTJAASLoginCfg);
            context.put("com.ibm.ws.wssecurity.x509.jaasLogin", conUseDefaultX509JAASLoginCfg);
            context.put("com.ibm.ws.wssecurity.unt.jaasLogin", conUseDefaultUNTJAASLoginCfg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJAASConfigInformation(String cfgName, Map context) : " + cfgName);
        }
    }

    private static synchronized void readJAASConfigInformation() {
        block11: {
            Configuration config2;
            block10: {
                if (jaasConfigAvail) {
                    return;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "readJAASConfigInformation");
                }
                config2 = null;
                try {
                    config2 = (Configuration)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            return Configuration.getConfiguration();
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to get JAAS configuration.");
                    }
                }
                catch (PrivilegedActionException pae) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Caught Privileged Exception " + pae.getMessage());
                }
            }
            try {
                if (config2 != null) {
                    genUseDefaultSCTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.sct", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule", "com.ibm.ws.wssecurity.wssapi.token.impl.DKTGenerateLoginModule", config2);
                    conUseDefaultSCTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.sct", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTConsumeLoginModule", "com.ibm.ws.wssecurity.wssapi.token.impl.DKTConsumeLoginModule", config2);
                    genUseDefaultX509JAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.x509", "com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule", config2);
                    conUseDefaultX509JAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.x509", "com.ibm.ws.wssecurity.wssapi.token.impl.X509ConsumeLoginModule", config2);
                    genUseDefaultUNTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.generate.unt", "com.ibm.ws.wssecurity.wssapi.token.impl.UNTGenerateLoginModule", config2);
                    conUseDefaultUNTJAASLoginCfg = GetJAASConfigInfo.getJaasEntry("system.wss.consume.unt", "com.ibm.ws.wssecurity.wssapi.token.impl.UNTConsumeLoginModule", config2);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Caught Exception while getting JAAS config " + ex.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generators: Default SCT login module is used = " + genUseDefaultSCTJAASLoginCfg + ", Default X509 Login module is used = " + genUseDefaultX509JAASLoginCfg + ", Default UNT Login module is used = " + genUseDefaultUNTJAASLoginCfg);
            Tr.debug(tc, "Consumers: Default SCT login module is used = " + conUseDefaultSCTJAASLoginCfg + ", Default X509 Login module is used = " + conUseDefaultX509JAASLoginCfg + ", Default UNT Login module is used = " + conUseDefaultUNTJAASLoginCfg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readJAASConfigInformation");
        }
        jaasConfigAvail = true;
    }

    private static boolean getJaasEntry(String jaasConfigEntry, String loginModule1, Configuration config2) {
        return GetJAASConfigInfo.getJaasEntry(jaasConfigEntry, loginModule1, null, config2);
    }

    private static boolean getJaasEntry(String jaasConfigEntry, String loginModule1, String loginModule2, Configuration config2) {
        AppConfigurationEntry[] appConfigEntries;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJaasEntry(" + jaasConfigEntry + ", " + loginModule1 + ", " + loginModule2 + ", config)");
        }
        boolean defaultUsed = false;
        int requiredLength = 1;
        if (loginModule2 != null) {
            requiredLength = 2;
        }
        if ((appConfigEntries = config2.getAppConfigurationEntry(jaasConfigEntry)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No JAAS config found for: " + jaasConfigEntry);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, jaasConfigEntry);
                Tr.debug(tc, "Number of appConfigEntries : " + appConfigEntries.length);
            }
            if (appConfigEntries.length == requiredLength) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Login Configuration is module0: " + appConfigEntries[0].getLoginModuleName());
                    if (loginModule2 != null) {
                        Tr.debug(tc, "module1: " + appConfigEntries[1].getLoginModuleName());
                    }
                }
                if (appConfigEntries[0].getLoginModuleName().equals(loginModule1)) {
                    if (loginModule2 != null) {
                        if (appConfigEntries[1].getLoginModuleName().equals(loginModule2)) {
                            defaultUsed = true;
                        }
                    } else {
                        defaultUsed = true;
                    }
                    if (defaultUsed) {
                        jaasConfigMap.put(jaasConfigEntry, jaasConfigEntry);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJaasEntry returns " + defaultUsed);
        }
        return defaultUsed;
    }

    public static String isJaasConfigOurs(String jaasConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJaasConfigOurs(" + jaasConfig + ")");
        }
        String retVal = null;
        if (ConfigUtil.hasValue(jaasConfig)) {
            if (!jaasConfigAvail) {
                GetJAASConfigInfo.readJAASConfigInformation();
            }
            retVal = (String)jaasConfigMap.get(jaasConfig);
        }
        if (tc.isDebugEnabled()) {
            if (ConfigUtil.hasValue(retVal)) {
                Tr.debug(tc, "JAAS config is ours");
            } else {
                Tr.debug(tc, "JAAS config is NOT ours");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isJaasConfigOurs returns (" + retVal + ")");
        }
        return retVal;
    }

    static {
        jaasConfigMap = new HashMap();
    }
}

