/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMNamespaceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils
extends DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final OMNamespace DECRYPT_NS = new OMNamespaceImpl("http://www.w3.org/2002/07/decrypt#", "decrypt");
    public static final OMNamespace DSIG_NS = new OMNamespaceImpl(Constants.NS_DSIG, "ds");
    public static final OMNamespace ENCRYPTION_NS = new OMNamespaceImpl("http://www.w3.org/2001/04/xmlenc#", "enc");
    public static final OMNamespace EXCLUSIVE_NS = new OMNamespaceImpl("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
    public static final OMNamespace WSSE11_NS = new OMNamespaceImpl(Constants.NS_WSSE11, "wsse11");
    private static final HashSet<String> INDENT_NS = new HashSet();

    private static OMElement createOMElementAndDeclare(String localName, OMFactory omf, OMNamespace ns) {
        OMElement ome = omf.createOMElement(localName, ns);
        ome.declareNamespace(ns);
        return ome;
    }

    private static OMElement createOMElementWithConditionalDeclare(String localName, OMFactory omf, OMElement parent, OMNamespace ns) {
        String prefix = DOMUtil.getNamespacePrefix(parent, ns.getNamespaceURI());
        OMElement ome = omf.createOMElement(localName, ns, parent);
        if (!ns.getPrefix().equals(prefix)) {
            ome.declareNamespace(ns);
        }
        return ome;
    }

    public static OMElement createDecryptionOMElement(String localName, OMFactory omf, OMElement parent) {
        if (parent == null) {
            return DOMUtils.createOMElementAndDeclare(localName, omf, DECRYPT_NS);
        }
        return DOMUtils.createOMElementWithConditionalDeclare(localName, omf, parent, DECRYPT_NS);
    }

    public static OMElement createDsigOMElement(String localName, OMFactory omf) {
        return DOMUtils.createOMElementAndDeclare(localName, omf, DSIG_NS);
    }

    public static OMElement createDsigOMElement(String localName, OMFactory omf, OMElement parent) {
        if (parent == null) {
            return DOMUtils.createOMElementAndDeclare(localName, omf, DSIG_NS);
        }
        return DOMUtils.createOMElementWithConditionalDeclare(localName, omf, parent, DSIG_NS);
    }

    public static OMElement createEncOMElement(String localName, OMFactory omf, OMElement parent) {
        if (parent == null) {
            return DOMUtils.createOMElementAndDeclare(localName, omf, ENCRYPTION_NS);
        }
        return DOMUtils.createOMElementWithConditionalDeclare(localName, omf, parent, ENCRYPTION_NS);
    }

    public static OMElement createExclusiveOMElement(String localName, OMFactory omf) {
        return DOMUtils.createOMElementAndDeclare(localName, omf, EXCLUSIVE_NS);
    }

    public static void declareDecryptionNamespace(OMElement ome) {
        ome.declareNamespace(DECRYPT_NS);
    }

    public static OMDocument getPrivateConfig() {
        String file = "config/ibm-wssecurity-config-private.xml";
        return DOMUtils.getPrivateConfig(file);
    }

    public static void indent(OMElement element, int init, int diff) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "indent(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "int init[" + init + "]," + "int diff[" + diff + "])");
        }
        int sp = init + diff;
        if (INDENT_NS.contains(element.getNamespace() == null ? null : element.getNamespace().getName())) {
            OMFactory factory = element.getOMFactory();
            OMNode prev = null;
            for (OMNode child = element.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                if (child.getType() == 1) {
                    if (prev == null || prev.getType() != 4) {
                        child.insertSiblingBefore(DOMUtils.createTextNode(factory, sp));
                    } else if (DOMUtils.isAllSpace(prev)) {
                        prev.insertSiblingBefore(DOMUtils.createTextNode(factory, sp));
                        prev.detach();
                    }
                    DOMUtils.indent((OMElement)child, sp, diff);
                }
                prev = child;
            }
            if (prev == null || prev.getType() != 4) {
                element.addChild(DOMUtils.createTextNode(factory, init));
            } else if (DOMUtils.isAllSpace(prev)) {
                prev.insertSiblingBefore(DOMUtils.createTextNode(factory, init));
                prev.detach();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "indent(OMElement element, int init, int diff)");
        }
    }

    public static QName getQName(OMElement element, String qNameStr, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String qNameStr[" + qNameStr + "]," + "int wssVersion[" + wssVersion + "])");
        }
        QName qn = null;
        qn = wssVersion == 0 && qNameStr.startsWith("http://") ? new QName("", qNameStr) : DOMUtils.getQName(element, qNameStr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(OMElement element, String qNameStr, int wssVersion) returns QName[" + qn + "]");
        }
        return qn;
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue, int wssVersion) {
        String attrLocal;
        String attrPrefix;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "]," + "int wssVersion[" + wssVersion + "])");
        }
        String strQName = DOMUtils.setQName0(element, attrValue, wssVersion);
        int index = attrName.indexOf(":");
        if (index == -1) {
            attrPrefix = "";
            attrLocal = attrName;
        } else {
            attrPrefix = attrName.substring(0, index);
            attrLocal = attrName.substring(index + 1);
        }
        if (attrNameNS == null) {
            element.addAttribute(attrLocal, strQName, null);
        } else {
            element.addAttribute(attrLocal, strQName, element.getOMFactory().createOMNamespace(attrNameNS, attrPrefix));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(OMElement element,String attrNameNS,String attrName,QName attrValue,int wssVersion)");
        }
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "])");
        }
        String strQName = DOMUtils.setQName0(element, attrValue, -1);
        if (attrNameNS == null) {
            element.addAttribute(attrName, strQName, null);
        } else {
            element.addAttribute(attrName, strQName, element.getOMFactory().createOMNamespace(attrNameNS, ""));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(OMElement element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(OMElement element, QName text, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameText(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "QName text[" + text + "]," + "int wssVersion[" + wssVersion + "])");
        }
        String strQName = DOMUtils.setQName0(element, text, wssVersion);
        element.addChild(element.getOMFactory().createOMText(strQName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameText(OMElement element, QName text, int wssVersion)");
        }
    }

    private static String setQName0(OMElement elem, QName qName, int wssVersion) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        if (nsURI == null || nsURI.length() == 0 && wssVersion == 0) {
            return localPart;
        }
        OMContainer n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof OMElement) {
            Iterator map = n.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                OMNamespace ns = (OMNamespace)map.next();
                String tmpPrefix = ns.getPrefix();
                String value = ns.getNamespaceURI();
                if (!value.equals(nsURI) || prefix != null || usedPrefixes.contains(tmpPrefix)) continue;
                prefix = tmpPrefix;
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParent();
        }
        if (prefix == null) {
            while (usedPrefixes.contains(prefix = "ns" + DOMUtils.makeRandomStr())) {
            }
            elem.declareNamespace(nsURI, prefix);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    public static boolean includeNodeset(ArrayList nlA, ArrayList nlB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "includeNodeset(ArrayList nlA[" + nlA + "]," + "ArrayList nlB[" + nlB + "])");
        }
        boolean ret = true;
        if (nlA == null || nlA.size() == 0 || nlB == null || nlB.size() == 0 || nlB.size() > nlA.size()) {
            ret = false;
        } else {
            Object nB = nlB.get(0);
            if (!(nB instanceof OMElement)) {
                ret = false;
            } else {
                Object t1;
                int posA;
                int lenA = nlA.size();
                int lenB = nlB.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The count of all nodes in nlA is [" + lenA + "].");
                    Tr.debug(tc, "The count of all nodes in nlB is [" + lenB + "].");
                }
                int posB = 0;
                ArrayList<Integer> posElems = new ArrayList<Integer>();
                ArrayList elems = new ArrayList();
                ArrayList texts = null;
                ArrayList others = null;
                ArrayList attrs = null;
                ArrayList nss = null;
                HashMap as = new HashMap();
                HashMap ns = new HashMap();
                HashMap ts = new HashMap();
                HashMap os = new HashMap();
                for (posA = 0; posA < lenA; ++posA) {
                    t1 = nlA.get(posA);
                    if (t1 instanceof OMElement) {
                        if (elems.size() > 0) {
                            int lindex = elems.size() - 1;
                            as.put(elems.get(lindex), attrs);
                            ns.put(elems.get(lindex), nss);
                            ts.put(elems.get(lindex), texts);
                            os.put(elems.get(lindex), others);
                        }
                        elems.add(t1);
                        posElems.add(new Integer(posA));
                        attrs = new ArrayList();
                        nss = new ArrayList();
                        texts = new ArrayList();
                        others = new ArrayList();
                        continue;
                    }
                    if (t1 instanceof OMAttribute) {
                        attrs.add(t1);
                        continue;
                    }
                    if (t1 instanceof OMNamespace) {
                        nss.add(t1);
                        continue;
                    }
                    if (t1 instanceof OMText) {
                        texts.add(t1);
                        continue;
                    }
                    others.add(t1);
                }
                int lenElems = elems.size();
                int indexElems = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The count of elements in nlA is [" + lenElems + "].");
                }
                if (lenElems == 0) {
                    ret = false;
                } else {
                    int lindex = elems.size() - 1;
                    as.put(elems.get(lindex), attrs);
                    ns.put(elems.get(lindex), nss);
                    ts.put(elems.get(lindex), texts);
                    os.put(elems.get(lindex), others);
                }
                block1: while (indexElems < lenElems && nB != null) {
                    Object nA = null;
                    while (indexElems < lenElems) {
                        t1 = elems.get(indexElems);
                        if (DOMUtils.equals(t1, nB)) {
                            nA = t1;
                            posA = (Integer)posElems.get(indexElems);
                            break;
                        }
                        ++indexElems;
                    }
                    if (nA == null || lenA - posA < lenB - posB) {
                        ret = false;
                        break;
                    }
                    while (nA != null) {
                        ++posB;
                        attrs = (ArrayList)as.get(nA);
                        nss = (ArrayList)ns.get(nA);
                        texts = (ArrayList)ts.get(nA);
                        others = (ArrayList)os.get(nA);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The element is [" + nA + "]");
                            Tr.debug(tc, "The position of the element is [" + posA + "]");
                        }
                        nA = null;
                        if (++indexElems < lenElems) {
                            nA = elems.get(indexElems);
                        }
                        nB = null;
                        while (posB < lenB) {
                            int i;
                            boolean found = false;
                            boolean elemFound = false;
                            t1 = nlB.get(posB);
                            if (t1 instanceof OMElement) {
                                nB = t1;
                                elemFound = true;
                                found = true;
                            } else if (t1 instanceof OMAttribute) {
                                if (attrs.contains(t1)) {
                                    found = true;
                                } else {
                                    for (i = 0; i < attrs.size(); ++i) {
                                        if (!DOMUtils.equals(t1, attrs.get(i))) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else if (t1 instanceof OMNamespace) {
                                if (nss.contains(t1)) {
                                    found = true;
                                } else {
                                    for (i = 0; i < nss.size(); ++i) {
                                        if (!DOMUtils.equals(t1, nss.get(i))) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else if (t1 instanceof OMText) {
                                if (texts.contains(t1)) {
                                    found = true;
                                } else {
                                    for (i = 0; i < texts.size(); ++i) {
                                        if (!DOMUtils.equals(t1, texts.get(i))) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else if (others.contains(t1)) {
                                found = true;
                            } else {
                                for (i = 0; i < others.size(); ++i) {
                                    if (!DOMUtils.equals(t1, others.get(i))) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                ret = false;
                                break;
                            }
                            if (elemFound) break;
                            ++posB;
                        }
                        if (!ret || nB == null) continue block1;
                        if (nA == null && nB != null) {
                            ret = false;
                            continue block1;
                        }
                        nA = null;
                        while (indexElems < lenElems) {
                            t1 = (OMNode)elems.get(indexElems);
                            if (DOMUtils.equals(t1, nB)) {
                                nA = t1;
                                posA = (Integer)posElems.get(indexElems);
                                break;
                            }
                            ++indexElems;
                        }
                        if (nA != null && lenA - posA >= lenB - posB) continue;
                        ret = false;
                        continue block1;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "includeNodeset(ArrayList nlA, ArrayList nlB) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean equalsc14n(OMElement node1, OMElement node2, boolean useInclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsc14n(OMNode node1[" + DOMUtils.getDisplayName(node1) + "]," + "OMNode node2[" + DOMUtils.getDisplayName(node2) + "]," + "boolean useInclusive[" + useInclusive + "])");
        }
        boolean ret = false;
        if (node1.getLocalName().equals(node2.getLocalName())) {
            Hashtable h1 = null;
            Hashtable h2 = null;
            if (useInclusive) {
                h1 = DOMUtils.getPrefixList(node1);
                h2 = DOMUtils.getPrefixList(node2);
            }
            ByteArrayHolder e14n1 = ExclusiveCanonicalizer.serializeSubset(h1, node1, false);
            ByteArrayHolder e14n2 = ExclusiveCanonicalizer.serializeSubset(h2, node2, false);
            if (e14n1 != null && e14n2 != null) {
                return e14n1.equals(e14n2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsc14n(OMNode node1, OMNode node2, boolean useInclusive) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static Hashtable getPrefixList(OMNode node) {
        if (node == null || node.getType() != 1) {
            return null;
        }
        Hashtable<String, String> prefixList = new Hashtable<String, String>();
        for (OMContainer cur = (OMElement)node; cur != null && cur instanceof OMElement; cur = cur.getParent()) {
            Iterator map = cur.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                String value;
                OMNamespace ns = (OMNamespace)map.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.equals("")) {
                    value = "#default";
                    prefixList.put(value, value);
                    continue;
                }
                value = prefix;
                prefixList.put(value, value);
            }
        }
        DOMUtils.scanNamespaceDecls((OMElement)node, prefixList);
        if (prefixList.size() == 0) {
            prefixList = null;
        }
        return prefixList;
    }

    private static void scanNamespaceDecls(OMElement node, Hashtable<String, String> prefixList) {
        Iterator map = node.getAllDeclaredNamespaces();
        while (map.hasNext()) {
            String value;
            OMNamespace ns = (OMNamespace)map.next();
            if (ns instanceof OMNamespaceWithOwner) continue;
            String prefix = ns.getPrefix();
            if (prefix == null || prefix.equals("")) {
                value = "#default";
                prefixList.put(value, value);
                continue;
            }
            value = prefix;
            prefixList.put(value, value);
        }
        for (OMNode n = node.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            if (n.getType() != 1) continue;
            DOMUtils.scanNamespaceDecls((OMElement)n, prefixList);
        }
    }

    public static boolean equals(Object node1, Object node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(Node node1[" + node1 + "]," + "Node node2[" + node2 + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (node1 == null || node2 == null) {
            ret = false;
        } else if (node1.equals(node2)) {
            ret = true;
        } else if (node1 instanceof OMElement) {
            if (node2 instanceof OMElement) {
                ret = DOMUtils.equalsElement((OMElement)node1, (OMElement)node2);
            }
        } else if (node1 instanceof OMAttribute) {
            if (node2 instanceof OMAttribute) {
                ret = DOMUtils.equalsAttribute((OMAttribute)node1, (OMAttribute)node2);
            }
        } else if (node1 instanceof OMNamespace) {
            if (node2 instanceof OMNamespace) {
                ret = DOMUtils.equalsNamespace((OMNamespace)node1, (OMNamespace)node2);
            }
        } else if (node1 instanceof OMText) {
            if (node2 instanceof OMText) {
                ret = DOMUtils.equalsTextValue((OMText)node1, (OMText)node2);
            }
        } else {
            ret = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(Node node1,Node node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    static {
        INDENT_NS.add(Constants.NS_WSSE);
        INDENT_NS.add(Constants.NS_WSSE200306);
        INDENT_NS.add(Constants.NS_WSU);
        INDENT_NS.add(Constants.NS_WSU200306);
        INDENT_NS.add(Constants.NS_DSIG);
        INDENT_NS.add(Constants.NS_ENC);
        INDENT_NS.add(Constants.NS_WSU);
    }
}

