/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Serializer;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.StAXUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtil
extends com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DOMUtil.class.getName();
    private static final PrivilegedAction<Object> contextLoaderGetter = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final HashSet<String> INDENT_NS = new HashSet();

    public static OMDocument parse(InputSource in, boolean validating) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse(InputStream in,boolean validating[" + validating + "])");
        }
        OMDocument doc = null;
        try {
            StAXOMBuilder builder;
            XMLStreamReader xmlReader;
            XMLInputFactory factory = StAXUtils.getXMLInputFactory();
            factory.setXMLResolver(new JarXMLResolver());
            InputStream is = in.getByteStream();
            if (is != null) {
                xmlReader = factory.createXMLStreamReader(in.getSystemId(), is);
                builder = new StAXOMBuilder(xmlReader);
            } else {
                Reader reader = in.getCharacterStream();
                xmlReader = factory.createXMLStreamReader(in.getSystemId(), reader);
                builder = new StAXOMBuilder(xmlReader);
            }
            while (!builder.isCompleted()) {
                builder.next();
            }
            xmlReader.close();
            doc = builder.getDocument();
            factory.setXMLResolver(null);
            StAXUtils.releaseXMLInputFactory(factory);
        }
        catch (XMLStreamException e) {
            Tr.processException(e, clsName + ".parse", "142");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{e});
            Tr.debug(tc, "Exception received in DOMUtil.parse()");
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", e);
        }
        catch (Exception ex) {
            Tr.processException(ex, clsName + ".parse", "147");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{ex});
            Tr.debug(tc, "Exception received in DOMUtil.parse()");
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse(InputStream in,boolean validating) returns OMDocument[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static OMDocument getPrivateConfig(boolean sender) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(boolean sender[" + sender + "])");
        }
        String file = sender ? "config/ibm-wssecurity-sender-private.xml" : "config/ibm-wssecurity-receiver-private.xml";
        OMDocument doc = DOMUtil.getPrivateConfig(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(boolean sender) returns OMDocument[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    protected static OMDocument getPrivateConfig(final String file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(String file[" + file + "])");
        }
        OMDocument doc = null;
        try {
            doc = (OMDocument)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    InputSource src = DOMUtil.getResourceAsInputSource(file);
                    return DOMUtil.parse(src, true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            SoapSecurityException e = (SoapSecurityException)pae.getException();
            Tr.processException(e, clsName + ".getPrivateCofig", "163");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            Throwable cause = e.getCauseException();
            if (cause != null) {
                throw new IllegalArgumentException(e.getMessage() + ": " + cause.getMessage());
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".getPrivateConfig", "173");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(String file) returns OMDocument[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static OMDocument getConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigValidation()");
        }
        String file = "config/ibm-wssecurity-config-validation.xml";
        OMDocument doc = null;
        try {
            doc = (OMDocument)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    InputSource src = DOMUtil.getResourceAsInputSource("config/ibm-wssecurity-config-validation.xml");
                    return DOMUtil.parse(src, true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            SoapSecurityException e = (SoapSecurityException)pae.getException();
            Tr.processException(e, clsName + ".getPrivateCofig", "202");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            Throwable cause = e.getCauseException();
            if (cause != null) {
                throw new IllegalArgumentException(e.getMessage() + ": " + cause.getMessage());
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".getPrivateConfig", "212");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigValidation() returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static InputSource getResourceAsInputSource(String path) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAsInputSource(String path[" + path + "])");
        }
        InputStream in = null;
        URL url = null;
        ClassLoader loader = DOMUtil.class.getClassLoader();
        in = loader.getResourceAsStream(path);
        url = loader.getResource(path);
        if (in == null) {
            in = loader.getResourceAsStream("/" + path);
            url = loader.getResource("/" + path);
        }
        if (in == null) {
            loader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
            if (loader == null) {
                in = ClassLoader.getSystemResourceAsStream(path);
                url = ClassLoader.getSystemResource(path);
                if (in == null) {
                    in = ClassLoader.getSystemResourceAsStream("/" + path);
                    url = ClassLoader.getSystemResource("/" + path);
                }
            } else {
                in = loader.getResourceAsStream(path);
                url = loader.getResource(path);
                if (in == null) {
                    in = loader.getResourceAsStream("/" + path);
                    url = loader.getResource("/" + path);
                }
            }
        }
        if (in == null || url == null) {
            throw new RuntimeException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s03", new String[]{path}));
        }
        InputSource is = new InputSource(in);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting SystemId on InputSource =" + url.toExternalForm());
        }
        is.setSystemId(url.toExternalForm());
        if (tc.isEntryEnabled()) {
            String isStr = is == null ? "null" : "not null";
            Tr.exit(tc, "getResourceAsInputSource(String path) returns InputSource[" + isStr + "]");
        }
        return is;
    }

    public static String toString(OMNode node) {
        String str = DOMUtil.toString(node, null);
        return str;
    }

    public static String toString(OMNode node, String enc) {
        String dataString = null;
        if (node != null) {
            byte[] data = null;
            try {
                data = Serializer.serialize(node);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Internal Error: " + ioe);
            }
            try {
                dataString = enc == null ? new String(data) : new String(data, enc);
            }
            catch (Exception e) {
                dataString = new String(data);
            }
        }
        return dataString;
    }

    public static OMDocument createDocument() throws SoapSecurityException {
        OMDocument doc = null;
        doc = OMAbstractFactory.getOMFactory().createOMDocument();
        return doc;
    }

    public static OMElement getZeroOrOneElement(OMElement config2, String ns, String name) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(OMElement config[" + DOMUtil.getDisplayName(config2) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        OMElement elem = null;
        ArrayList list = DOMUtil.getElementsByTagNameNS(config2, ns, name);
        if (list.size() != 0) {
            if (list.size() == 1) {
                elem = (OMElement)list.get(0);
            } else {
                String param = (ns != null ? "{" + ns + "}" : "") + name;
                throw SoapSecurityException.format("security.wssecurity.RequestReceiverConfig.sconf02", param);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(OMElement config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static OMElement getZeroOrOneElement(OMDocument config2, String ns, String name) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(OMDocument config[" + DOMUtil.getDisplayName(config2.getOMDocumentElement()) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        OMElement elem = DOMUtil.getZeroOrOneElement(config2.getOMDocumentElement(), ns, name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(OMDocument config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static OMElement getOneElement(OMElement config2, String ns, String name) throws SoapSecurityException {
        ArrayList list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(OMElement config[" + DOMUtil.getDisplayName(config2) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        if ((list = DOMUtil.getElementsByTagNameNS(config2, ns, name)).size() != 1) {
            String param = (ns != null ? "{" + ns + "}" : "") + name;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", param);
        }
        OMElement elem = (OMElement)list.get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(OMElement config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static OMElement getOneElement(OMDocument config2, String ns, String name) throws SoapSecurityException {
        ArrayList list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(OMDocument config[" + DOMUtil.getDisplayName(config2.getOMDocumentElement()) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        if ((list = DOMUtil.getElementsByTagNameNS(config2.getOMDocumentElement(), ns, name)).size() != 1) {
            String param = (ns != null ? "{" + ns + "}" : "") + name;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", param);
        }
        OMElement elem = (OMElement)list.get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(OMDocument config,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static ArrayList getHeadersForNamespace(OMElement parent, String ns, String name, String actorOrRole, int version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeadersForNamespace(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "]," + "String actorOrRole[" + actorOrRole + "]," + "int version[" + version + "])");
        }
        boolean namespaceOnly = false;
        if (name == null) {
            namespaceOnly = true;
        }
        ArrayList<OMNode> children = new ArrayList<OMNode>();
        for (OMNode node = parent.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1 || !DOMUtil.equals(node, ns, name, actorOrRole, version, namespaceOnly)) continue;
            children.add(node);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Found header with name [" + ((OMElement)node).getLocalName() + " and namespace [" + ns + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeadersForNamespace(OMElement parent,String ns,String name,String actorOrRole,int version) returns NodeList[" + children + "]");
        }
        return children;
    }

    public static ArrayList<OMNode> getChildElements(OMElement parent, String ns, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElements(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        ArrayList<OMNode> children = new ArrayList<OMNode>();
        for (OMNode node = parent.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1 || !DOMUtil.equals(node, ns, name)) continue;
            children.add((OMElement)node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElements(OMElement parent,String ns,String name) returns ArrayList[" + children + "]");
        }
        return children;
    }

    public static OMElement getChildElement(OMElement parent, String ns, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElement(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        OMElement child = null;
        for (OMNode node = parent.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1 || !DOMUtil.equals(node, ns, name)) continue;
            child = (OMElement)node;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElement(OMElement parent,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static OMElement getAncestorElement(OMElement element, String ns, String name) {
        OMElement elem;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAncestorElement(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
            }
            elem = null;
            try {
                if (DOMUtil.equals(element, ns, name)) {
                    elem = element;
                    break block7;
                }
                OMContainer parent = element.getParent();
                while (parent != null && element != parent) {
                    if (parent instanceof OMElement) {
                        elem = DOMUtil.getAncestorElement((OMElement)parent, ns, name);
                        break;
                    }
                    parent = null;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wssecurity.util.DOMUtil.getAncestorElement", "687");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAncestorElement(OMElement element,String ns,String name) returns OMElement[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static boolean equals(OMNode node, String ns, String name, String actorOrRole, int soapVersion, boolean namespaceOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + ns + "]," + "String name[" + name + "]," + "String actorOrRole[" + actorOrRole + "]," + "int soapVersion[" + soapVersion + "]," + "boolean namespaceOnly[" + namespaceOnly + "])");
        }
        boolean ret = false;
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            if (namespaceOnly) {
                ret = DOMUtil.equals(elem.getNamespace() == null ? null : elem.getNamespace().getNamespaceURI(), ns);
            } else {
                boolean bl = ret = DOMUtil.equals(elem.getNamespace() == null ? null : elem.getNamespace().getName(), ns) && DOMUtil.equals(elem.getLocalName(), name);
            }
            if (ret) {
                String act = null;
                if (soapVersion == 1) {
                    act = elem.getAttributeValue(Constants.SOAP12_ROLE_Q);
                } else if (soapVersion == 0) {
                    act = elem.getAttributeValue(Constants.SOAP11_ACTOR_Q);
                }
                if (actorOrRole == null || actorOrRole.length() == 0) {
                    if (act != null && act.trim().length() != 0) {
                        ret = false;
                    }
                } else if (!actorOrRole.equals(act)) {
                    ret = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node,String ns,String name,String actorOrRole,int soapVersion,boolean namespaceOnly) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean equals(OMNode node, String ns, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        boolean ret = false;
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            boolean bl = ret = DOMUtil.equals(elem.getNamespace() == null ? null : elem.getNamespace().getName(), ns) && DOMUtil.equals(elem.getLocalName(), name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node,String ns,String name) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equals(String str1, String str2) {
        boolean ret = str1 == null && str2 == null || str1 != null && str1.equals(str2);
        return ret;
    }

    public static boolean equals(OMNode node1, OMNode node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(OMNode node1[" + DOMUtil.getDisplayName(node1) + "]," + "OMNode node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (node1 == null || node2 == null) {
            ret = false;
        } else if (node1.equals(node2)) {
            ret = true;
        } else if (node1.getType() != node2.getType()) {
            ret = false;
        } else {
            switch (node1.getType()) {
                case 1: {
                    ret = DOMUtil.equalsElement((OMElement)node1, (OMElement)node2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    ret = DOMUtil.equalsTextValue((OMText)node1, (OMText)node2);
                    break;
                }
                case 9: {
                    ret = DOMUtil.equalsNodeName(node1, node2);
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(OMNode node1, OMNode node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean equalsElement(OMElement node1, OMElement node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsElement(OMElement node1[" + DOMUtil.getDisplayName(node1) + "]," + "OMElement node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getNamespace() == null ? null : node1.getNamespace().getName(), node2.getNamespace() == null ? null : node2.getNamespace().getName()) && DOMUtil.equals(node1.getLocalName(), node2.getLocalName())) {
            OMContainer n1 = node1.getParent();
            OMContainer n2 = node2.getParent();
            if (n1 != null && n2 != null && n1 instanceof OMDocument && n2 instanceof OMDocument) {
                return true;
            }
            if (n1 instanceof OMDocument != n2 instanceof OMDocument) {
                return false;
            }
            OMElement nc1 = DOMUtil.getFirstElement((OMElement)n1);
            OMElement nc2 = DOMUtil.getFirstElement((OMElement)n2);
            while (nc1 != null && nc2 != null) {
                if (nc1.equals(node1) && nc2.equals(node2)) {
                    ret = DOMUtil.equals((OMElement)n1, (OMElement)n2);
                    break;
                }
                nc1 = DOMUtil.getNextElement(nc1);
                nc2 = DOMUtil.getNextElement(nc2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsElement(OMElement node1, OMElement node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean equalsAttribute(OMAttribute node1, OMAttribute node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + node1 + "]," + "Attr node2[" + node2 + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getAttributeValue(), node2.getAttributeValue()) && DOMUtil.equals(node1.getLocalName(), node2.getLocalName())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean equalsNamespace(OMNamespace node1, OMNamespace node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + node1 + "]," + "Attr node2[" + node2 + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getPrefix(), node2.getPrefix()) && DOMUtil.equals(node1.getName(), node2.getName())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean equalsTextValue(OMText node1, OMText node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsTextValue(OMText node1[" + DOMUtil.getDisplayName(node1) + "]," + "OMText node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getText(), node2.getText())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsTextValue(OMText node1, OMText node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equalsNodeName(OMNode node1, OMNode node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsNodeName(OMNode node1[" + DOMUtil.getDisplayName(node1) + "]," + "OMNode node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (node1.getType() == 1 && node2.getType() == 1) {
            OMElement elem1 = (OMElement)node1;
            OMElement elem2 = (OMElement)node2;
            if (DOMUtil.equals(elem1.getLocalName(), elem2.getLocalName()) && DOMUtil.equals(elem1.getNamespace() == null ? null : elem1.getNamespace().getName(), elem2.getNamespace() == null ? null : elem2.getNamespace().getName())) {
                ret = true;
            }
        } else if (node1.getType() == 4 && node2.getType() == 4 && DOMUtil.equals(((OMText)node1).getText(), ((OMText)node2).getText())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsNodeName(OMNode node1,OMNode node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static ArrayList<OMNode> getOneOrMoreChildElements(OMElement parent, String ns, String name) throws SoapSecurityException {
        ArrayList<OMNode> children;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreChildElements(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        if ((children = DOMUtil.getChildElements(parent, ns, name)).size() <= 0) {
            String param = (ns != null ? "{" + ns + "}" : "") + name;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", param);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreChildElements(OMElement parent,String ns,String name) returns ArrayList[" + children + "]");
        }
        return children;
    }

    public static ArrayList<OMNode> getOneOrMoreElements(OMElement parent, String ns, String name) throws SoapSecurityException {
        ArrayList descendants;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreElements(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        if ((descendants = DOMUtil.getElementsByTagNameNS(parent, ns, name)).size() <= 0) {
            String param = (ns != null ? "{" + ns + "}" : "") + name;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", param);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreElements(OMElement parent,String ns,String name) retuns ArrayList[" + descendants + "]");
        }
        return descendants;
    }

    public static String getAttribute(OMElement element, String name) throws SoapSecurityException {
        String attrValue = element.getAttributeValue(new QName("", name));
        if (attrValue == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf10", element.getLocalName(), name);
        }
        return attrValue;
    }

    public static OMElement getOneChildElement(OMElement parent, String ns, String name) throws SoapSecurityException {
        OMElement child;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name + "])");
        }
        if ((child = DOMUtil.getChildElement(parent, ns, name)) == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(OMElement parent,String ns,String name) retuns OMElement[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static OMElement getOneChildElement(OMElement parent, String ns, String[] names) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(OMElement parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String[] names[" + names + "])");
        }
        OMElement child = null;
        for (int i = 0; i < names.length && (child = DOMUtil.getChildElement(parent, ns, names[i])) == null; ++i) {
        }
        if (child == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(names[i]);
            }
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(OMElement parent,String ns,String[] names) retuns OMElement[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static OMNode getNextSibling2(OMNode node) {
        OMContainer parent;
        OMNode ret = node.getNextOMSibling();
        if (ret == null && ((parent = node.getParent()) == null || parent instanceof OMDocument)) {
            return null;
        }
        return ret;
    }

    public static OMNode getPreviousSibling2(OMNode node) {
        OMContainer parent;
        OMNode ret = node.getPreviousOMSibling();
        if (ret == null && ((parent = node.getParent()) == null || parent instanceof OMDocument)) {
            return null;
        }
        return ret;
    }

    public static OMNode getFirstChild2(OMNode node) {
        OMNode ret = null;
        if (node != null && node.getType() == 1) {
            ret = ((OMElement)node).getFirstOMChild();
        }
        return ret;
    }

    public static OMNode getLastChild2(OMNode node) {
        OMNode ret = null;
        if (node != null && node.getType() == 1) {
            OMElement elem = (OMElement)node;
            Iterator i = elem.getChildren();
            while (i.hasNext()) {
                ret = (OMNode)i.next();
            }
        }
        return ret;
    }

    public static OMElement getFirstElement(OMNode parent) {
        OMNode child = DOMUtil.getFirstChild2(parent);
        while (child != null && child.getType() != 1) {
            child = DOMUtil.getNextSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getFirstElement(OMNode parent, String ns, String name) {
        OMNode child = DOMUtil.getFirstChild2(parent);
        while (child != null) {
            if (child.getType() == 1) {
                String elns;
                OMElement el = (OMElement)child;
                String string = elns = el.getNamespace() == null ? null : el.getNamespace().getName();
                if ((name.equals("*") || el.getLocalName().equals(name)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getLastElement(OMNode parent) {
        OMNode child = DOMUtil.getLastChild2(parent);
        while (child != null && child.getType() != 1) {
            child = DOMUtil.getPreviousSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getLastElement(OMNode parent, String ns, String name) {
        OMNode child = DOMUtil.getLastChild2(parent);
        while (child != null) {
            if (child.getType() == 1) {
                String elns;
                OMElement el = (OMElement)child;
                String string = elns = el.getNamespace() == null ? null : el.getNamespace().getName();
                if ((name.equals("*") || el.getLocalName().equals(name)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getPreviousSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getNextElement(OMNode node) {
        OMNode next = node;
        while ((next = DOMUtil.getNextSibling2(next)) != null) {
            if (next == node) {
                next = null;
                break;
            }
            if (next.getType() != 1) continue;
        }
        OMElement ret = (OMElement)next;
        return ret;
    }

    public static String getStringValue(OMNode node) {
        String ret = null;
        switch (node.getType()) {
            case 1: 
            case 9: {
                OMNode child = ((OMElement)node).getFirstOMChild();
                if (child == null) {
                    ret = "";
                    break;
                }
                if (child == DOMUtil.getLastChild2(node) && (child.getType() == 4 || child.getType() == 12)) {
                    ret = ((OMText)child).getText();
                    break;
                }
                StringBuffer buf = new StringBuffer();
                DOMUtil.getStringValue0(node, buf);
                ret = new String(buf);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                ret = ((OMText)node).getText();
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unexpected node type: " + node.getType());
            }
        }
        return ret;
    }

    private static void getStringValue0(OMNode n, StringBuffer buf) {
        switch (n.getType()) {
            case 1: 
            case 9: {
                for (OMNode ch = ((OMElement)n).getFirstOMChild(); ch != null; ch = ch.getNextOMSibling()) {
                    DOMUtil.getStringValue0(ch, buf);
                }
                break;
            }
            case 4: 
            case 12: {
                DOMUtil.getStringValueFromText((OMText)n, buf);
                break;
            }
        }
    }

    private static void getStringValueFromText(OMText omText, StringBuffer buffer) {
        Object dh;
        if (omText.isOptimized() && (dh = omText.getDataHandler()) instanceof DataHandler) {
            try {
                InputStream is = ((DataHandler)dh).getInputStream();
                if (is != null) {
                    DOMUtil.toStringValueFromInputStream(is, buffer);
                    return;
                }
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException("Internal Error: Unexpected IOException: " + e.getMessage());
                rte.initCause(e);
                throw rte;
            }
        }
        buffer.append(omText.getText());
    }

    private static void toStringValueFromInputStream(InputStream inStream, StringBuffer buffer) throws IOException {
        int avail = inStream.available();
        if (avail > 0) {
            buffer.ensureCapacity((int)((double)avail * 1.4) + buffer.length());
        }
        do {
            int len;
            byte[] data = new byte[1023];
            while ((len = inStream.read(data)) > 0) {
                Base64.encode(data, 0, len, buffer);
            }
        } while (inStream.available() > 0);
    }

    public static void removeIndentation(OMElement element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(OMElement element[" + DOMUtil.getDisplayName(element) + "])");
        }
        OMNode child = element.getFirstOMChild();
        while (child != null) {
            if (child.getType() == 1) {
                DOMUtil.removeIndentation((OMElement)child);
                child = child.getNextOMSibling();
                continue;
            }
            if (child.getType() == 4 || child.getType() == 12) {
                OMNode node = child;
                if (DOMUtil.isAllSpace(child)) {
                    child = child.getNextOMSibling();
                    node.detach();
                    continue;
                }
                if (DOMUtil.hasSpace(child)) {
                    DOMUtil.trimSpaces(child);
                    child = child.getNextOMSibling();
                    continue;
                }
                child = child.getNextOMSibling();
                continue;
            }
            child = child.getNextOMSibling();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(OMElement element)");
        }
    }

    public static void indent(OMElement element, int init, int diff) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "indent(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "int init[" + init + "]," + "int diff[" + diff + "])");
        }
        int sp = init + diff;
        if (INDENT_NS.contains(element.getNamespace() == null ? null : element.getNamespace().getName())) {
            OMFactory factory = element.getOMFactory();
            OMNode prev = null;
            for (OMNode child = element.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                if (child.getType() == 1) {
                    if (prev == null || prev.getType() != 4) {
                        child.insertSiblingBefore(DOMUtil.createTextNode(factory, sp));
                    } else if (DOMUtil.isAllSpace(prev)) {
                        prev.insertSiblingBefore(DOMUtil.createTextNode(factory, sp));
                        prev.detach();
                    }
                    DOMUtil.indent((OMElement)child, sp, diff);
                }
                prev = child;
            }
            if (prev == null || prev.getType() != 4) {
                element.addChild(DOMUtil.createTextNode(factory, init));
            } else if (DOMUtil.isAllSpace(prev)) {
                prev.insertSiblingBefore(DOMUtil.createTextNode(factory, init));
                prev.detach();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "indent(OMElement element, int init, int diff)");
        }
    }

    protected static OMNode createTextNode(OMFactory factory, int spaces) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextNode(OMFactory factory[" + factory + "]," + "int spaces[" + spaces + "])");
        }
        StringBuffer buffer = new StringBuffer(1 + spaces);
        buffer.append("\n");
        for (int i = 0; i < spaces; ++i) {
            buffer.append(" ");
        }
        OMText ret = factory.createOMText(new String(buffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTextNode(OMFactory factory, int spaces) returns OMNode[" + ret + "]");
        }
        return ret;
    }

    protected static boolean isAllSpace(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllSpace(OMNode node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if (node.getType() != 4) {
            return false;
        }
        boolean ret = true;
        String s = ((OMText)node).getText();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') continue;
            ret = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllSpace(OMNode node) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean hasSpace(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSpace(OMNode node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if (node.getType() != 4) {
            return false;
        }
        boolean ret = false;
        String s = ((OMText)node).getText();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') continue;
            ret = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSpace(OMNode node) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static void trimSpaces(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimSpaces(OMNode node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if (node.getType() != 4) {
            return;
        }
        boolean ignoreSpace = false;
        String s = ((OMText)node).getText();
        StringBuffer buffer = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\r' || ch == '\n') {
                ignoreSpace = false;
                continue;
            }
            if (!ignoreSpace && (ch == ' ' || ch == '\t')) continue;
            ignoreSpace = true;
            buffer.append(ch);
        }
        node.insertSiblingBefore(node.getOMFactory().createOMText(new String(buffer)));
        node.detach();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimSpaces(OMNode node)");
        }
    }

    public static QName getQName(OMElement element, String qNameStr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String qNameStr[" + qNameStr + "])");
        }
        String prefix = null;
        String localPart = null;
        int index = qNameStr.indexOf(":");
        if (index == -1) {
            prefix = "";
            localPart = qNameStr;
        } else {
            prefix = qNameStr.substring(0, index);
            localPart = qNameStr.substring(index + 1);
        }
        OMContainer n = element;
        String nsURI = "";
        while (n instanceof OMElement) {
            Iterator nss = n.getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (!prefix.equals(ns.getPrefix())) continue;
                nsURI = ns.getName();
                break;
            }
            if (!nsURI.equals("")) break;
            n = n.getParent();
        }
        QName ret = new QName(nsURI, localPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(Element element, String qNameStr) returns QName[" + ret + "]");
        }
        return ret;
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue, int wssVersion) {
        String attrLocal;
        String attrPrefix;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "]," + "int wssVersion[" + wssVersion + "])");
        }
        String strQName = DOMUtil.setQName0(element, attrValue, wssVersion);
        int index = attrName.indexOf(":");
        if (index == -1) {
            attrPrefix = "";
            attrLocal = attrName;
        } else {
            attrPrefix = attrName.substring(0, index);
            attrLocal = attrName.substring(index + 1);
        }
        element.addAttribute(attrLocal, strQName, element.getOMFactory().createOMNamespace(attrNameNS, attrPrefix));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue,int wssVersion)");
        }
    }

    private static String setQName0(OMElement elem, QName qName, int wssVersion) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        if (nsURI == null || nsURI.length() == 0 && wssVersion == 0) {
            return localPart;
        }
        OMContainer n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof OMElement) {
            Iterator map = n.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                OMNamespace ns = (OMNamespace)map.next();
                String tmpPrefix = ns.getPrefix();
                String value = ns.getNamespaceURI();
                if (value.equals(nsURI) && prefix == null && !usedPrefixes.contains(tmpPrefix)) {
                    prefix = tmpPrefix;
                }
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParent();
        }
        if (prefix == null) {
            while (usedPrefixes.contains(prefix = "ns" + DOMUtil.makeRandomStr())) {
            }
            elem.declareNamespace(nsURI, prefix);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue) {
        String attrLocal;
        String attrPrefix;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "])");
        }
        String strQName = DOMUtil.setQName0(element, attrValue);
        int index = attrName.indexOf(":");
        if (index == -1) {
            attrPrefix = "";
            attrLocal = attrName;
        } else {
            attrPrefix = attrName.substring(0, index);
            attrLocal = attrName.substring(index + 1);
        }
        if (attrNameNS == null) {
            element.addAttribute(attrLocal, strQName, null);
        } else {
            element.addAttribute(attrLocal, strQName, element.getOMFactory().createOMNamespace(attrNameNS, attrPrefix));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(OMElement element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(OMElement element, QName text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameText(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "QName text[" + text + "])");
        }
        String strQName = DOMUtil.setQName0(element, text);
        OMFactory doc = element.getOMFactory();
        element.addChild(doc.createOMText(strQName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameText(OMElement element, QName text)");
        }
    }

    private static String setQName0(OMElement elem, QName qName) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        OMContainer n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof OMElement) {
            Iterator map = n.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                OMNamespace ns = (OMNamespace)map.next();
                String tmpPrefix = ns.getPrefix();
                String value = ns.getNamespaceURI();
                if (!value.equals(nsURI) || prefix != null || usedPrefixes.contains(tmpPrefix)) continue;
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParent();
        }
        if (prefix == null) {
            prefix = nsURI != null && nsURI.length() != 0 ? "ns" + nsURI.hashCode() : "ns" + qName.hashCode();
            while (usedPrefixes.contains(prefix)) {
                prefix = "ns" + DOMUtil.makeRandomStr();
            }
            elem.declareNamespace(nsURI, prefix);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    protected static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static OMElement StringToElement(String namespace, String name, String str) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringToElement(String namespace[" + namespace + "]," + "String name[" + name + "]," + "String str[" + str + "])");
        }
        OMElement ret = null;
        OMDocument doc = DOMUtil.createDocument();
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        OMElement element = null;
        element = namespace == null || namespace.length() == 0 ? factory.createOMElement(name, "", "") : factory.createOMElement(name, namespace, "");
        OMText text = factory.createOMText(str);
        element.addChild(text);
        ret = element;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringToElement(String namespace,String name,String str) returns OMElement[" + ret + "]");
        }
        return ret;
    }

    public static boolean hasNamespaceDeclaration(OMElement element, String namespace) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        boolean bl = ret = DOMUtil.getNamespaceDeclaration(element, namespace) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNamespaceDeclaration(OMElement element,String namespace) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static String getNamespacePrefix(OMElement element, String namespace) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespacePrefix(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        String prefix = null;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns != null && ns.equals(namespace)) {
            prefix = element.getNamespace().getPrefix();
        } else {
            OMContainer parent;
            OMNamespace a = DOMUtil.getNamespaceDeclaration(element, namespace);
            if (a != null) {
                prefix = a.getPrefix();
            }
            if (prefix == null && (parent = element.getParent()) != null && parent instanceof OMElement) {
                prefix = DOMUtil.getNamespacePrefix((OMElement)parent, namespace);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespacePrefix(OMElement element,String namespace) returns String[" + prefix + "]");
        }
        return prefix;
    }

    public static OMNamespace getNamespaceDeclaration(OMElement element, String namespace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        Iterator aa = element.getAllDeclaredNamespaces();
        OMNamespace attr = null;
        while (aa.hasNext()) {
            OMNamespace a = (OMNamespace)aa.next();
            String s = a.getName();
            if (!namespace.equals(s)) continue;
            attr = a;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceDeclaration(OMElement element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static OMNamespace removeNamespaceDeclaration(OMElement element, String namespace) {
        OMNamespace attr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNamespaceDeclaration(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        if ((attr = DOMUtil.getNamespaceDeclaration(element, namespace)) != null) {
            element.declareNamespace(null, attr.getPrefix());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNamespaceDeclaration(OMElement element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static Collection<OMNamespace> getEffectiveNamespaceDeclarations(OMNode node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        Collection attrs = null;
        if (node != null) {
            HashMap<String, OMNamespace> m = new HashMap<String, OMNamespace>();
            DOMUtil.getEffectiveNamespaceDeclarations(node, node, inclusive, m);
            OMNamespace a = node.getOMFactory().createOMNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            m.put(a.getPrefix(), a);
            attrs = m.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(OMNode node,boolean inclusive) returns Collection[" + attrs + "]");
        }
        return attrs;
    }

    private static void getEffectiveNamespaceDeclarations(OMNode current, OMNode start, boolean inclusive, Map<String, OMNamespace> name2Attr) {
        OMContainer parent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(OMNode current[" + DOMUtil.getDisplayName(current) + "]," + "OMNode start[" + DOMUtil.getDisplayName(start) + "]," + "boolean inclusive[" + inclusive + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil.hasParentNode(current) && (parent = current.getParent()) instanceof OMElement) {
            DOMUtil.getEffectiveNamespaceDeclarations((OMElement)parent, start, inclusive, name2Attr);
        }
        if ((current != start || inclusive) && current.getType() == 1) {
            Iterator nnm = ((OMElement)current).getAllDeclaredNamespaces();
            while (nnm.hasNext()) {
                OMNamespace a = (OMNamespace)nnm.next();
                name2Attr.put(a.getPrefix(), a);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(OMNode current,OMNode start,boolean inclusive,Map name2Attr)");
        }
    }

    public static Collection<OMAttribute> getEffectiveXMLPrefixedAttributes(OMNode node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveXMLPrefixedAttributes(OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        Collection attrs = null;
        if (node != null) {
            HashMap<String, OMAttribute> m = new HashMap<String, OMAttribute>();
            DOMUtil.getEffectiveAttributes(node, node, inclusive, new String[]{"xml"}, m);
            attrs = m.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveXMLPrefixedAttributes(OMNode node,boolean inclusive) returns Collection[" + attrs + "]");
        }
        return attrs;
    }

    private static void getEffectiveAttributes(OMNode current, OMNode start, boolean inclusive, String[] names, Map<String, OMAttribute> name2Attr) {
        OMContainer parent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveAttributes(OMNode current[" + DOMUtil.getDisplayName(current) + "]," + "OMNode start[" + DOMUtil.getDisplayName(start) + "]," + "String[] names," + "boolean inclusive[" + inclusive + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil.hasParentNode(current) && (parent = current.getParent()) instanceof OMElement) {
            DOMUtil.getEffectiveAttributes((OMElement)parent, start, inclusive, names, name2Attr);
        }
        if ((current != start || inclusive) && current.getType() == 1) {
            Iterator nnm = ((OMElement)current).getAllAttributes();
            while (nnm.hasNext()) {
                OMAttribute a = (OMAttribute)nnm.next();
                String s = a.getNamespace().getPrefix();
                if (names == null) continue;
                int il = names.length;
                for (int i = 0; i < il; ++i) {
                    if (!s.equals(names[i])) continue;
                    name2Attr.put(s, a);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveAttributes(OMNode current,OMNode start,String[] names,boolean inclusive,Map name2Attr)");
        }
    }

    public static Map<String, String> getAllAncestorPrefixNSUriMap(OMElement omElement, boolean includeThisOMElement) {
        if (omElement == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        OMContainer parent = omElement;
        if (!includeThisOMElement) {
            parent = omElement.getParent();
        }
        while (parent instanceof OMElement) {
            OMContainer om = parent;
            Iterator ite = om.getAllDeclaredNamespaces();
            while (ite.hasNext()) {
                OMNamespace omn = (OMNamespace)ite.next();
                String prefix = omn.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (map.containsKey(prefix)) continue;
                String nsUri = omn.getNamespaceURI();
                if (nsUri == null) {
                    nsUri = "";
                }
                map.put(prefix, nsUri);
            }
            parent = om.getParent();
        }
        return map;
    }

    public static OMElement createDummyElement(OMElement element, OMDocument factory, OMNode node, boolean inclusive) {
        Collection<OMNamespace> c;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMElement element[" + DOMUtil.getDisplayName(element) + "]," + "OMDocument factory[" + DOMUtil.getDisplayName(factory.getOMDocumentElement()) + "]," + "OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        String s1 = null;
        String s2 = "dummy";
        if (element != null) {
            s1 = element.getNamespace() == null ? null : element.getNamespace().getName();
            s2 = element.getLocalName();
        }
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement dummy = factory.getOMDocumentElement().getOMFactory().createOMElement(s2, s1, null);
        if (node != null && (c = DOMUtil.getEffectiveNamespaceDeclarations(node, inclusive)) != null && c.size() > 0) {
            for (OMNamespace a : c) {
                dummy.declareNamespace(a);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMElement element,OMDocument factory,OMNode node,boolean inclusive) returns OMElement[" + DOMUtil.getDisplayName(dummy) + "]");
        }
        return dummy;
    }

    public static OMElement createDummyElement(OMDocument factory, OMNode node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMDocument factory[" + DOMUtil.getDisplayName(factory.getOMDocumentElement()) + "]," + "OMNode node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        OMElement dummy = DOMUtil.createDummyElement(null, factory, node, inclusive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMDocument factory,OMNode node,boolean inclusive) returns OMElement[" + DOMUtil.getDisplayName(dummy) + "]");
        }
        return dummy;
    }

    public static OMElement createDummyElement(OMDocument factory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(OMDocument factory[" + DOMUtil.getDisplayName(factory.getOMDocumentElement()) + "])");
        }
        OMElement dummy = DOMUtil.createDummyElement(null, factory, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(OMDocument factory) returns OMElement[" + dummy + "]");
        }
        return dummy;
    }

    public static String getQualifiedName(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQualifiedName(OMNode node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String ret = null;
        if (node.getType() == 1) {
            OMElement el = (OMElement)node;
            String prefix = el.getNamespace() == null ? null : el.getNamespace().getPrefix();
            String localName = el.getLocalName();
            if (prefix == null) {
                prefix = "";
            } else if (!"".equals(prefix)) {
                prefix = prefix + ":";
            }
            ret = prefix + localName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQualifiedName(OMNode node) returns String[" + ret + "]");
        }
        return ret;
    }

    public static String getDisplayName(OMNode node) {
        return DOMUtil.getDisplayName(node, true);
    }

    public static String getDisplayName(OMNode node, boolean displayClassname) {
        String ret = null;
        if (node != null) {
            String str0 = displayClassname ? node.getClass().getName() + " --- " : "";
            switch (node.getType()) {
                case 1: {
                    OMElement elem = (OMElement)node;
                    String str1 = elem.getNamespace() == null ? null : elem.getNamespace().getName();
                    String str2 = elem.getLocalName();
                    ret = str0 + "{" + str1 + "}" + str2;
                    break;
                }
                case 4: 
                case 12: {
                    OMText text = (OMText)node;
                    String str1 = text.getText();
                    ret = str0 + str1;
                    break;
                }
                default: {
                    ret = str0;
                }
            }
        }
        return ret;
    }

    public static String getDisplayName(OMDocument doc) {
        String ret = null;
        if (doc != null) {
            ret = doc.getClass().getName();
        }
        return ret;
    }

    static {
        INDENT_NS.add(Constants0.NS_WSSE);
        INDENT_NS.add(Constants0.NS_DSIG);
        INDENT_NS.add(Constants0.NS_ENC);
        INDENT_NS.add(Constants0.NS_WSSE200207);
        INDENT_NS.add(Constants0.NS_WSSE200204);
        INDENT_NS.add(Constants0.NS_WSU);
        INDENT_NS.add(Constants0.NS_WSU200207);
    }

    public static class JarXMLResolver
    implements XMLResolver {
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + publicID + "]," + "String systemId[" + systemID + "])");
            }
            InputStream is = null;
            if (systemID != null) {
                try {
                    String localResourceName = null;
                    int ind = systemID.lastIndexOf(47);
                    localResourceName = ind < 0 ? "config/" + systemID : "config/" + systemID.substring(ind + 1);
                    is = DOMUtil.class.getClassLoader().getResourceAsStream(localResourceName);
                    if (is == null) {
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
                        is = loader == null ? ClassLoader.getSystemResourceAsStream(localResourceName) : loader.getResourceAsStream(localResourceName);
                    }
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".resolveEntity", "265");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{publicID, systemID, e});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                String isStr = is == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + isStr + "]");
            }
            return is;
        }
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + publicId + "]," + "String systemId[" + systemId + "])");
            }
            InputSource is = null;
            if (systemId != null) {
                try {
                    String localResourceName = null;
                    int ind = systemId.lastIndexOf(47);
                    localResourceName = ind < 0 ? "config/" + systemId : "config/" + systemId.substring(ind + 1);
                    InputStream in = DOMUtil.class.getClassLoader().getResourceAsStream(localResourceName);
                    if (in == null) {
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
                        in = loader == null ? ClassLoader.getSystemResourceAsStream(localResourceName) : loader.getResourceAsStream(localResourceName);
                    }
                    if (in != null) {
                        is = new InputSource(in);
                    }
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".resolveEntity", "265");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{publicId, systemId, e});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                String isStr = is == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + isStr + "]");
            }
            return is;
        }
    }
}

