/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public class CredentialsHelper {
    private static final TraceComponent tc = Tr.register(CredentialsHelper.class, null, "com.ibm.ejs.resources.security");

    public static byte[] copyCredToken(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyCredToken(credToken)");
        }
        if (credToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "credential token is null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copyCredToken(credToken)");
            }
            return null;
        }
        int LEN = credToken.length;
        if (LEN == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "credential token is zero byte");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copyCredToken(credToken)");
            }
            return new byte[LEN];
        }
        byte[] newCredToken = new byte[LEN];
        System.arraycopy(credToken, 0, newCredToken, 0, LEN);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "credential token copied");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyCredToken(credToken)");
        }
        return newCredToken;
    }

    private CredentialsHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CredentialsHelper()");
        }
        Tr.error(tc, "security.jaas.NoCredentialsHelper");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CredentialsHelper()");
        }
    }
}

