/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.policy.SandeshaPolicyBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2Util {
    private static final TraceComponent tc = Tr.register(Axis2Util.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = Axis2Util.class.getName();

    public static boolean isServiceProvider(Object obj) throws SoapSecurityException {
        AxisService axisService = null;
        Object aService = null;
        if (obj instanceof MessageContext) {
            MessageContext mCtx = (MessageContext)obj;
            axisService = mCtx.getAxisService();
            if (axisService == null && (axisService = (AxisService)mCtx.getProperty("unverifiedService")) == null) {
                EndpointReference toEPR = mCtx.getTo();
                String endpointAddress = toEPR != null ? toEPR.getAddress() : "";
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{endpointAddress});
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisService", new String[]{endpointAddress});
            }
        } else if (obj instanceof AxisService) {
            axisService = (AxisService)obj;
        } else {
            Tr.error(tc, "security.wssecurity.WSEC6841E", new Object[]{"AxisService is NULL."});
            throw new SoapSecurityException("AxisService is NULL. Service for endpoint address not found.");
        }
        if (axisService != null) {
            if (axisService.isClientSide()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAxisService().isClientSide() = true");
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAxisService().isClientSide() = false");
            }
            return true;
        }
        Tr.error(tc, "security.wssecurity.WSEC6841E", new Object[]{"AxisService is NULL."});
        throw new SoapSecurityException("AxisService is NULL. Service for endpoint address not found.");
    }

    public static long getRMSequenceInactivityTimeoutInterval(MessageContext messageContext) {
        SandeshaPolicyBean propertyBean;
        AxisConfiguration config2;
        Parameter parameter;
        long timeout = 0L;
        if (messageContext.getConfigurationContext() != null && (parameter = (config2 = messageContext.getConfigurationContext().getAxisConfiguration()).getParameter("Sandesha2PropertyBean")) != null && (propertyBean = (SandeshaPolicyBean)parameter.getValue()) != null) {
            timeout = propertyBean.getInactivityTimeoutInterval();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RM sequence Inactivity timeout = " + timeout);
        }
        return timeout;
    }

    public static AxisOperation getOperationFromWSAAction(MessageContext messageContext, String[] allowableNamespaces) throws SoapSecurityException {
        SOAPEnvelope envelope = messageContext.getEnvelope();
        if (envelope != null) {
            for (String namespace : allowableNamespaces) {
                AxisOperation result;
                QName actionQName = new QName(namespace, "Action");
                Iterator actionElements = envelope.getHeader().getChildrenWithName(actionQName);
                if (!actionElements.hasNext()) continue;
                OMElement actionElement = (OMElement)actionElements.next();
                String action = actionElement.getText().trim();
                if (messageContext.getAxisService() == null || (result = messageContext.getAxisService().getOperationByAction(action)) == null) continue;
                String soapAction = messageContext.getSoapAction();
                if (soapAction != null && soapAction.length() != 0 && !soapAction.equals(action)) {
                    throw new SoapSecurityException("SOAPAction and WSAction are not equal");
                }
                return result;
            }
        }
        return null;
    }

    public static PolicySetConfiguration getPolicySetConfig(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfig(MessageContext messageContext)");
        }
        AxisOperation operation = messageContext.getAxisOperation();
        Parameter aParameter = null;
        Object obj = null;
        if (operation != null) {
            aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey());
        }
        if (aParameter != null) {
            obj = aParameter.getValue();
        }
        PolicySetConfiguration psc = null;
        if (obj != null && obj instanceof PolicySetConfiguration) {
            psc = (PolicySetConfiguration)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid PolicySet from the operation context");
            }
        } else {
            AxisService service = messageContext.getAxisService();
            if (service != null) {
                aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey());
            }
            if (aParameter != null) {
                obj = aParameter.getValue();
            }
            if (obj != null && obj instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid PolicySet from the service context");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfig(MessageContext messageContext) returns :" + psc);
        }
        return psc;
    }

    public static void setMustUnderstand(MessageContext messageContext, boolean mustUnderstand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand=" + mustUnderstand);
        }
        if (messageContext != null) {
            messageContext.setProperty(Constants.MUST_UNDERSTAND, new Boolean(mustUnderstand));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static boolean getMustUnderstand(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(messageContext)");
        }
        boolean mustUnderstand = true;
        Boolean mUnderstand = null;
        mUnderstand = (Boolean)Axis2Util.getProperty(messageContext, Constants.MUST_UNDERSTAND);
        if (mUnderstand != null) {
            mustUnderstand = mUnderstand;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No cached value found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + mustUnderstand);
        }
        return mustUnderstand;
    }

    public static boolean getMustUnderstand(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(context)");
        }
        boolean mustUnderstand = true;
        if (context != null) {
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            mustUnderstand = Axis2Util.getMustUnderstand(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + mustUnderstand);
        }
        return mustUnderstand;
    }

    public static Object getProperty(MessageContext messageContext, String property) {
        return Axis2Util.getProperty(messageContext, property, true, false);
    }

    public static Object getProperty(MessageContext messageContext, String property, boolean checkCurrentContext, boolean setRetrievedValueInPassedContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty(messageContext," + property + ")");
        }
        Object retVal = null;
        if (messageContext != null) {
            if (checkCurrentContext) {
                retVal = messageContext.getProperty(property);
            }
            if (retVal == null) {
                OperationContext opCtx = messageContext.getOperationContext();
                if (opCtx == null) {
                    opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                }
                if (opCtx != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for cached " + property + " attribute in message context collection");
                    }
                    HashMap allMsgCtxs = opCtx.getMessageContexts();
                    Set msgContexts = allMsgCtxs.entrySet();
                    for (Map.Entry entry : msgContexts) {
                        MessageContext tempMsgCtx = (MessageContext)entry.getValue();
                        retVal = tempMsgCtx.getProperty(property);
                        if (retVal == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cached value found in msg ctx with key: " + entry.getKey());
                        }
                        if (!setRetrievedValueInPassedContext) break;
                        messageContext.setProperty(property, retVal);
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            if (retVal instanceof String) {
                Tr.exit(tc, "getProperty(messageContext," + property + ") returns " + (String)retVal);
            } else {
                Tr.exit(tc, "getProperty(messageContext,property)");
            }
        }
        return retVal;
    }
}

