/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UnableToRenewException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UninitializedHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTIssue;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTRenew
extends SCTIssue
implements RequestHandler {
    private int lifetimeMSec;
    private boolean initialized = false;
    private static final String CLASS_NAME = SCTRenew.class.getName();
    private static final TraceComponent tc = Tr.register(SCTRenew.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken request, String requestType, IConstants constants) throws RequestHandlerException {
        SCT sct;
        String method = "handleRequest()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (!this.initialized) {
            String errorMsg = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s12", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (UninitializedHandlerException)SCTHelper.populateIFault(new UninitializedHandlerException(errorMsg), "wst", constants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        IElement renewTarget = request.getRenewTarget();
        if (renewTarget == null) {
            String errorMsg = "Missing RenewTarget element.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s13", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String uuid = SCTRenew.extractUUIDFromRenewTarget(renewTarget);
        String instanceFromMsg = SCTRenew.extractInstanceFromRenewTarget(renewTarget);
        if (uuid == null) {
            String errorMsg = "UUID was not successfully extracted from renew request. Renew failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s14", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        if (instanceFromMsg == null && tc.isDebugEnabled()) {
            String errorMsg = "Instance was not successfully extracted from renew request. May lead to a failure";
            Tr.debug(tc, errorMsg);
        }
        String key = null;
        key = instanceFromMsg == null || SCTHelper.getCache().getPreV70InteropMode() ? uuid : uuid + instanceFromMsg;
        if (tc.isDebugEnabled()) {
            String msg = "Renew key = " + key;
            Tr.debug(tc, msg);
        }
        if ((sct = (SCT)SCTHelper.getCache().getToken(key)) == null) {
            String errorMsg = "SCT with the UUID and instance " + uuid + ": " + instanceFromMsg + " does not exist. Renew failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(errorMsg), "wst", constants.getWSTrustNamespace(), "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        QName sctValueTypeQName = sct.getValueType();
        String sctValueType = sctValueTypeQName.getLocalPart();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "=============> ValueType from sct: " + sctValueType);
        }
        QName sctTokenQName = sct.getTokenQname();
        String wsc = sctTokenQName.getNamespaceURI();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "=============> wsc from sct: " + wsc);
        }
        URI wscURI = null;
        try {
            wscURI = new URI(wsc);
        }
        catch (URISyntaxException e) {
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s09", new String[]{e.toString()}));
        }
        if (!sct.isRenewable() || sct.isCancelled()) {
            String errorMsg = "SCT with the UUID " + uuid + " is not renewable. Renew failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(errorMsg), "wst", constants.getWSTrustNamespace(), "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        String[] instances = sct.getInstances();
        Date now = new Date();
        Date latest = new Date(0L);
        String whichInstance = null;
        for (String instance : instances) {
            Date expiration = sct.getExpiration(instance);
            if (!expiration.after(latest)) continue;
            latest = expiration;
            whichInstance = instance;
        }
        if (latest.before(now) && !sct.isRenewableAfterExpiration()) {
            String errorMsg = "SCT with UUID " + uuid + " has expired, and is not renewable after expiration. " + "Renew failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (UnableToRenewException)SCTHelper.populateIFault(new UnableToRenewException(errorMsg), "wst", constants.getWSTrustNamespace(), "UnableToRenew", "security.wssecurity.WSEC6865E");
        }
        IElement elemEntropyRST = request.getEntropy();
        byte[] clientSecret = this.extractBinarySecret(elemEntropyRST);
        String secretType = SCTHelper.extractAttributeFrom(elemEntropyRST, new String[]{"BinarySecret"}, "Type");
        ILifetime elemLifetimeRST = request.getLifetime();
        Date created = null;
        Date expires = null;
        if (elemLifetimeRST != null) {
            created = elemLifetimeRST.getCreated();
            expires = elemLifetimeRST.getExpires();
        }
        if (created == null) {
            created = new Date();
        }
        Date defaultExpiration = new Date(created.getTime() + (long)this.lifetimeMSec);
        if (expires == null) {
            expires = defaultExpiration;
        }
        if (expires.getTime() - created.getTime() > (long)this.lifetimeMSec) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested lifetime is greater than the configured maximum lifetime. Using the configured maximum lifetime.");
            }
            expires = defaultExpiration;
        }
        byte[] serverSecret = null;
        if (clientSecret == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestSecurityToken is missing Entropy/BinarySecret. Using old keys.");
            }
            serverSecret = sct.getServerSecret(whichInstance);
            clientSecret = sct.getClientSecret(whichInstance);
        } else {
            String alg = sct.getAlgorithm();
            String prov = sct.getProvider();
            int keySize = sct.getKeySize();
            if (alg == null || prov == null) {
                String errorMsg = "Either algorithm or provider in the cached SCT is null. Both must be non-null. Renew failed.";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, errorMsg);
                }
                Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s15", null));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
            }
            serverSecret = SCTHelper.generateSecret(alg, prov, keySize);
        }
        String newInstance = SCTHelper.generateUUID();
        SCT.KeyHistoryEntry newEntry = new SCT.KeyHistoryEntry(newInstance, clientSecret, serverSecret, created, expires, SCT.SCTState.RENEWED);
        sct.setKeyHistoryEntry(newEntry);
        String wsuID = SCTHelper.generateUUID();
        if (!SCTHelper.getCache().getPreV70InteropMode()) {
            SCTHelper.getCache().updateToken(uuid + newInstance, sct, expires == null ? -1L : expires.getTime() - now.getTime() + (long)this.renewalWindowMSec);
        }
        SCTHelper.getCache().updateToken(uuid, sct, expires == null ? -1L : expires.getTime() - now.getTime() + (long)this.renewalWindowMSec);
        IElement elemRequestedSecurityTokenRSTR = this.generateRequestedSecurityToken(sct, wscURI, wsuID, newInstance, constants);
        IElement elemRequestedAttachedReference = this.generateRequestedAttachedReference(wsuID, sctValueType, constants);
        IElement elemEntropy = this.generateEntropy(serverSecret, secretType, constants);
        ILifetime elemLifetimeRSTR = this.generateLifetime(created, expires);
        IElement elemRenewingRSTR = this.generateRenewing(sct.isRenewable(), sct.isRenewableAfterExpiration(), constants);
        IRequestSecurityTokenResponse rstr = SCTHelper.createRSTR(request.getContext());
        rstr.setRequestedSecurityToken(elemRequestedSecurityTokenRSTR);
        rstr.setRequestedAttachedReference(elemRequestedAttachedReference);
        rstr.setEntropy(elemEntropy);
        rstr.setLifetime(elemLifetimeRSTR);
        rstr.setRenewing(elemRenewingRSTR);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rstr;
    }

    public void initialize(Properties configuration) {
        String method = "initialize()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling super.initialize()...");
        }
        super.initialize(configuration);
        String lifetimeMinutesString = configuration.getProperty("lifetimeMinutes");
        this.lifetimeMSec = Integer.valueOf(lifetimeMinutesString) * 60000;
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    private static String extractUUIDFromRenewTarget(IElement renewTarget) {
        String uuid = SCTHelper.extractTextFrom(renewTarget, new String[]{"SecurityContextToken", "Identifier"});
        return uuid;
    }

    private static String extractInstanceFromRenewTarget(IElement renewTarget) {
        String instance = SCTHelper.extractTextFrom(renewTarget, new String[]{"SecurityContextToken", "Instance"});
        return instance;
    }
}

