/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axis2.util.Base64;
import org.apache.axis2.util.UUIDGenerator;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.UnsupportedContainedObjectClassException;
import org.eclipse.higgins.sts.impl.Element;
import org.eclipse.higgins.sts.impl.EndpointReference;
import org.eclipse.higgins.sts.impl.Lifetime;
import org.eclipse.higgins.sts.impl.RequestSecurityTokenResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCTHelper {
    private static Properties sctConfigProperties = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final String CLASS_NAME = SCTHelper.class.getName();
    private static final String UUIDGeneratorPrefix = "urn:";
    private static final TraceComponent tc = Tr.register(SCTHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static IRequestSecurityTokenResponse createRSTR(URI context) {
        IRequestSecurityTokenResponse rstr = null;
        if (context != null) {
            rstr = SCTHelper.createRSTR(context.toString());
        }
        return rstr;
    }

    public static IRequestSecurityTokenResponse createRSTR(String context) {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        if (context != null) {
            rstr.setContext(context);
        }
        return rstr;
    }

    public static String printDate(Date date) {
        return UTC.format(date);
    }

    public static Date parseDate(String dateString) {
        Date date = null;
        try {
            date = UTC.parse(dateString);
        }
        catch (ParseException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem parsing the date: " + e.getLocalizedMessage());
            }
            return null;
        }
        return date;
    }

    public static CacheableTokenCache getCache() {
        return CacheableTokenCacheFactory.getInstance();
    }

    public static Properties getSCTConfigProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTConfigProperties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTConfigProperties returns ");
        }
        return sctConfigProperties;
    }

    public static void setSCTConfigProperties(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSCTConfigProperties(props)");
        }
        sctConfigProperties = props;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSCTConfigProperties(props)");
        }
    }

    public static boolean isCached(String identifier) {
        CacheableTokenCache cache = SCTHelper.getCache();
        boolean contains = false;
        if (cache != null) {
            contains = cache.containsToken(identifier);
        }
        return contains;
    }

    public static IElement createIElement(String elementName, String nsPrefix, URI namespace) {
        OMNamespace omNamespace = null;
        if (nsPrefix != null && namespace != null) {
            omNamespace = omFactory.createOMNamespace(namespace.toString(), nsPrefix);
        }
        Element element = new Element();
        try {
            element.set(omFactory.createOMElement(elementName, omNamespace));
        }
        catch (UnsupportedContainedObjectClassException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred while trying to create IElement: " + e.getLocalizedMessage());
            }
            element = null;
        }
        return element;
    }

    public static IEndpointReference createIEndpointReference(URI endpointURI) {
        EndpointReference epRef = null;
        if (endpointURI != null) {
            epRef = new EndpointReference();
            epRef.setAddress(endpointURI);
        }
        return epRef;
    }

    public static ILifetime createILifetime(Date created, Date expires) {
        if (created == null && expires == null) {
            return null;
        }
        Lifetime lifetime = new Lifetime();
        if (created != null) {
            lifetime.setCreated(created);
        }
        if (expires != null) {
            lifetime.setExpires(expires);
        }
        return lifetime;
    }

    public static void addChildTo(IElement parent, IElement child) {
        String method = "addChildTo()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        OMElement omParent = null;
        OMElement omChild = null;
        try {
            omParent = (OMElement)parent.getAs(OMElement.class);
            omChild = (OMElement)child.getAs(OMElement.class);
            if (omParent != null && omChild != null) {
                omParent.addChild(omChild);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either the parent or the child is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A problem occurred when getting an instance of the elements: " + e.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public static void addTextTo(IElement parent, String text) {
        String method = "addTextTo()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        OMElement omParent = null;
        try {
            omParent = (OMElement)parent.getAs(OMElement.class);
            if (omParent != null && text != null) {
                omParent.addChild(SCTHelper.createOMText(text));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either the parent or the text is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A problem occurred when getting an instance of the element: " + e.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public static void addAttributeTo(IElement parent, String attributeName, String attributeNamespacePrefix, URI attributeNamespace, String attributeValue) {
        String method = "addAttributeTo()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        OMElement omParent = null;
        try {
            omParent = (OMElement)parent.getAs(OMElement.class);
            if (omParent != null) {
                omParent.addAttribute(SCTHelper.createOMAttribute(attributeName, attributeNamespacePrefix, attributeNamespace, attributeValue));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The parent is null.");
            }
        }
        catch (UnsupportedContainedObjectClassException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A problem occurred when getting an instance of the element: " + e.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public static OMElement extractElementFromSet(Set<OMElement> anyOther, String localName) {
        Iterator<OMElement> iter = anyOther.iterator();
        OMElement extracted = null;
        while (iter.hasNext()) {
            OMElement current = iter.next();
            if (!current.getLocalName().equals(localName)) continue;
            extracted = current;
            break;
        }
        return extracted;
    }

    public static String extractTextFrom(IElement root, String[] elemPath) {
        String method = "extractTextFrom()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String text = null;
        if (root != null) {
            OMElement parent = null;
            try {
                parent = (OMElement)root.getAs(OMElement.class);
            }
            catch (UnsupportedContainedObjectClassException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A problem occurred when getting an instance of the element: " + e.getLocalizedMessage());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return null;
            }
            for (String elem : elemPath) {
                OMElement current = SCTHelper.findChildElement(parent, elem);
                if (current == null) {
                    return null;
                }
                parent = current;
            }
            text = parent.getText();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return text;
    }

    public static String extractAttributeFrom(IElement root, String[] elemPath, String attribute) {
        String method = "extractAttributeFrom()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String attributeValue = null;
        if (root != null && attribute != null) {
            OMElement omParent = null;
            try {
                omParent = (OMElement)root.getAs(OMElement.class);
            }
            catch (UnsupportedContainedObjectClassException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A problem occurred when getting an instance of the element: " + e.getLocalizedMessage());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return null;
            }
            if (omParent == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The parent is null.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return null;
            }
            for (String elem : elemPath) {
                OMElement current = SCTHelper.findChildElement(omParent, elem);
                if (elem == null) {
                    return null;
                }
                omParent = current;
            }
            attributeValue = omParent.getAttributeValue(new QName(attribute));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return attributeValue;
    }

    public static byte[] copyOf(byte[] original) {
        byte[] copy = null;
        if (original != null) {
            copy = new byte[original.length];
            System.arraycopy(original, 0, copy, 0, original.length);
        }
        return copy;
    }

    public static byte[] decode(String encoded) {
        return Base64.decode(encoded);
    }

    public static String encode(byte[] decoded) {
        return Base64.encode(decoded);
    }

    public static String generateUUID() {
        String newUUID = UUIDGenerator.getUUID();
        if (newUUID.startsWith(UUIDGeneratorPrefix)) {
            newUUID = newUUID.substring(UUIDGeneratorPrefix.length());
        }
        return newUUID;
    }

    public static byte[] generateSecret(String algorithm, String provider, int keySize) {
        String method = CLASS_NAME + ".generateServerSecret(" + "algorithm=" + algorithm + "," + "provider=" + provider + "," + "keySize=" + keySize + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        byte[] secret = null;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algorithm, provider);
            keyGen.init(keySize);
            SecretKey secretKey = keyGen.generateKey();
            secret = secretKey.getEncoded();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred while generating secret: " + e.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return secret;
    }

    public static String getMessage(String key, String[] args) {
        return SoapSecurityException.format(key, args).getMessage();
    }

    public static IFault populateIFault(IFault fault, String codePrefix, URI codeNamespace, String codeLocalPart, String reason) {
        if (fault != null) {
            fault.setCodePrefix(codePrefix);
            fault.setCodeNamespace(codeNamespace);
            fault.setCodeLocalPart(codeLocalPart);
            fault.setReason(reason);
        }
        return fault;
    }

    private static OMElement findChildElement(OMElement parent, String childName) {
        OMElement child = null;
        if (parent != null) {
            Iterator childrenIter = parent.getChildElements();
            while (childrenIter.hasNext()) {
                OMElement currentChild = (OMElement)childrenIter.next();
                if (!currentChild.getLocalName().equals(childName)) continue;
                child = currentChild;
                break;
            }
        }
        return child;
    }

    private static OMText createOMText(String text) {
        return omFactory.createOMText(text);
    }

    private static OMAttribute createOMAttribute(String name, String nsPrefix, URI namespace, String value) {
        OMNamespace omNamespace = null;
        if (nsPrefix != null && namespace != null) {
            omNamespace = omFactory.createOMNamespace(namespace.toString(), nsPrefix);
        }
        OMAttribute attribute = omFactory.createOMAttribute(name, omNamespace, value);
        return attribute;
    }
}

