/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTCancel;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTGetToken;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTIssue;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTPutToken;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTRenew;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTValidate;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.ISTSRequest;
import org.eclipse.higgins.sts.ISTSResponse;
import org.eclipse.higgins.sts.server.ISecurityTokenServiceExtension;

public class SCTHandler
implements ISecurityTokenServiceExtension {
    private HashMap<String, RequestHandler> handlerMap = new HashMap();
    private static final TraceComponent tc = Tr.register(SCTHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void invoke(ISTSRequest request, ISTSResponse response, IConstants constants) {
        String method = "invoke()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        Iterator rsts = SCTHandler.extractRSTs(request);
        while (rsts.hasNext()) {
            IRequestSecurityToken rst = (IRequestSecurityToken)rsts.next();
            URI requestTypeURI = rst.getRequestType();
            if (requestTypeURI == null) {
                String errorMsg = "RequestType is missing from RequestSecurityToken.";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, errorMsg);
                }
                response.setFault(SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            String requestType = requestTypeURI.toString();
            RequestHandler handler = this.handlerMap.get(requestType);
            IRequestSecurityTokenResponse rstr = null;
            if (handler != null) {
                try {
                    rstr = handler.handleRequest(rst, requestType, constants);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught by SCTHandler while attempting to process request: " + e.getLocalizedMessage());
                    }
                    if (IFault.class.isAssignableFrom(e.getClass())) {
                        response.setFault((IFault)((Object)e));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                if (rstr == null) continue;
                SCTHandler.addToSTSResponse(response, rstr);
                continue;
            }
            String errorMsg = SCTHelper.getMessage("security.wssecurity.sct.s01", new String[]{requestType});
            Tr.error(tc, errorMsg);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This handler does not recognize the specified request type: " + requestType);
            }
            response.setFault(SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public void configure(Map configuration) {
        String method = "configure()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        Properties config2 = new Properties();
        for (Object key : configuration.keySet()) {
            config2.setProperty((String)key, (String)configuration.get(key));
        }
        SCTHelper.setSCTConfigProperties(config2);
        this.handlerMap.clear();
        String issueRequest = config2.getProperty("RequestType_issue");
        String cancelRequest = config2.getProperty("RequestType_cancel");
        String renewRequest = config2.getProperty("RequestType_renew");
        String validateRequest = config2.getProperty("RequestType_validate");
        String noConfigPropPrefix = "There is no configuration property for ";
        String noConfigPropSuffix = " request type rst.";
        if (issueRequest != null) {
            SCTIssue issueHandler = new SCTIssue();
            this.handlerMap.put(issueRequest, issueHandler);
            issueHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "issue" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s02", null));
        }
        if (cancelRequest != null) {
            SCTCancel cancelHandler = new SCTCancel();
            this.handlerMap.put(cancelRequest, cancelHandler);
            cancelHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "cancel" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s03", null));
        }
        if (renewRequest != null) {
            SCTRenew renewHandler = new SCTRenew();
            this.handlerMap.put(renewRequest, renewHandler);
            renewHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "renew" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s04", null));
        }
        if (validateRequest != null) {
            SCTValidate validateHandler = new SCTValidate();
            this.handlerMap.put(validateRequest, validateHandler);
            validateHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "validate" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s05", null));
        }
        String issueRequest_alt = config2.getProperty("RequestType_issue_alt");
        String cancelRequest_alt = config2.getProperty("RequestType_cancel_alt");
        String renewRequest_alt = config2.getProperty("RequestType_renew_alt");
        String validateRequest_alt = config2.getProperty("RequestType_validate_alt");
        if (issueRequest_alt != null) {
            SCTIssue issueHandler = new SCTIssue();
            this.handlerMap.put(issueRequest_alt, issueHandler);
            issueHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "issue" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s02", null));
        }
        if (cancelRequest_alt != null) {
            SCTCancel cancelHandler = new SCTCancel();
            this.handlerMap.put(cancelRequest_alt, cancelHandler);
            cancelHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "cancel" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s03", null));
        }
        if (renewRequest_alt != null) {
            SCTRenew renewHandler = new SCTRenew();
            this.handlerMap.put(renewRequest_alt, renewHandler);
            renewHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "renew" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s04", null));
        }
        if (validateRequest_alt != null) {
            SCTValidate validateHandler = new SCTValidate();
            this.handlerMap.put(validateRequest_alt, validateHandler);
            validateHandler.initialize(config2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, noConfigPropPrefix + "validate" + noConfigPropSuffix);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s05", null));
        }
        SCTGetToken getTokenHandler = new SCTGetToken();
        SCTPutToken putTokenHandler = new SCTPutToken();
        this.handlerMap.put("http://w3.ibm.com/ws/2005/02/trust/getToken", getTokenHandler);
        this.handlerMap.put("http://w3.ibm.com/ws/2005/02/trust/putToken", putTokenHandler);
        getTokenHandler.initialize(config2);
        putTokenHandler.initialize(config2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public boolean canHandle(ISTSRequest request, IConstants constants) {
        String method = "canHandle";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        Iterator rsts = SCTHandler.extractRSTs(request);
        while (rsts.hasNext()) {
            IRequestSecurityToken rst = (IRequestSecurityToken)rsts.next();
            URI requestTypeURI = rst.getRequestType();
            if (requestTypeURI != null) {
                String requestType = requestTypeURI.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "requestType: " + requestType);
                }
                RequestHandler handler = this.handlerMap.get(requestType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handler: " + handler);
                }
                if (handler != null) continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning false");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning true");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return true;
    }

    private static Iterator extractRSTs(ISTSRequest request) {
        List rsts = request.getRequestSecurityTokenCollection();
        return rsts.iterator();
    }

    private static ISTSResponse addToSTSResponse(ISTSResponse response, IRequestSecurityTokenResponse rstr) {
        List rstrs = response.getRequestSecurityTokenResponseCollection();
        rstrs.add(rstr);
        return response;
    }
}

