/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTCancel
implements RequestHandler {
    private static final TraceComponent tc = Tr.register(SCTCancel.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken request, String requestType, IConstants constants) throws InvalidRequestException {
        IElement elemCancelTarget;
        String method = "handleRequest()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if ((elemCancelTarget = request.getCancelTarget()) == null) {
            String errorMsg = "Missing CancelTarget element.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s10", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String uuid = SCTCancel.extractUUIDFromCancelTarget(elemCancelTarget);
        if (uuid == null) {
            String errorMsg = "UUID was not successfully extracted from cancel request. Cancel failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s11", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IElement requestedTokenCancelled = SCTCancel.generateRequestedTokenCancelled(constants);
        IRequestSecurityTokenResponse rstr = SCTHelper.createRSTR(request.getContext());
        rstr.setRequestedTokenCancelled(requestedTokenCancelled);
        SCTCancel.cancelSCT(uuid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rstr;
    }

    public void initialize(Properties configuration) {
    }

    private static IElement generateRequestedTokenCancelled(IConstants constants) {
        return SCTHelper.createIElement("RequestedTokenCancelled", "wst", constants.getWSTrustNamespace());
    }

    private static String extractUUIDFromCancelTarget(IElement cancelTarget) {
        String uuid = SCTHelper.extractTextFrom(cancelTarget, new String[]{"SecurityContextToken", "Identifier"});
        return uuid;
    }

    private static void cancelSCT(String uuid) {
        SCT sct = (SCT)SCTHelper.getCache().removeToken(uuid);
        if (sct != null) {
            sct.setCancelState();
        }
    }
}

