/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.net.URI;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.impl.Constants;
import org.eclipse.higgins.sts.impl.RequestSecurityToken;
import org.eclipse.higgins.sts.impl.STSRequest;
import org.eclipse.higgins.sts.impl.STSResponse;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;

public abstract class STSTokenUtil {
    private static final TraceComponent tc = Tr.register(STSTokenUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static final Boolean putToken(CacheableToken token, String TokenTypeURI) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putToken(CacheableToken token, String TokenTypeURI=" + TokenTypeURI + ")");
        }
        Boolean rc = false;
        try {
            STSRequest request = new STSRequest();
            RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
            requestSecurityToken.setRequestType(new URI("http://w3.ibm.com/ws/2005/02/trust/putToken"));
            requestSecurityToken.setTokenType(new URI(TokenTypeURI));
            requestSecurityToken.setData(token);
            List listRST = request.getRequestSecurityTokenCollection();
            listRST.add(requestSecurityToken);
            SecurityTokenService SecurityTokenService2 = STSConfigUtil.getSecurityTokenServiceSingletonInstance(false);
            STSResponse response = new STSResponse();
            SecurityTokenService2.invoke(request, response, new Constants());
            if (response != null) {
                List collection = response.getRequestSecurityTokenResponseCollection();
                if (collection.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "empty vector returned from SecurityTokenService");
                    }
                } else {
                    IRequestSecurityTokenResponse requestSecurityTokenResponse = (IRequestSecurityTokenResponse)collection.get(0);
                    rc = (Boolean)requestSecurityTokenResponse.getData();
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in putToken");
            }
            throw new AxisFault(e.toString(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putToken(CacheableToken token, String TokenTypeURI=" + TokenTypeURI + ")");
        }
        return rc;
    }

    public static final CacheableToken getToken(String UUID2, String TokenTypeURI) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken(String UUID=" + UUID2 + ", String TokenTypeURI=" + TokenTypeURI + ")");
        }
        CacheableToken token = null;
        try {
            STSRequest request = new STSRequest();
            RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
            requestSecurityToken.setRequestType(new URI("http://w3.ibm.com/ws/2005/02/trust/getToken"));
            requestSecurityToken.setTokenType(new URI(TokenTypeURI));
            requestSecurityToken.setData(UUID2);
            List listRST = request.getRequestSecurityTokenCollection();
            listRST.add(requestSecurityToken);
            SecurityTokenService SecurityTokenService2 = STSConfigUtil.getSecurityTokenServiceSingletonInstance(false);
            STSResponse response = new STSResponse();
            SecurityTokenService2.invoke(request, response, new Constants());
            if (response != null) {
                List collection = response.getRequestSecurityTokenResponseCollection();
                if (collection.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "empty vector returned from SecurityTokenService");
                    }
                } else {
                    IRequestSecurityTokenResponse requestSecurityTokenResponse = (IRequestSecurityTokenResponse)collection.get(0);
                    token = (CacheableToken)requestSecurityTokenResponse.getData();
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in getToken");
            }
            e.printStackTrace();
            throw new AxisFault(null, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken(String UUID=" + UUID2 + ", String TokenTypeURI=" + TokenTypeURI + ")");
        }
        return token;
    }
}

