/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.MessageReceiver;

import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.client.impl.OMElementUtil;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.impl.TrustOMFactory;
import com.ibm.ws.wssecurity.trust.server.sts.Util.Constants;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConstantsV13;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSSecurityUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.eclipse.higgins.sts.IAddressingInformation;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IFault;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.ISTSRequest;
import org.eclipse.higgins.sts.UnsupportedContainedObjectClassException;
import org.eclipse.higgins.sts.impl.AddressingInformation;
import org.eclipse.higgins.sts.impl.AppliesTo;
import org.eclipse.higgins.sts.impl.EndpointReference;
import org.eclipse.higgins.sts.impl.Lifetime;
import org.eclipse.higgins.sts.impl.RequestSecurityToken;
import org.eclipse.higgins.sts.impl.STSRequest;
import org.eclipse.higgins.sts.impl.STSResponse;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;
import org.eclipse.higgins.sts.utilities.XMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private static final TraceComponent tc = Tr.register(STSMessageReceiver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    private static final Boolean REQUIRED = new Boolean("true");
    private static final Boolean NOT_REQUIRED = new Boolean("false");

    @Override
    protected AbstractMessageReceiver.ThreadContextDescriptor setThreadContext(MessageContext msgContext) {
        return null;
    }

    @Override
    protected void restoreThreadContext(AbstractMessageReceiver.ThreadContextDescriptor tc) {
    }

    @Override
    public final void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage)");
        }
        try {
            SOAPFactory soapFactory = null;
            soapFactory = inMessage.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            SOAPEnvelope inEnvelope = this.getEnvelope(inMessage);
            String EOL = System.getProperty("line.separator");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, EOL + OMElementUtil.formatXML(inEnvelope));
            }
            SOAPEnvelope outEnvelope = null;
            SOAPHeader soapHeaders = this.getHeaders(inEnvelope);
            String strWSAddressingNamespace = this.getWSAddressingNamespace(soapHeaders);
            OMElement omTo = this.getHeader(soapHeaders, "To", REQUIRED);
            OMElement omFrom = this.getHeader(soapHeaders, "From", NOT_REQUIRED);
            OMElement omActionIn = this.getHeader(soapHeaders, "Action", REQUIRED);
            SOAPBody soapBody = this.getBody(inEnvelope);
            String strWSTrustNamespace = this.getWSTrustNamespace(soapBody);
            IConstants stsConstants = this.getSTSConstants(strWSAddressingNamespace, strWSTrustNamespace);
            boolean isRequestSecurityTokenCollection = this.getIsRequestSecurityTokenCollection(soapBody);
            IAddressingInformation addressingInformation = this.createAddressingInformation(strWSAddressingNamespace, omTo, omFrom, omActionIn);
            ISTSRequest stsRequest = this.createSTSRequest(addressingInformation, soapHeaders, soapBody, omTo, strWSTrustNamespace, stsConstants, isRequestSecurityTokenCollection);
            STSSecurityUtil stsSecurityUtil = new STSSecurityUtil();
            stsSecurityUtil.invoke(stsRequest, inMessage);
            SecurityTokenService securityTokenService = STSConfigUtil.getSecurityTokenServiceSingletonInstance(false);
            STSResponse stsResponse = new STSResponse();
            securityTokenService.invoke(stsRequest, stsResponse, stsConstants);
            if (stsResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS response is null");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            IFault fault = stsResponse.getFault();
            if (fault != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS returned fault: " + fault);
                }
                Tr.processException(new Throwable(fault.toString()), this.getClass().getName(), FFDC_ID_1);
                URI urifaultCodeNamespace = fault.getCodeNamespace();
                String strFaultCodeNamespace = urifaultCodeNamespace == null ? null : urifaultCodeNamespace.toString();
                String strFaultCodePrefix = fault.getCodePrefix();
                String strFaultCodeLocalPart = fault.getCodeLocalPart();
                SoapSecurityException sse = null;
                if (strFaultCodeLocalPart == null) {
                    sse = SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
                } else {
                    QName faultCodeQName = new QName(strFaultCodeNamespace, strFaultCodeLocalPart, strFaultCodePrefix == null ? "" : strFaultCodePrefix);
                    sse = SoapSecurityException.format(faultCodeQName, fault.getReason());
                }
                throw sse;
            }
            List requestSecurityTokenResponseCollection = stsResponse.getRequestSecurityTokenResponseCollection();
            if (requestSecurityTokenResponseCollection.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "empty vector returned from SecurityTokenService");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            String strActionIn = "";
            if (omActionIn != null) {
                strActionIn = omActionIn.getText();
            }
            if (strActionIn == null) {
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            if (strWSTrustNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust") && requestSecurityTokenResponseCollection.size() != 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "More than 1 returned from SecurityTokenService");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRequestSecurityTokenCollection: " + isRequestSecurityTokenCollection);
                Tr.debug(tc, "requestSecurityTokenResponseCollection.size(): " + requestSecurityTokenResponseCollection.size());
                Tr.debug(tc, "strActionIn: " + strActionIn);
            }
            if (isRequestSecurityTokenCollection || requestSecurityTokenResponseCollection.size() > 1 || strActionIn.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue") || strActionIn.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/SCT")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create Collection in response");
                }
                outEnvelope = this.createOutCollectionEnvelope(soapFactory, strWSAddressingNamespace, strWSTrustNamespace, requestSecurityTokenResponseCollection, stsConstants);
            } else {
                IRequestSecurityTokenResponse requestSecurityTokenResponse;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NOT creating Collection in response");
                }
                if ((requestSecurityTokenResponse = (IRequestSecurityTokenResponse)requestSecurityTokenResponseCollection.get(0)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "STS returned a requestSecurityTokenResponse == null");
                    }
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STS returned a requestSecurityTokenResponse: " + requestSecurityTokenResponse);
                }
                outEnvelope = this.createOutEnvelope(soapFactory, strWSAddressingNamespace, strWSTrustNamespace, requestSecurityTokenResponse, stsConstants);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, EOL + OMElementUtil.formatXML(outEnvelope));
                }
            }
            outMessage.setProperty("Sandesha2UnreliableMessage", "true");
            outMessage.setEnvelope(outEnvelope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, EOL + OMElementUtil.formatXML(outEnvelope));
            }
        }
        catch (Exception e) {
            String Message2 = null;
            QName faultCode = null;
            if (e instanceof SoapSecurityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in invokeBusinessLogic: " + e);
                }
                Message2 = e.getMessage();
                faultCode = ((SoapSecurityException)e).getFaultCode();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in invokeBusinessLogic: " + e);
                }
                Tr.processException(e, this.getClass().getName() + ".invokeBusinessLogic", FFDC_ID_2);
                Message2 = SoapSecurityException.getMessage("security.wssecurity.WSEC6852E");
                faultCode = Constants.TRUST_FAULT_REQUEST_FAILED;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "faultCode: " + faultCode);
            }
            if (faultCode == null) {
                faultCode = Constants.TRUST_FAULT_REQUEST_FAILED;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message: " + Message2);
            }
            if (Message2 == null) {
                Message2 = SoapSecurityException.getMessage("security.wssecurity.WSEC6852E");
            }
            AxisFault axisFault = new AxisFault(Message2, faultCode);
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement omDetail = factory.createOMElement("Exception", null);
            omDetail.setText(Message2);
            axisFault.setDetail(omDetail);
            throw axisFault;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage)");
        }
    }

    public String getWSAddressingNamespace(SOAPHeader soapHeaders) throws SoapSecurityException {
        String strWSAddressingNamespace;
        block6: {
            ArrayList omFinalHeaders;
            block5: {
                strWSAddressingNamespace = null;
                ArrayList omSubmissionHeaders = soapHeaders.getHeaderBlocksWithNSURI("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                omFinalHeaders = soapHeaders.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
                if (omSubmissionHeaders != null && omSubmissionHeaders.size() != 0 && omFinalHeaders != null && omFinalHeaders.size() != 0) {
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                }
                if (!(omSubmissionHeaders != null && omSubmissionHeaders.size() != 0 || omFinalHeaders != null && omFinalHeaders.size() != 0)) {
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                }
                if (omSubmissionHeaders == null || omSubmissionHeaders.size() == 0) break block5;
                strWSAddressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                if (!tc.isDebugEnabled()) break block6;
                for (OMElement omElement : omSubmissionHeaders) {
                    Tr.debug(tc, omElement.getLocalName() + ": " + omElement.getText());
                }
                break block6;
            }
            strWSAddressingNamespace = "http://www.w3.org/2005/08/addressing";
            if (tc.isDebugEnabled()) {
                for (OMElement omElement : omFinalHeaders) {
                    Tr.debug(tc, omElement.getLocalName() + ": " + omElement.getText());
                }
            }
        }
        return strWSAddressingNamespace;
    }

    public String getWSTrustNamespace(SOAPBody soapBody) {
        String strWSTrustNamespace = null;
        try {
            ArrayList<OMElement> omSubmissionElements = OMElementUtil.getChildrenWithNamespaceURI(soapBody, "http://schemas.xmlsoap.org/ws/2005/02/trust");
            ArrayList<OMElement> omFinalElements = OMElementUtil.getChildrenWithNamespaceURI(soapBody, "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            if (omSubmissionElements != null && omSubmissionElements.size() != 0 && omFinalElements != null && omFinalElements.size() != 0) {
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            if (!(omSubmissionElements != null && omSubmissionElements.size() != 0 || omFinalElements != null && omFinalElements.size() != 0)) {
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            strWSTrustNamespace = omSubmissionElements != null && omSubmissionElements.size() != 0 ? "http://schemas.xmlsoap.org/ws/2005/02/trust" : "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        catch (TrustException e) {
            strWSTrustNamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        catch (SoapSecurityException e) {
            strWSTrustNamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        return strWSTrustNamespace;
    }

    public OMElement getHeader(SOAPHeader soapHeaders, String headerLocalName, Boolean isHeaderRequired) throws SoapSecurityException {
        OMElement omHeader;
        block3: {
            omHeader = null;
            try {
                omHeader = OMElementUtil.getOnlyChildWithLocalName(soapHeaders, headerLocalName);
            }
            catch (TrustException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, headerLocalName + " not found in header list. required = " + isHeaderRequired);
                }
                if (isHeaderRequired != REQUIRED) break block3;
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
        }
        return omHeader;
    }

    private SOAPEnvelope createOutCollectionEnvelope(SOAPFactory soapFactory, String strWSAddressingNamespace, String strWSTrustNamespace, List<IRequestSecurityTokenResponse> requestSecurityTokenResponseCollection, IConstants stsConstants) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutCollectionEnvelope (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        OMElement omRequestSecurityTokenResponseCollection = TrustOMFactory.createOMElementNoText("RequestSecurityTokenResponseCollection", strWSTrustNamespace, "wst");
        for (IRequestSecurityTokenResponse requestSecurityTokenResponse : requestSecurityTokenResponseCollection) {
            OMElement omRequestSecurityTokenResponse = this.createRequestSecurityTokenResponse(soapFactory, strWSAddressingNamespace, strWSTrustNamespace, requestSecurityTokenResponse, stsConstants);
            if (omRequestSecurityTokenResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get response element");
                }
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            omRequestSecurityTokenResponseCollection.addChild(omRequestSecurityTokenResponse);
        }
        if (omRequestSecurityTokenResponseCollection == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get response collection");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        SOAPEnvelope outEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody outBody = outEnvelope.getBody();
        outBody.addChild(omRequestSecurityTokenResponseCollection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOutCollectionEnvelope (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        return outEnvelope;
    }

    private SOAPEnvelope createOutEnvelope(SOAPFactory soapFactory, String strWSAddressingNamespace, String strWSTrustNamespace, IRequestSecurityTokenResponse requestSecurityTokenResponse, IConstants stsConstants) throws SoapSecurityException {
        OMElement omRequestSecurityTokenResponse;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutEnvelope (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        if ((omRequestSecurityTokenResponse = this.createRequestSecurityTokenResponse(soapFactory, strWSAddressingNamespace, strWSTrustNamespace, requestSecurityTokenResponse, stsConstants)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get response element");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        SOAPEnvelope outEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody outBody = outEnvelope.getBody();
        outBody.addChild(omRequestSecurityTokenResponse);
        Tr.exit(tc, "createOutEnvelope (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        return outEnvelope;
    }

    private OMElement createRequestSecurityTokenResponse(SOAPFactory soapFactory, String strWSAddressingNamespace, String strWSTrustNamespace, IRequestSecurityTokenResponse requestSecurityTokenResponse, IConstants stsConstants) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestSecurityTokenResponse (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        OMElement omRequestSecurityTokenResponse = null;
        OMElement omElement = null;
        IElement element = null;
        try {
            IEndpointReference appliesTo;
            element = requestSecurityTokenResponse.getRequestedSecurityToken();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                omRequestSecurityTokenResponse = soapFactory.createOMElement("RequestSecurityTokenResponse", omElement.getNamespace());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedSecurityToken: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else {
                omRequestSecurityTokenResponse = soapFactory.createOMElement("RequestSecurityTokenResponse", strWSTrustNamespace, "wst");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedSecurityToken not found");
                }
            }
            String strContext = requestSecurityTokenResponse.getContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContextURI: " + strContext);
            }
            if (null != strContext) {
                omRequestSecurityTokenResponse.addAttribute("Context", strContext, null);
            }
            if (null != (appliesTo = requestSecurityTokenResponse.getAppliesTo())) {
                omElement = soapFactory.createOMElement("AppliesTo", stsConstants.getWSSecurityPolicyNamespace().toString(), "wsp");
                OMElement omEndpointReference = soapFactory.createOMElement("EndpointReference", strWSAddressingNamespace, "wsa");
                OMElement omAddress = soapFactory.createOMElement("Address", strWSAddressingNamespace, "wsa");
                OMText textAddress = soapFactory.createOMText(appliesTo.getAddress().toString());
                omAddress.addChild(textAddress);
                omEndpointReference.addChild(omAddress);
                omElement.addChild(omEndpointReference);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppliesTo: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppliesTo not found");
            }
            element = requestSecurityTokenResponse.getRequestedProofToken();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedProofToken: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedProofToken not found");
            }
            element = requestSecurityTokenResponse.getEntropy();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Entropy: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entropy not found");
            }
            ILifetime lifetime = requestSecurityTokenResponse.getLifetime();
            if (null != lifetime) {
                omElement = soapFactory.createOMElement("Lifetime", strWSTrustNamespace, "wst");
                OMElement omCreated = soapFactory.createOMElement("Created", stsConstants.getWSSecurityUtilityNamespace().toString(), "wsu");
                OMElement omExpires = soapFactory.createOMElement("Expires", stsConstants.getWSSecurityUtilityNamespace().toString(), "wsu");
                OMText testCreated = soapFactory.createOMText(UTC.format(lifetime.getCreated()));
                OMText testExpires = soapFactory.createOMText(UTC.format(lifetime.getExpires()));
                omCreated.addChild(testCreated);
                omExpires.addChild(testExpires);
                omElement.addChild(omCreated);
                omElement.addChild(omExpires);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lifetime: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lifetime not found");
            }
            URI uriTokenType = requestSecurityTokenResponse.getTokenType();
            if (null != uriTokenType) {
                omElement = soapFactory.createOMElement("TokenType", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textTokenType = soapFactory.createOMText(uriTokenType.toString());
                omElement.addChild(textTokenType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenType: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenType not found");
            }
            URI uriRequestType = requestSecurityTokenResponse.getRequestType();
            if (null != uriRequestType) {
                omElement = soapFactory.createOMElement("RequestType", strWSTrustNamespace, "wst");
                OMText textRequestType = soapFactory.createOMText(uriRequestType.toString());
                omElement.addChild(textRequestType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestType: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestType not found");
            }
            element = requestSecurityTokenResponse.getRequestedAttachedReference();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedAttachedReference: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedAttachedReference not found");
            }
            element = requestSecurityTokenResponse.getRequestedUnattachedReference();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedUnattachedReference: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedUnattachedReference not found");
            }
            element = requestSecurityTokenResponse.getStatus();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Status not found");
            }
            element = requestSecurityTokenResponse.getAllowPostdating();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AllowPostdating: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AllowPostdating not found");
            }
            element = requestSecurityTokenResponse.getRenewing();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Renewing: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Renewing not found");
            }
            URI uriComputedKey = requestSecurityTokenResponse.getComputedKey();
            if (null != uriComputedKey) {
                omElement = soapFactory.createOMElement("ComputedKey", strWSTrustNamespace, "wst");
                OMText textComputedKey = soapFactory.createOMText(uriComputedKey.toString());
                omElement.addChild(textComputedKey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ComputedKey: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ComputedKey not found");
            }
            element = requestSecurityTokenResponse.getOnBehalfOf();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OnBehalfOf: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OnBehalfOf not found");
            }
            IEndpointReference issuer = requestSecurityTokenResponse.getIssuer();
            if (null != issuer) {
                omElement = soapFactory.createOMElement("Issuer", strWSTrustNamespace, "wst");
                OMElement omEndpointReference = soapFactory.createOMElement("EndpointReference", strWSAddressingNamespace, "wsa");
                OMElement omAddress = soapFactory.createOMElement("Address", strWSAddressingNamespace, "wsa");
                OMText textAddress = soapFactory.createOMText(issuer.getAddress().toString());
                omAddress.addChild(textAddress);
                omEndpointReference.addChild(omAddress);
                omElement.addChild(omEndpointReference);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuer: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issuer not found");
            }
            URI uriAuthenticationType = requestSecurityTokenResponse.getAuthenticationType();
            if (null != uriAuthenticationType) {
                omElement = soapFactory.createOMElement("AuthenticationType", strWSTrustNamespace, "wst");
                OMText textAuthenticationType = soapFactory.createOMText(uriAuthenticationType.toString());
                omElement.addChild(textAuthenticationType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AuthenticationType: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthenticationType not found");
            }
            element = requestSecurityTokenResponse.getAuthenticator();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authenticator: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticator not found");
            }
            URI uriKeyType = requestSecurityTokenResponse.getKeyType();
            if (null != uriKeyType) {
                omElement = soapFactory.createOMElement("KeyType", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textKeyType = soapFactory.createOMText(uriKeyType.toString());
                omElement.addChild(textKeyType);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyType: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyType not found");
            }
            Integer keySize = requestSecurityTokenResponse.getKeySize();
            if (null != keySize) {
                omElement = soapFactory.createOMElement("KeySize", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textKeySize = soapFactory.createOMText(keySize.toString());
                omElement.addChild(textKeySize);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeySize: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeySize not found");
            }
            URI uriSignatureAlgorithm = requestSecurityTokenResponse.getSignatureAlgorithm();
            if (null != uriSignatureAlgorithm) {
                omElement = soapFactory.createOMElement("SignatureAlgorithm", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textSignatureAlgorithm = soapFactory.createOMText(uriSignatureAlgorithm.toString());
                omElement.addChild(textSignatureAlgorithm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SignatureAlgorithm: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SignatureAlgorithm not found");
            }
            element = requestSecurityTokenResponse.getEncryption();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encryption: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption not found");
            }
            URI uriEncryptionAlgorithm = requestSecurityTokenResponse.getEncryptionAlgorithm();
            if (null != uriEncryptionAlgorithm) {
                omElement = soapFactory.createOMElement("EncryptionAlgorithm", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textEncryptionAlgorithm = soapFactory.createOMText(uriEncryptionAlgorithm.toString());
                omElement.addChild(textEncryptionAlgorithm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EncryptionAlgorithm: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EncryptionAlgorithm not found");
            }
            URI uriCanonicalizationAlgorithm = requestSecurityTokenResponse.getCanonicalizationAlgorithm();
            if (null != uriCanonicalizationAlgorithm) {
                omElement = soapFactory.createOMElement("CanonicalizationAlgorithm", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textCanonicalizationAlgorithm = soapFactory.createOMText(uriCanonicalizationAlgorithm.toString());
                omElement.addChild(textCanonicalizationAlgorithm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CanonicalizationAlgorithm: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CanonicalizationAlgorithm not found");
            }
            element = requestSecurityTokenResponse.getProofEncryption();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ProofEncryption: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ProofEncryption not found");
            }
            element = requestSecurityTokenResponse.getUseKey();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UseKey: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UseKey not found");
            }
            URI uriSignWith = requestSecurityTokenResponse.getSignWith();
            if (null != uriSignWith) {
                omElement = soapFactory.createOMElement("SignWith", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textSignWith = soapFactory.createOMText(uriSignWith.toString());
                omElement.addChild(textSignWith);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SignWith: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SignWith not found");
            }
            URI uriEncryptWith = requestSecurityTokenResponse.getEncryptWith();
            if (null != uriEncryptWith) {
                omElement = soapFactory.createOMElement("EncryptWith", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textEncryptWith = soapFactory.createOMText(uriEncryptWith.toString());
                omElement.addChild(textEncryptWith);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EncryptWith: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EncryptWith not found");
            }
            element = requestSecurityTokenResponse.getDelegateTo();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DelegateTo: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DelegateTo not found");
            }
            Boolean forwardable = requestSecurityTokenResponse.getForwardable();
            if (null != forwardable) {
                omElement = soapFactory.createOMElement("Forwardable", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textForwardable = soapFactory.createOMText(forwardable.toString());
                omElement.addChild(textForwardable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forwardable: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Forwardable not found");
            }
            Boolean delegatable = requestSecurityTokenResponse.getDelegatable();
            if (null != delegatable) {
                omElement = soapFactory.createOMElement("Delegatable", stsConstants.getWSTrustNamespace().toString(), "wst");
                OMText textDelegatable = soapFactory.createOMText(delegatable.toString());
                omElement.addChild(textDelegatable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delegatable: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Delegatable not found");
            }
            element = requestSecurityTokenResponse.getPolicy();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy not found");
            }
            element = requestSecurityTokenResponse.getPolicyReference();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicyReference: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicyReference not found");
            }
            element = requestSecurityTokenResponse.getRequestedTokenCancelled();
            if (null != element) {
                omElement = (OMElement)element.getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestedTokenCancelled: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestedTokenCancelled not found");
            }
            List anyOtherElements = requestSecurityTokenResponse.getAnyOtherElements();
            Iterator iterator = anyOtherElements.iterator();
            while (iterator.hasNext()) {
                omElement = (OMElement)((IElement)iterator.next()).getAs(OMElement.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AnyOther: " + XMLHelper.toString(omElement));
                }
                omRequestSecurityTokenResponse.addChild(omElement);
            }
        }
        catch (UnsupportedContainedObjectClassException e) {
            Tr.processException(e, this.getClass().getName(), FFDC_ID_5);
            throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
        }
        catch (Exception e) {
            Tr.processException(e, this.getClass().getName(), FFDC_ID_5);
            throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestSecurityTokenResponse (SOAPEnvelope envelope, SOAPFactory fac, org.eclipse.higgins.sts.RequestSecurityTokenResponse RSTR)");
        }
        return omRequestSecurityTokenResponse;
    }

    public SOAPEnvelope getEnvelope(MessageContext messageContext) throws SoapSecurityException {
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        if (soapEnvelope == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Envelope from the request messageContext");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        return soapEnvelope;
    }

    public IConstants getSTSConstants(String strWSAddressingNamespace, String strWSTrustNamespace) throws SoapSecurityException {
        IConstants stsConstants = null;
        if (strWSTrustNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            stsConstants = new org.eclipse.higgins.sts.impl.Constants();
        } else if (strWSTrustNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            stsConstants = new STSConstantsV13();
        }
        if (strWSTrustNamespace != stsConstants.getWSTrustNamespace().toString()) {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
        }
        if (strWSAddressingNamespace != stsConstants.getWSAddressingNamespace().toString()) {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_REQUEST_FAILED, "security.wssecurity.WSEC6852E");
        }
        return stsConstants;
    }

    public SOAPBody getBody(SOAPEnvelope soapEnvelope) throws SoapSecurityException {
        SOAPBody soapBody = soapEnvelope.getBody();
        if (soapBody == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Header from the request envelope");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        return soapBody;
    }

    public SOAPHeader getHeaders(SOAPEnvelope soapEnvelope) throws SoapSecurityException {
        SOAPHeader soapHeaders = soapEnvelope.getHeader();
        if (soapHeaders == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Header from the request envelope");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        return soapHeaders;
    }

    private IAddressingInformation createAddressingInformation(String strWSAddressingNamespace, OMElement omTo, OMElement omFrom, OMElement omActionIn) {
        AddressingInformation addressingInformation;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
            }
            addressingInformation = new AddressingInformation();
            URI uriAddressingNamespace = null;
            try {
                uriAddressingNamespace = new URI(strWSAddressingNamespace);
                addressingInformation.setNamespace(uriAddressingNamespace);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            if (null != omTo) {
                try {
                    addressingInformation.setTo(new URI(omTo.getText()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "To: " + omTo.getText());
                    }
                    break block16;
                }
                catch (URISyntaxException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "To: unable to set addressingInformation");
                    }
                    break block16;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "To: <not found>");
            }
        }
        if (null != omFrom) {
            block17: {
                EndpointReference fromHeader = new EndpointReference();
                try {
                    String from = omFrom.getText();
                    URI uriFrom = new URI(from);
                    fromHeader.setAddress(uriFrom);
                    addressingInformation.setFrom(fromHeader);
                }
                catch (URISyntaxException e) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "From: unable to set addressingInformation");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "From: " + omFrom.getText());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "From: <not found>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
        }
        return addressingInformation;
    }

    private boolean getIsRequestSecurityTokenCollection(SOAPBody soapBody) throws SoapSecurityException {
        boolean isRequestSecurityTokenCollection = false;
        OMElement omRequest = null;
        try {
            omRequest = OMElementUtil.getOneAndOnlyOneChildElement(soapBody);
        }
        catch (TrustException e) {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        String strLocalName = omRequest.getLocalName();
        if (strLocalName.equals("RequestSecurityToken")) {
            isRequestSecurityTokenCollection = false;
        } else if (strLocalName.equals("RequestSecurityTokenCollection")) {
            isRequestSecurityTokenCollection = true;
        } else {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isRequestSecurityTokenCollection: " + isRequestSecurityTokenCollection);
        }
        return isRequestSecurityTokenCollection;
    }

    private ISTSRequest createSTSRequest(IAddressingInformation addressingInformation, SOAPHeader soapHeaders, SOAPBody soapBody, OMElement omTo, String strWSTrustNamespace, IConstants stsConstants, boolean isRequestSecurityTokenCollection) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
        }
        OMElement omRequest = null;
        try {
            omRequest = OMElementUtil.getOneAndOnlyOneChildElement(soapBody);
        }
        catch (TrustException e) {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        if (strWSTrustNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust") && isRequestSecurityTokenCollection) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Collection requests not supported for WS-Trust 1.0 Draft");
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        STSRequest stsRequest = new STSRequest();
        stsRequest.setAddressingInformation(addressingInformation);
        List requestSecurityTokenCollection = stsRequest.getRequestSecurityTokenCollection();
        if (requestSecurityTokenCollection == null) {
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        if (!isRequestSecurityTokenCollection) {
            IRequestSecurityToken requestSecurityToken = this.createRequestSecurityToken(soapHeaders, omRequest, omTo, strWSTrustNamespace, stsConstants);
            if (requestSecurityToken == null) {
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            requestSecurityTokenCollection.add(requestSecurityToken);
        } else {
            List<IRequestSecurityToken> requestSecurityTokenList = this.createRequestSecurityTokenList(soapHeaders, omRequest, omTo, strWSTrustNamespace, stsConstants);
            if (requestSecurityTokenList == null) {
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            requestSecurityTokenCollection.addAll(requestSecurityTokenList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTSRequestFromMessageContext(MessageContext messageContext)");
        }
        return stsRequest;
    }

    private List<IRequestSecurityToken> createRequestSecurityTokenList(SOAPHeader soapHeaders, OMElement omRequestSecurityTokenCollection, OMElement omTo, String strWSTrustNamespace, IConstants stsConstants) throws SoapSecurityException {
        ArrayList<IRequestSecurityToken> requestSecurityTokenList = new ArrayList<IRequestSecurityToken>();
        Iterator iterator = omRequestSecurityTokenCollection.getChildElements();
        URI uriRequestType = null;
        while (iterator.hasNext()) {
            OMElement omChildElement = (OMElement)iterator.next();
            if (omChildElement.getLocalName().equals("RequestSecurityToken")) {
                IRequestSecurityToken requestSecurityToken = this.createRequestSecurityToken(soapHeaders, omChildElement, omTo, strWSTrustNamespace, stsConstants);
                if (requestSecurityToken == null || requestSecurityToken.getRequestType() == null) {
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                }
                if (uriRequestType == null) {
                    uriRequestType = requestSecurityToken.getRequestType();
                } else if (!uriRequestType.equals(requestSecurityToken.getRequestType())) {
                    throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                }
                requestSecurityTokenList.add(requestSecurityToken);
                continue;
            }
            throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
        }
        return requestSecurityTokenList;
    }

    private IRequestSecurityToken createRequestSecurityToken(SOAPHeader soapHeaders, OMElement omRequestSecurityToken, OMElement omTo, String strWSTrustNamespace, IConstants stsConstants) throws SoapSecurityException {
        RequestSecurityToken requestSecurityToken;
        block72: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createRequestSecurityToken(SOAPEnvelope omEnvelope)");
            }
            String strWSUNamespace = stsConstants.getWSSecurityUtilityNamespace().toString();
            String strWSSENamespace = stsConstants.getWSSecurityNamespace().toString();
            requestSecurityToken = new RequestSecurityToken();
            try {
                URI uriToHeader;
                block73: {
                    OMAttribute attributeContext = omRequestSecurityToken.getAttribute(new QName("Context"));
                    if (null != attributeContext) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RST's contextURI:  " + attributeContext.getAttributeValue());
                        }
                        requestSecurityToken.setContext(attributeContext.getAttributeValue());
                    }
                    Iterator iterator = omRequestSecurityToken.getChildElements();
                    while (iterator.hasNext()) {
                        OMElement omElement = (OMElement)iterator.next();
                        String strLocalName = omElement.getLocalName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "strLocalName:  " + strLocalName + ": " + omElement.getText());
                        }
                        if (strLocalName.equals("TokenType")) {
                            requestSecurityToken.setTokenType(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("RequestType")) {
                            requestSecurityToken.setRequestType(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("AppliesTo")) {
                            OMElement omEndpointReference = null;
                            try {
                                omEndpointReference = OMElementUtil.getOnlyChildWithLocalName(omElement, "EndpointReference");
                            }
                            catch (TrustException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "No child with name 'EndpointReference' was found under the AppliesTo element.");
                                continue;
                            }
                            OMElement omAddress = null;
                            try {
                                omAddress = OMElementUtil.getOnlyChildWithLocalName(omEndpointReference, "Address");
                            }
                            catch (TrustException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "No child with name 'Address' was found undere the EndpointReference element.");
                                continue;
                            }
                            if (omAddress == null) continue;
                            String strAddress = omAddress.getText();
                            EndpointReference endpointReference = new EndpointReference();
                            endpointReference.setAddress(new URI(strAddress));
                            AppliesTo appliesTo = new AppliesTo();
                            appliesTo.setEndpointReference(endpointReference);
                            requestSecurityToken.setAppliesTo(appliesTo);
                            continue;
                        }
                        if (strLocalName.equals("Claims")) {
                            requestSecurityToken.setClaims(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("Entropy")) {
                            requestSecurityToken.setEntropy(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("Lifetime")) {
                            Date dateExpires;
                            Date dateCreated;
                            block70: {
                                OMElement omExpires;
                                block69: {
                                    OMElement omCreated;
                                    block68: {
                                        block67: {
                                            omCreated = null;
                                            try {
                                                omCreated = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(omElement, strWSUNamespace, "Created");
                                            }
                                            catch (TrustException e) {
                                                if (!tc.isDebugEnabled()) break block67;
                                                Tr.debug(tc, "'Created' element not found under the Lifetime element");
                                            }
                                        }
                                        omExpires = null;
                                        try {
                                            omExpires = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(omElement, strWSUNamespace, "Expires");
                                        }
                                        catch (TrustException e) {
                                            if (!tc.isDebugEnabled()) break block68;
                                            Tr.debug(tc, "'Expires' element not found under the Lifetime element");
                                        }
                                    }
                                    dateCreated = null;
                                    if (omCreated != null) {
                                        String strCreated = omCreated.getText();
                                        try {
                                            dateCreated = UTC.parse(strCreated);
                                        }
                                        catch (ParseException e) {
                                            if (!tc.isDebugEnabled()) break block69;
                                            Tr.debug(tc, "Unable to parse Created time: " + strCreated + ". " + e.getLocalizedMessage());
                                        }
                                    }
                                }
                                dateExpires = null;
                                if (omExpires != null) {
                                    String strExpires = omExpires.getText();
                                    try {
                                        dateExpires = UTC.parse(strExpires);
                                    }
                                    catch (ParseException e) {
                                        if (!tc.isDebugEnabled()) break block70;
                                        Tr.debug(tc, "Unable to parse Created time: " + strExpires + ". " + e.getLocalizedMessage());
                                    }
                                }
                            }
                            if (dateCreated == null && dateExpires == null) continue;
                            Lifetime lifetime = new Lifetime();
                            if (dateCreated != null) {
                                lifetime.setCreated(dateCreated);
                            }
                            if (dateExpires != null) {
                                lifetime.setExpires(dateExpires);
                            }
                            requestSecurityToken.setLifetime(lifetime);
                            continue;
                        }
                        if (strLocalName.equals("AllowPostdating")) {
                            requestSecurityToken.setAllowPostdating(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("Renewing")) {
                            requestSecurityToken.setRenewing(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("OnBehalfOf")) {
                            requestSecurityToken.setOnBehalfOf(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("Issuer")) {
                            String strIssuer = omElement.getText();
                            if (strIssuer == null) continue;
                            EndpointReference endpointReference = new EndpointReference();
                            endpointReference.setAddress(new URI(strIssuer));
                            requestSecurityToken.setIssuer(endpointReference);
                            continue;
                        }
                        if (strLocalName.equals("AuthenticationType")) {
                            requestSecurityToken.setAuthenticationType(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("KeyType")) {
                            requestSecurityToken.setKeyType(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("KeySize")) {
                            requestSecurityToken.setKeySize(new Integer(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("SignatureAlgorithm")) {
                            requestSecurityToken.setSignatureAlgorithm(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("Encryption")) {
                            requestSecurityToken.setEncryption(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("EncryptionAlgorithm")) {
                            requestSecurityToken.setEncryptionAlgorithm(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("CanonicalizationAlgorithm")) {
                            requestSecurityToken.setCanonicalizationAlgorithm(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("ProofEncryption")) {
                            requestSecurityToken.setProofEncryption(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("UseKey")) {
                            requestSecurityToken.setUseKey(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("SignWith")) {
                            requestSecurityToken.setSignWith(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("EncryptWith")) {
                            requestSecurityToken.setEncryptWith(new URI(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("DelegateTo")) {
                            requestSecurityToken.setDelegateTo(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("Forwardable")) {
                            requestSecurityToken.setForwardable(new Boolean(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("Delegatable")) {
                            requestSecurityToken.setDelegatable(new Boolean(omElement.getText()));
                            continue;
                        }
                        if (strLocalName.equals("Policy")) {
                            requestSecurityToken.setPolicy(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("PolicyReference")) {
                            requestSecurityToken.setPolicyReference(XMLHelper.toElement(omElement));
                            continue;
                        }
                        if (strLocalName.equals("CancelTarget") || strLocalName.equals("ValidateTarget") || strLocalName.equals("RenewTarget")) {
                            IElement iSecurityToken;
                            block71: {
                                OMElement omChildElement = OMElementUtil.getOneAndOnlyOneChildElement(omElement);
                                String childLocalName = omChildElement.getLocalName();
                                OMElement omSecurityToken = omChildElement;
                                if (childLocalName.equals("SecurityTokenReference")) {
                                    omSecurityToken = this.resolveSecurityTokenReference(omChildElement, soapHeaders, strWSSENamespace);
                                    omElement.addChild(omSecurityToken);
                                }
                                iSecurityToken = XMLHelper.toElement(omElement);
                                if (tc.isDebugEnabled()) {
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, OMElementUtil.formatXML(omElement));
                                        }
                                        String uuid = SCTHelper.extractTextFrom(iSecurityToken, new String[]{omSecurityToken.getLocalName(), "Identifier"});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Target's UUID:  " + uuid);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!tc.isDebugEnabled()) break block71;
                                        Tr.debug(tc, "unable to retrieve Target UUID");
                                    }
                                }
                            }
                            if (strLocalName.equals("CancelTarget")) {
                                requestSecurityToken.setCancelTarget(iSecurityToken);
                                continue;
                            }
                            if (strLocalName.equals("ValidateTarget")) {
                                requestSecurityToken.setValidateTarget(iSecurityToken);
                                continue;
                            }
                            if (!strLocalName.equals("RenewTarget")) continue;
                            requestSecurityToken.setRenewTarget(iSecurityToken);
                            continue;
                        }
                        List anyOtherElements = requestSecurityToken.getAnyOtherElements();
                        anyOtherElements.add(XMLHelper.toElement(omElement));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, " ->anyOther: " + omElement.getText());
                    }
                    if (requestSecurityToken.getRequestType() == null) {
                        Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6853E"));
                        throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                    }
                    if (requestSecurityToken.getAppliesTo() != null) break block72;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppliesTo element was not found; substituting with To address.");
                    }
                    String strToHeader = "";
                    uriToHeader = null;
                    try {
                        strToHeader = omTo.getText();
                        uriToHeader = new URI(strToHeader);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block73;
                        Tr.debug(tc, "AppliesTo element substituted with To address: " + strToHeader);
                    }
                }
                if (null != uriToHeader) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppliesTo element substituted with To address: " + uriToHeader.toString());
                    }
                    EndpointReference endpointReference = new EndpointReference();
                    endpointReference.setAddress(uriToHeader);
                    AppliesTo appliesToHeader = new AppliesTo();
                    appliesToHeader.setEndpointReference(endpointReference);
                    requestSecurityToken.setAppliesTo(appliesToHeader);
                    break block72;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Both AppliesTo and To are null.");
                }
                Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6853E"));
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in createRequestSecurityTokenFromMessageContext" + e);
                }
                Tr.processException(e, this.getClass().getName() + "createRSTFromSoapEnvelope", FFDC_ID_4);
                throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestSecurityToken(SOAPEnvelope omEnvelope)");
        }
        return requestSecurityToken;
    }

    private OMElement resolveSecurityTokenReference(OMElement omElement, SOAPHeader soapHeaders, String strWSSENamespace) throws SoapSecurityException {
        String strURI;
        OMAttribute attributeURI;
        OMElement omReference;
        OMElement omSecurityToken;
        block8: {
            omSecurityToken = null;
            omReference = null;
            try {
                omReference = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(omElement, strWSSENamespace, "Reference");
            }
            catch (TrustException e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "'Reference' element not found under the SecurityTokenReference");
            }
        }
        if (omReference != null && (attributeURI = omReference.getAttribute(new QName("URI"))) != null && (strURI = attributeURI.getAttributeValue()) != null && strURI.startsWith("#")) {
            strURI = strURI.substring(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for wsse:Id '" + strURI + "'");
            }
            if ((omSecurityToken = this.getSecurityTokenFromHeaders(soapHeaders, strWSSENamespace, strURI)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " Found an SecurityToken Item :" + omSecurityToken);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did Not Find an SecurityToken Item");
            }
        }
        return omSecurityToken;
    }

    private OMElement getSecurityTokenFromHeaders(SOAPHeader soapHeaders, String wsseNamespace, String strID) throws SoapSecurityException {
        QName SecurityQName = new QName(wsseNamespace, "Security");
        OMElement omSecurityToken = null;
        Iterator iterHeaders = soapHeaders.getChildrenWithName(SecurityQName);
        while (iterHeaders.hasNext()) {
            OMElement omHeader = (OMElement)iterHeaders.next();
            String strLocalName = omHeader.getLocalName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Security Item :" + omHeader);
            }
            Iterator iter = omHeader.getChildren();
            while (iter.hasNext()) {
                OMElement child = (OMElement)iter.next();
                Iterator iterAttrs = child.getAllAttributes();
                while (iterAttrs.hasNext()) {
                    String strValue;
                    OMAttribute attr = (OMAttribute)iterAttrs.next();
                    if (!attr.getLocalName().equals("Id")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found an Item with Id :" + OMElementUtil.toString(child));
                    }
                    if (!(strValue = attr.getAttributeValue()).equals(strID)) continue;
                    if (omSecurityToken != null) {
                        Tr.warning(tc, "Found additional matching security token:" + OMElementUtil.toString(child));
                        Tr.error(tc, SoapSecurityException.getMessage("security.wssecurity.WSEC6853E"));
                        throw SoapSecurityException.format(Constants.TRUST_FAULT_INVALID_REQUEST, "security.wssecurity.WSEC6850E");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found matching security token:" + OMElementUtil.toString(child));
                    }
                    omSecurityToken = child;
                }
            }
        }
        return omSecurityToken;
    }
}

