/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v13;

import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.impl.TrustOMFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust13RequestSecurityTokenCollection
implements ITrustRequestSecurityTokenCollection {
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;
    private ArrayList<ITrustRequestSecurityToken> rstList = new ArrayList();

    public Trust13RequestSecurityTokenCollection(ITrustRequestSecurityToken rst) throws TrustException {
        this.validateRST(rst);
        this.rstList.add(rst);
    }

    public Trust13RequestSecurityTokenCollection(List<ITrustRequestSecurityToken> list) throws TrustException {
        try {
            for (ITrustRequestSecurityToken rst : list) {
                this.addTrustRequestSecurityToken(rst);
            }
        }
        catch (TrustException e) {
            this.clearList();
        }
    }

    @Override
    public void addTrustRequestSecurityToken(ITrustRequestSecurityToken rst) throws TrustException {
        this.validateRST(rst);
        this.rstList.add(rst);
    }

    public void clearList() {
        this.rstList.clear();
    }

    @Override
    public List<ITrustRequestSecurityToken> getList() {
        return this.rstList;
    }

    @Override
    public ITrustRequestSecurityToken getRequestSecurityToken(int index) {
        ITrustRequestSecurityToken rst = null;
        if (index < this.size()) {
            rst = this.rstList.get(index);
        }
        return rst;
    }

    @Override
    public int size() {
        return this.rstList.size();
    }

    private boolean compareNamespaceURI(OMNamespace om1, OMNamespace om2) {
        String ns2;
        String ns1;
        boolean rc = false;
        if (om1 != null && om2 != null && (ns1 = om1.getNamespaceURI()).equals(ns2 = om2.getNamespaceURI())) {
            rc = true;
        }
        return rc;
    }

    private boolean compareQName(OMElement om1, OMElement om2) {
        QName qn2;
        QName qn1;
        boolean rc = false;
        if (om1 != null && om2 != null && (qn1 = om1.getQName()).equals(qn2 = om2.getQName())) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void validateRST(ITrustRequestSecurityToken rst) throws TrustException {
        if (this.size() == 0) {
            if (rst.getTo() == null) {
                throw TrustException.format("invalid parameter");
            }
            if (rst.getMessageID() == null) {
                throw TrustException.format("invalid parameter");
            }
            if (rst.getAction() == null) {
                throw TrustException.format("invalid parameter");
            }
        } else {
            OMElement to0 = this.getTo();
            OMElement to = rst.getTo();
            if (to != null && !this.compareQName(to, to0)) {
                throw TrustException.format("invalid parameter");
            }
            OMElement messageID0 = this.getMessageID();
            OMElement messageID = rst.getMessageID();
            if (messageID != null && !this.compareQName(messageID, messageID0)) {
                throw TrustException.format("invalid parameter");
            }
            OMElement action0 = this.getAction();
            OMElement action = rst.getAction();
            if (action != null && !this.compareQName(action0, action)) {
                throw TrustException.format("invalid parameter");
            }
            OMNamespace wst0 = this.getWSTNamespace();
            OMNamespace wst = rst.getWSTNamespace();
            if (wst != null && !this.compareNamespaceURI(wst0, wst)) {
                throw TrustException.format("invalid parameter");
            }
            OMNamespace wsa0 = this.getWSANamespace();
            OMNamespace wsa = rst.getWSANamespace();
            if (wsa != null && !this.compareNamespaceURI(wsa0, wsa)) {
                throw TrustException.format("invalid parameter");
            }
            boolean found = false;
            List<OMElement> other0 = this.getOtherHeaders();
            List<OMElement> other = rst.getOtherHeaders();
            if (other != null && other.size() > 0) {
                for (OMElement header : other) {
                    for (OMElement header0 : other0) {
                        if (!this.compareQName(header, header0)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw TrustException.format("invalid parameter");
                }
            }
            OMElement replyTo0 = this.getReplyTo();
            OMElement replyTo = rst.getReplyTo();
            if (!(replyTo == null || replyTo0 != null && this.compareQName(replyTo0, replyTo))) {
                throw TrustException.format("invalid parameter");
            }
            OMElement from0 = this.getFrom();
            OMElement from = rst.getFrom();
            if (!(from == null || from0 != null && this.compareQName(from0, from))) {
                throw TrustException.format("invalid parameter");
            }
        }
    }

    @Override
    public OMElement getTo() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMElement to = rst.getTo();
        return to;
    }

    @Override
    public OMElement getReplyTo() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMElement replyTo = rst.getReplyTo();
        return replyTo;
    }

    @Override
    public OMElement getMessageID() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMElement messageID = rst.getMessageID();
        return messageID;
    }

    @Override
    public OMElement getAction() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMElement action = rst.getAction();
        return action;
    }

    @Override
    public OMElement getFrom() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMElement from = rst.getFrom();
        return from;
    }

    @Override
    public OMNamespace getWSTNamespace() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMNamespace wst = rst.getWSTNamespace();
        return wst;
    }

    @Override
    public OMNamespace getWSANamespace() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        OMNamespace wsa = rst.getWSANamespace();
        return wsa;
    }

    @Override
    public OMElement getBody() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        OMElement body = TrustOMFactory.createOMElementNoText("RequestSecurityTokenCollection", this.getWSTNamespace());
        for (ITrustRequestSecurityToken rst : this.rstList) {
            OMElement request = rst.getBody();
            body.addChild(request);
        }
        return body;
    }

    @Override
    public List<OMElement> getOtherHeaders() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        List<OMElement> headers = rst.getOtherHeaders();
        return headers;
    }

    @Override
    public Stub getSecurityTokenServiceStub() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        Stub stub = rst.getSecurityTokenServiceStub();
        return stub;
    }

    @Override
    public AxisService getAxisService() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        AxisService axisSerice = rst.getAxisService();
        return axisSerice;
    }

    @Override
    public ServiceClient getServiceClient() throws TrustException {
        if (this.size() == 0) {
            throw TrustException.format("invalid parameter");
        }
        ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
        ServiceClient serviceClient = rst.getServiceClient();
        return serviceClient;
    }

    @Override
    public void setContextURI(String contextURI) {
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust13RequestSecurityTokenCollection.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

