/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v10draft;

import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.impl.TrustOMFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust10RequestSecurityTokenTemplate
implements ITrustRequestSecurityTokenTemplate {
    protected List<OMElement> otherHeaderList = new ArrayList<OMElement>();
    protected List<OMElement> bodyList = new ArrayList<OMElement>();
    protected OMElement to = null;
    protected OMElement replyto = null;
    protected OMElement messageid = null;
    protected OMElement action = null;
    protected OMElement from = null;
    protected String ns_wsa = null;
    protected String ns_wsp = null;
    protected String ns_wst = null;
    protected String ns_wsc = null;
    protected OMNamespace omWSA = null;
    protected OMNamespace omWSP = null;
    protected OMNamespace omWST = null;
    protected OMNamespace omWSC = null;
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    public Trust10RequestSecurityTokenTemplate() {
        String method = "Trust10RequestSecurityTokenTemplate()";
        try {
            this.setWSANamespace("http://www.w3.org/2005/08/addressing");
            this.setWSPNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy");
            this.setWSTNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
            this.setWSCNamespace("http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        catch (TrustException e) {
            String errorMessage = e.getMessage();
            log.logp(level, CLASSNAME, method, errorMessage);
        }
    }

    @Override
    public void setWSANamespace(String ns) {
        this.ns_wsa = ns;
        this.omWSA = TrustOMFactory.createOMNamespace(ns, "wsa");
    }

    @Override
    public void setWSPNamespace(String ns) {
        this.ns_wsp = ns;
        this.omWSP = TrustOMFactory.createOMNamespace(ns, "wsp");
    }

    public void setWSTNamespace(String ns) throws TrustException {
        String method = "setWSTNamespace()";
        if (!ns.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            String errorMessage = "invalid_namespace";
            log.logp(level, CLASSNAME, method, errorMessage + ": Invalid WS-Trust Namespace");
            throw TrustException.format(errorMessage, ns);
        }
        this.ns_wst = ns;
        this.omWST = TrustOMFactory.createOMNamespace(ns, "wst");
    }

    public void setWSCNamespace(String ns) throws TrustException {
        String method = "setWSCNamespace()";
        if (!ns.equals("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            String errorMessage = "invalid_namespace";
            log.logp(level, CLASSNAME, method, errorMessage + ": Invalid WS-SecureConversation Namespace");
            throw TrustException.format(errorMessage, ns);
        }
        this.ns_wsc = ns;
        this.omWSC = TrustOMFactory.createOMNamespace(ns, "wsc");
    }

    @Override
    public void addBodyElement(OMElement element) {
        this.bodyList.add(element);
    }

    @Override
    public boolean addHeader(OMElement header) {
        return this.otherHeaderList.add(header);
    }

    public OMElement getHeader(QName qname) {
        OMElement header = null;
        for (OMElement element : this.otherHeaderList) {
            if (!qname.equals(element.getQName())) continue;
            header = element;
            break;
        }
        return header;
    }

    @Override
    public boolean validateNamespace(QName qname) {
        return false;
    }

    @Override
    public List<OMElement> getBodyList() {
        return this.bodyList;
    }

    @Override
    public OMElement getAction() {
        return this.action;
    }

    @Override
    public OMElement getFrom() {
        return this.from;
    }

    @Override
    public OMElement getMessageID() {
        return this.messageid;
    }

    @Override
    public OMElement getReplyTo() {
        return this.replyto;
    }

    @Override
    public OMElement getTo() {
        return this.to;
    }

    @Override
    public void setAction(OMElement action) {
        this.action = action;
    }

    @Override
    public void setAction(String action) {
        this.action = TrustOMFactory.createOMElementWithText(action, "Action", this.omWSA);
    }

    @Override
    public void setFrom(OMElement from) {
        this.from = from;
    }

    @Override
    public void setFrom(String from) {
        this.from = TrustOMFactory.createOMElementWithText(from, "From", this.omWSA);
    }

    @Override
    public void setMessageID(OMElement messageID) {
        this.messageid = messageID;
    }

    @Override
    public void setMessageID(String messageID) {
        this.messageid = TrustOMFactory.createOMElementWithText(messageID, "MessageID", this.omWSA);
    }

    @Override
    public void setReplyTo(OMElement replyto) {
        this.replyto = replyto;
    }

    @Override
    public void setReplyTo(String replyto) {
        this.replyto = TrustOMFactory.createOMElementWithText(replyto, "ReplyTo", this.omWSA);
    }

    @Override
    public void setTo(OMElement to) {
        this.to = to;
    }

    @Override
    public void setTo(String to) {
        this.to = TrustOMFactory.createOMElementWithText(to, "To", this.omWSA);
    }

    @Override
    public void addAppliesTo(String serviceEndpointAddress) {
        OMElement addressElement = TrustOMFactory.createOMElementWithText(serviceEndpointAddress, "Address", this.omWSA);
        OMElement endpointReference = TrustOMFactory.createOMElementNoText("EndpointReference", this.ns_wsa, "wsa");
        endpointReference.addChild(addressElement);
        OMElement appliesTo = TrustOMFactory.createOMElementNoText("AppliesTo", this.ns_wsp, "wsp");
        appliesTo.addChild(endpointReference);
        this.addBodyElement(appliesTo);
    }

    @Override
    public void addEntropyNonce(String binarySecret) {
        this.addEntropy(binarySecret, "http://schemas.xmlsoap.org/ws/2005/02/trust/Nonce");
    }

    @Override
    public void addEntropy(String binarySecret, String binarySecretType) {
        OMElement binarySecretElement = TrustOMFactory.createOMElementWithText(binarySecret, "BinarySecret", this.omWST);
        OMAttribute omType = TrustOMFactory.createOMAttributeBlankNamespace("Type", binarySecretType);
        binarySecretElement.addAttribute(omType);
        OMElement entropy = TrustOMFactory.createOMElementNoText("Entropy", this.ns_wst, "wst");
        entropy.addChild(binarySecretElement);
        this.addBodyElement(entropy);
    }

    @Override
    public void addKeySize(String keySize) {
        OMElement omKeySize = TrustOMFactory.createOMElementWithText(keySize, "KeySize", this.omWST);
        this.addBodyElement(omKeySize);
    }

    @Override
    public void addRequestType(String requestType) {
        OMElement omRequestType = TrustOMFactory.createOMElementWithText(requestType, "RequestType", this.omWST);
        this.addBodyElement(omRequestType);
    }

    @Override
    public void addTokenType(String tokenType) {
        OMElement omTokenType = TrustOMFactory.createOMElementWithText(tokenType, "TokenType", this.omWST);
        this.addBodyElement(omTokenType);
    }

    @Override
    public void addRenewing(Boolean allow, Boolean ok) {
        OMElement omRenewing = TrustOMFactory.createOMElementNoText("Renewing", this.omWST);
        if (allow != null) {
            OMAttribute omAllow = TrustOMFactory.createOMAttributeBlankNamespace("Allow", allow.toString());
            omRenewing.addAttribute(omAllow);
        }
        if (ok != null) {
            OMAttribute omOK = TrustOMFactory.createOMAttributeBlankNamespace("OK", ok.toString());
            omRenewing.addAttribute(omOK);
        }
        this.addBodyElement(omRenewing);
    }

    public void addRenewTarget(String renewTarget) {
        OMElement omRenewTarget = TrustOMFactory.createOMElementWithText(renewTarget, "RenewTarget", this.omWST);
        this.addBodyElement(omRenewTarget);
    }

    public void addCancelTarget(String cancelTarget) {
        OMElement omCancelTarget = TrustOMFactory.createOMElementWithText(cancelTarget, "CancelTarget", this.omWST);
        this.addBodyElement(omCancelTarget);
    }

    @Override
    public void addRenewTarget(OMElement renewTarget) {
        OMElement omRenewTarget = TrustOMFactory.createOMElementNoText("RenewTarget", this.omWST);
        omRenewTarget.addChild(renewTarget);
        this.addBodyElement(omRenewTarget);
    }

    @Override
    public void addCancelTarget(OMElement cancelTarget) {
        OMElement omCancelTarget = TrustOMFactory.createOMElementNoText("CancelTarget", this.omWST);
        omCancelTarget.addChild(cancelTarget);
        this.addBodyElement(omCancelTarget);
    }

    @Override
    public void addValidateTarget(OMElement validateTarget) {
        OMElement omValidateTarget = TrustOMFactory.createOMElementNoText("ValidateTarget", this.omWST);
        omValidateTarget.addChild(validateTarget);
        this.addBodyElement(omValidateTarget);
    }

    @Override
    public OMNamespace getWSTNamespace() {
        return this.omWST;
    }

    @Override
    public OMNamespace getWSANamespace() {
        return this.omWSA;
    }

    @Override
    public String getWSANamespaceText() {
        return this.ns_wsa;
    }

    @Override
    public void setActionCancel(String tokenType) {
        if (tokenType.equals("http://schemas.xmlsoap.org/ws/2005/02/sc/sct")) {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel");
        } else {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Cancel");
        }
    }

    @Override
    public void setActionIssue(String tokenType) {
        if (tokenType.equals("http://schemas.xmlsoap.org/ws/2005/02/sc/sct")) {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT");
        } else {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
        }
    }

    @Override
    public void setActionRenew(String tokenType) {
        if (tokenType.equals("http://schemas.xmlsoap.org/ws/2005/02/sc/sct")) {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Renew");
        } else {
            this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Renew");
        }
    }

    @Override
    public void setActionValidate() {
        this.setAction("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Validate");
    }

    @Override
    public void addRequestTypeCancel() {
        this.addRequestType("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel");
    }

    @Override
    public void addRequestTypeIssue() {
        this.addRequestType("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
    }

    @Override
    public void addRequestTypeRenew() {
        this.addRequestType("http://schemas.xmlsoap.org/ws/2005/02/trust/Renew");
    }

    @Override
    public void addRequestTypeValidate() {
        this.addRequestType("http://schemas.xmlsoap.org/ws/2005/02/trust/Validate");
    }

    @Override
    public List<OMElement> getOtherHeaders() {
        return this.otherHeaderList;
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust10RequestSecurityTokenTemplate.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

