/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v10draft;

import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.impl.OMElementUtil;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.util.IdUtils;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;

public class Trust10RequestSecurityTokenResponse
implements ITrustRequestSecurityTokenResponse {
    OMElement rstr = null;
    OMElement securityContextTokenElement = null;
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    Trust10RequestSecurityTokenResponse(OMElement rstr) {
        String method = "Trust10RequestSecurityTokenResponse()";
        log.logp(level, CLASSNAME, method, "rstr: " + OMElementUtil.toString(rstr));
        this.rstr = rstr;
    }

    public OMElement getChildWithName(String namespaceURI, String localname) throws TrustException {
        String method = "getChildWithName()";
        log.logp(level, CLASSNAME, method, "namespaceURI: " + namespaceURI);
        log.logp(level, CLASSNAME, method, "localname: " + localname);
        return OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, namespaceURI, localname);
    }

    public OMElement getChildWithName(String localname) throws TrustException {
        String method = "getChildWithName()";
        log.logp(level, CLASSNAME, method, "localname: " + localname);
        return this.getChildWithName("http://schemas.xmlsoap.org/ws/2005/02/trust", localname);
    }

    public OMElement getChildWithLocalName(String localname) throws Exception {
        String method = "getChildWithLocalName()";
        log.logp(level, CLASSNAME, method, "localname: " + localname);
        return OMElementUtil.getOnlyChildWithLocalName(this.rstr, localname);
    }

    public Date getCreatedDate() throws TrustException {
        String method = "getCreatedDate()";
        OMElement lifetime = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Lifetime");
        Trust10RequestSecurityTokenResponse.log(method, "lifetime: " + OMElementUtil.toString(lifetime));
        OMElement createdElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(lifetime, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
        Trust10RequestSecurityTokenResponse.log(method, "createdElement: " + OMElementUtil.toString(createdElement));
        String created = createdElement.getText();
        Date createdDate = null;
        if (created == null) {
            String error = "child_element_not_found";
            Trust10RequestSecurityTokenResponse.log(method, error + ": Created Element");
            throw TrustException.format(error, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
        }
        createdDate = Trust10RequestSecurityTokenResponse.parseDateTime(created);
        return createdDate;
    }

    public static final Date parseDateTime(String s) {
        String method = "parseDateTime()";
        log.logp(level, CLASSNAME, method, "s: " + s);
        if (s == null) {
            return null;
        }
        try {
            Date d = UTC.parse(s);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getExpiresDate() throws TrustException {
        String method = "getExpiresDate()";
        OMElement lifetime = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Lifetime");
        Trust10RequestSecurityTokenResponse.log(method, "lifetime: " + OMElementUtil.toString(lifetime));
        OMElement expiresElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(lifetime, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
        Trust10RequestSecurityTokenResponse.log(method, "expiresElement: " + OMElementUtil.toString(expiresElement));
        String expires = expiresElement.getText();
        Date expiresDate = null;
        if (expires == null) {
            String error = "child_element_not_found";
            Trust10RequestSecurityTokenResponse.log(method, error + ": Expires Element");
            throw TrustException.format(error, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
        }
        expiresDate = Trust10RequestSecurityTokenResponse.parseDateTime(expires);
        return expiresDate;
    }

    public String getInstance() throws TrustException {
        String instance = null;
        this.getSecurityContextTokenElement();
        OMElement instanceElement = OMElementUtil.getOneOrLessChildWithLocalNameAndVerifyNamespace(this.securityContextTokenElement, "http://schemas.xmlsoap.org/ws/2005/02/sc", "Instance");
        if (instanceElement != null) {
            instance = instanceElement.getText();
        }
        return instance;
    }

    public String getID() throws TrustException {
        this.getSecurityContextTokenElement();
        QName s = IdUtils.getInstance().getIdAttributeName(this.securityContextTokenElement);
        String id = null;
        if (s != null) {
            id = this.securityContextTokenElement.getAttributeValue(s);
        }
        return id;
    }

    public Integer getKeySize() throws TrustException {
        Integer keySize = null;
        String keySizeTxt = null;
        OMElement omKeySize = OMElementUtil.getOneOrLessChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "KeySize");
        if (omKeySize != null) {
            keySizeTxt = omKeySize.getText();
            keySize = new Integer(keySizeTxt);
        }
        return keySize;
    }

    public OMElement getSecurityContextTokenElement() throws TrustException {
        String method = "getSecurityContextTokenElement()";
        if (this.securityContextTokenElement == null) {
            OMElement requestedSecurityTokenElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedSecurityToken");
            this.securityContextTokenElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(requestedSecurityTokenElement, "http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
            Trust10RequestSecurityTokenResponse.log(method, "securityContextTokenElement: " + OMElementUtil.toString(this.securityContextTokenElement));
        }
        return this.securityContextTokenElement;
    }

    public byte[] getServerSecretBytes() throws TrustException {
        OMElement serverEntropy = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Entropy");
        OMElement serverBinarySecret = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(serverEntropy, "http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret");
        String serverBinarySecretText = serverBinarySecret.getText();
        return Base64.decode(serverBinarySecretText);
    }

    public String getUUID() throws TrustException {
        this.getSecurityContextTokenElement();
        OMElement identifierElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.securityContextTokenElement, "http://schemas.xmlsoap.org/ws/2005/02/sc", "Identifier");
        return identifierElement.getText();
    }

    public String getAppliesTo() throws TrustException {
        OMElement appliesToElement = this.getAppliesToElement();
        OMElement appliesToEndpointReferenceElement = OMElementUtil.getOnlyChildWithLocalName(appliesToElement, "EndpointReference");
        OMElement appliesToAddressElement = OMElementUtil.getOnlyChildWithLocalName(appliesToEndpointReferenceElement, "Address");
        return appliesToAddressElement.getText();
    }

    public OMElement getAppliesToElement() throws TrustException {
        return OMElementUtil.getOnlyChildWithLocalName(this.rstr, "AppliesTo");
    }

    public OMElement getAppliesToElementVerifyNamespace(String namespaceURI) throws TrustException {
        String method = "getAppliesToElementVerifyNamespace()";
        log.logp(level, CLASSNAME, method, "namespaceURI: " + namespaceURI);
        return OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, namespaceURI, "AppliesTo");
    }

    public String getAppliesToVerifyNamespace(String namespaceURI) throws TrustException {
        String method = "getAppliesToVerifyNamespace()";
        log.logp(level, CLASSNAME, method, "namespaceURI: " + namespaceURI);
        OMElement appliesToElement = this.getAppliesToElementVerifyNamespace(namespaceURI);
        OMElement appliesToEndpointReferenceElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(appliesToElement, "http://www.w3.org/2005/08/addressing", "EndpointReference");
        OMElement appliesToAddressElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(appliesToEndpointReferenceElement, "http://www.w3.org/2005/08/addressing", "Address");
        return appliesToAddressElement.getText();
    }

    public String getRenewable() throws TrustException {
        String renewableAllow = null;
        OMElement renewingElement = OMElementUtil.getOneOrLessChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Renewing");
        if (renewingElement != null) {
            renewableAllow = OMElementUtil.getAttributeValueBlankNamespace(renewingElement, "Allow");
        }
        return renewableAllow;
    }

    public String getRenewableAfterExpiration() throws TrustException {
        String renewableOK = null;
        OMElement renewingElement = OMElementUtil.getOneOrLessChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Renewing");
        if (renewingElement != null) {
            renewableOK = OMElementUtil.getAttributeValueBlankNamespace(renewingElement, "OK");
        }
        return renewableOK;
    }

    public OMElement getRequestedTokenCancelledElement() throws TrustException {
        return OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedTokenCancelled");
    }

    public Boolean isTokenCancelled() {
        Boolean isCancelled = false;
        try {
            OMElement isCancelledElement = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedTokenCancelled");
            if (isCancelledElement != null) {
                isCancelled = true;
            }
        }
        catch (Exception e) {
            isCancelled = false;
        }
        return isCancelled;
    }

    public String getStatusCode() throws TrustException {
        OMElement status = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Status");
        OMElement code = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(status, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Code");
        return code.getText();
    }

    public String getStatusReason() throws TrustException {
        OMElement status = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(this.rstr, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Status");
        OMElement reason = OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(status, "http://schemas.xmlsoap.org/ws/2005/02/trust", "Reason");
        return reason.getText();
    }

    private static void log(String method, String msg) {
        int block = 1500;
        int lastchar = msg.length();
        log.logp(level, CLASSNAME, method, msg.substring(0, Trust10RequestSecurityTokenResponse.min(lastchar, block)));
        if (lastchar >= block) {
            log.logp(level, CLASSNAME, method, msg.substring(block, Trust10RequestSecurityTokenResponse.min(lastchar, block * 2)));
            if (lastchar >= block * 2) {
                log.logp(level, CLASSNAME, method, msg.substring(block * 2), Trust10RequestSecurityTokenResponse.min(lastchar, block * 3));
                if (lastchar >= block * 3) {
                    log.logp(level, CLASSNAME, method, msg.substring(block * 3));
                }
            }
        }
    }

    private static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust10RequestSecurityTokenResponse.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

