/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.impl;

import com.ibm.ws.wssecurity.trust.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.v10draft.Trust10Client;
import com.ibm.ws.wssecurity.trust.client.v13.Trust13Client;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrustClientFactory {
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    public static ITrustClient getTrustClient(String trustNamespace) throws TrustException {
        String method = "getTrustClient()";
        ITrustClient client = null;
        if (trustNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            client = new Trust10Client();
        } else if (trustNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            client = new Trust13Client();
        }
        if (client == null) {
            String errorMessage = "unable_to_instantiate_trust_client";
            log.logp(level, CLASSNAME, method, errorMessage);
            throw TrustException.format(errorMessage);
        }
        return client;
    }

    static {
        level = Level.FINE;
        CLASSNAME = TrustClientFactory.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

