/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.impl;

import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.util.XMLPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMElementUtil {
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    public static String formatXML(OMElement omInput) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String output = "";
        try {
            XMLPrettyPrinter.prettify(omInput, out);
        }
        catch (Exception e) {
            output = OMElementUtil.toString(omInput);
        }
        output = out.toString();
        return output;
    }

    public static OMElement getOnlyChildWithLocalNameAndVerifyNamespace(OMElement parent, String namespaceURI, String localname) throws TrustException {
        String method = "getOnlyChildWithLocalNameAndVerifyNamespace()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "namespaceURI: " + namespaceURI);
        OMElementUtil.log(method, "localname: " + localname);
        OMElement child = OMElementUtil.getOnlyChildWithLocalName(parent, localname);
        boolean rc = OMElementUtil.verifyNamespaceURI(child, namespaceURI);
        if (!rc) {
            throw TrustException.format("invalid_namespace", namespaceURI);
        }
        return child;
    }

    public static OMElement getOneOrLessChildWithLocalNameAndVerifyNamespace(OMElement parent, String namespaceURI, String localname) throws TrustException {
        boolean rc;
        String method = "getOnlyChildWithLocalNameAndVerifyNamespace()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "namespaceURI: " + namespaceURI);
        OMElementUtil.log(method, "localname: " + localname);
        OMElement child = OMElementUtil.getOneOrLessChildWithLocalName(parent, localname);
        if (child != null && !(rc = OMElementUtil.verifyNamespaceURI(child, namespaceURI))) {
            child = null;
        }
        return child;
    }

    public static OMElement getOneAndOnlyOneChildElement(OMElement parent) throws TrustException {
        return OMElementUtil.getOneAndOnlyOneChildElement(parent, "unknown", "unknown");
    }

    public static OMElement getOneAndOnlyOneChildElement(OMElement parent, String ns, String localname) throws TrustException {
        String method = "getOneAndOnlyOneChildElement()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElement onlyChild = null;
        if (parent == null) {
            throw TrustException.format("invalid_value_specified", "parent is null");
        }
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            OMElement child = (OMElement)i.next();
            if (onlyChild == null) {
                onlyChild = child;
                continue;
            }
            throw TrustException.format("too_many_child_elements", parent.getNamespace().getNamespaceURI(), parent.getLocalName());
        }
        if (onlyChild == null) {
            throw TrustException.format("child_element_not_found", ns, localname);
        }
        return onlyChild;
    }

    public static OMElement getOneOrLessChildWithLocalName(OMElement parent, String localname) throws TrustException {
        String method = "getOneOrLessChildWithLocalName()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "localname: " + localname);
        OMElement onlyChild = null;
        if (parent == null || localname == null) {
            throw TrustException.format("invalid_value_specified", "parent or localname is null");
        }
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            OMElement child = (OMElement)i.next();
            if (!child.getLocalName().equals(localname)) continue;
            if (onlyChild == null) {
                onlyChild = child;
                continue;
            }
            throw TrustException.format("too_many_child_elements", parent.getNamespace().getNamespaceURI(), parent.getLocalName());
        }
        return onlyChild;
    }

    public static OMElement getOnlyChildWithLocalName(OMElement parent, String localname) throws TrustException {
        String method = "getOnlyChildWithLocalName()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "localname: " + localname);
        OMElement onlyChild = null;
        if (parent == null || localname == null) {
            throw TrustException.format("invalid_value_specified", "parent or localname is null");
        }
        onlyChild = OMElementUtil.getOneOrLessChildWithLocalName(parent, localname);
        if (onlyChild == null) {
            throw TrustException.format("child_element_not_found", "null", localname);
        }
        return onlyChild;
    }

    public static ArrayList<OMElement> getChildrenWithNamespaceURI(OMElement parent, String namespaceURI) throws TrustException {
        String method = "getChildrenWithNamespaceURI()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "namespaceURI: " + namespaceURI);
        ArrayList<OMElement> childrenWithNamespace = new ArrayList<OMElement>();
        if (parent == null || namespaceURI == null) {
            throw TrustException.format("invalid_value_specified", "parent or namespaceURI is null");
        }
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            OMElement child = (OMElement)i.next();
            if (child == null || child.getNamespace() == null || !child.getNamespace().getNamespaceURI().equals(namespaceURI)) continue;
            childrenWithNamespace.add(child);
        }
        return childrenWithNamespace;
    }

    public static Iterator getChildrenWithName(OMElement parent, String namespaceURI, String localname) throws TrustException {
        String method = "getChildrenWithName()";
        OMElementUtil.log(method, "parent: " + OMElementUtil.toString(parent));
        OMElementUtil.log(method, "namespaceURI: " + namespaceURI);
        OMElementUtil.log(method, "localname: " + localname);
        ArrayList<OMElement> children = new ArrayList<OMElement>();
        if (parent == null || localname == null) {
            throw TrustException.format("invalid_value_specified", "parent or localname is null");
        }
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            OMElement child = (OMElement)i.next();
            if (child == null || child.getLocalName() == null || child.getNamespace() == null || !child.getNamespace().getNamespaceURI().equals(namespaceURI) || !child.getLocalName().equals(localname)) continue;
            children.add(child);
        }
        return children.iterator();
    }

    public static Object getOneAndOnlyOne(Iterator i) throws TrustException {
        return OMElementUtil.getOneAndOnlyOne(i, "unknown", "unknown");
    }

    public static Object getOneAndOnlyOne(Iterator i, String ns, String localname) throws TrustException {
        Object object = null;
        if (i == null) {
            throw TrustException.format("invalid_value_specified", "Iterator is null");
        }
        if (i.hasNext()) {
            object = i.next();
            OMElement omObject = object;
            try {
                String strObject = OMElementUtil.toString(omObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw TrustException.format("child_element_not_found", ns, localname);
        }
        if (i.hasNext()) {
            Object object2 = i.next();
            OMElement omObject2 = (OMElement)object2;
            try {
                String strObject2 = OMElementUtil.toString(omObject2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw TrustException.format("too_many_child_elements", "unknown", "unknown");
        }
        return object;
    }

    public static String getAttributeValueBlankNamespace(OMElement element, String attribute) throws TrustException {
        String value = null;
        if (element == null || attribute == null) {
            throw TrustException.format("invalid_value_specified", "element or attribute is null");
        }
        value = element.getAttributeValue(new QName("", attribute));
        if (value == null) {
            throw TrustException.format("invalid_value_specified", attribute);
        }
        return value;
    }

    public static String getNamespaceURI(OMElement element) throws TrustException {
        String namespaceURI = null;
        if (element == null) {
            throw TrustException.format("invalid_value_specified", "element is null");
        }
        OMNamespace namespace = element.getNamespace();
        if (namespace == null) {
            throw TrustException.format("invalid_value_specified", "element namespace is null");
        }
        namespaceURI = namespace.getNamespaceURI();
        if (namespaceURI == null) {
            throw TrustException.format("invalid_value_specified", "element namespaceURI is null");
        }
        return namespaceURI;
    }

    public static boolean verifyNamespaceURI(OMElement element, String namespaceURI) throws TrustException {
        boolean rc = false;
        String elementNamespaceURI = OMElementUtil.getNamespaceURI(element);
        if (!namespaceURI.equals(elementNamespaceURI)) {
            throw TrustException.format("invalid_value_specified", "namespaces do not match");
        }
        rc = true;
        return rc;
    }

    public static String toString(OMElement omElement) {
        if (null == omElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String strElement = null;
        try {
            omElement.serialize(outputStream);
            strElement = outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return strElement;
    }

    private static void log(String method, String msg) {
        log.logp(level, CLASSNAME, method, msg);
    }

    static {
        level = Level.FINE;
        CLASSNAME = OMElementUtil.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

