/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.Permission;
import java.security.SecurityPermission;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;

public class WSSUserRegistryProcessor {
    private static final TraceComponent tc = Tr.register(WSSUserRegistryProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSUserRegistryProcessor.class.getName();
    private static WSSContextManager manager = WSSContextManagerFactory.getInstance();
    private static final Permission PERM = new SecurityPermission("wssecurity.WSUserRegistry.mapCertificate");

    public static boolean checkRegistry(String username, char[] password) throws LoginException {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRegistry()");
        }
        String name = null;
        try {
            if (manager != null) {
                if (tc.isDebugEnabled()) {
                    String pwd = password == null ? "null" : "not mull";
                    Tr.debug(tc, "Username [" + username + "], password [" + pwd + "]");
                }
                username = WSSUserRegistryProcessor.removeRealm(manager.getDefaultRealm(), username);
                name = manager.getRegistry(manager.getDefaultRealm()).checkPassword(username, new String(password));
            }
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".checkRegistry", "%C");
            Tr.error(tc, "security.wssecurity.WSSUserRegistryProcessor.s01", new Object[]{username, e});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{username, e.toString()}));
        }
        boolean bl = ret = name != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRegistry() returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean checkUsername(String username) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUsername(String username[" + username + "])");
        }
        String name = null;
        try {
            username = WSSUserRegistryProcessor.removeRealm(manager.getDefaultRealm(), username);
            name = manager.getRegistry(manager.getDefaultRealm()).getUniqueUserId(username);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".checkUsername", "%C");
            Tr.error(tc, "security.wssecurity.WSSUserRegistryProcessor.s02", new Object[]{username, e});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s02", new String[]{username, e.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkUsername(String username) returns [" + name + "]");
        }
        return true;
    }

    public static String mapCertificate(X509Certificate cert) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate(X509Certificate [" + cert + "])");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(PERM);
        }
        String securityName = null;
        if (manager != null) {
            try {
                securityName = manager.getUserMapping().mapCertificateToName(new X509Certificate[]{cert});
            }
            catch (Exception e) {
                Tr.processException(e, clsName + ".mapCertificate", "%C");
                Tr.warning(tc, "security.wssecurity.WSEC5185W", new Object[]{cert.getSubjectDN().getName(), e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate(X509Certificate) returns " + securityName);
        }
        return securityName;
    }

    public static String removeRealm(String realm, String name) {
        if (realm == null || realm.length() == 0 || name == null || name.length() == 0) {
            return name;
        }
        if (!name.startsWith(realm + "/")) {
            return name;
        }
        int i = realm.length();
        return name.substring(i + 1);
    }
}

