/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.time.TimestampRequest;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.impl.wsu.Timestamp;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSObjectTimestampGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectTimestampGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        Security security;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        if ((security = WSSObjectUtils.getWSSObjectSecurityHeader(context)) == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "wsu:Timestamp");
        }
        if (WSSObjectUtils.getTimestamp(security) != null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s01");
        }
        Timestamp timestamp = new Timestamp(security.getWSSObjectDocument());
        security.addChild(timestamp);
        TimestampGeneratorConfig config2 = (TimestampGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.timestampGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampGeneratorConfig [" + config2 + "].");
        }
        WSSObjectUtils.setCreated(timestamp);
        if (config2.getDuration() != null) {
            WSSObjectUtils.setExpires(timestamp, config2.getDuration());
        }
        boolean isSigned = config2.toBeSigned();
        TimestampRequest trequest = new TimestampRequest(isSigned);
        trequest.setWSSObject(timestamp);
        RequestPool.add(context, trequest);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security header after Timestamp added = " + security);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument, OMElement, Map)");
        }
    }

    public static void moveTimestamp(OMDocument doc, TimestampGeneratorConfig config2, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        Security security;
        Timestamp timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "TimestampGeneratorConfig config," + "Map selectors," + "Map context)");
        }
        if ((timestamp = WSSObjectUtils.getTimestamp(security = WSSObjectUtils.getWSSObjectSecurityHeader(context))) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s13");
        }
        ArrayList<WSSObject> children = security.getChildren();
        int index = children.indexOf(timestamp);
        if (index != 0) {
            children.remove(index);
            security.insertChildBefore(0, timestamp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveTimestamp(OMDocument, TimestampGeneratorConfig, Map, Map)");
        }
    }

    public static ArrayList<OMNode> getTimestamp(OMDocument doc, String dialect, String keyword, String mode, TimestampRequest trequest, RequestMessagePool.EncryptedObject eobject, OMElement element, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String mode[" + mode + "]," + "TimestampRequest trequest[" + trequest + "]," + "EncryptedObject eobject[" + eobject + "]," + "OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "Map selectors," + "Map context)");
        }
        throw new SoapSecurityException("Internal error: getTimestamp() method not supported with WSSObject");
    }
}

