/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.time.TimestampResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(target) + "]," + "Map context)");
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "wsu:Timestamp");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        TimestampConsumerConfig config2 = (TimestampConsumerConfig)context.remove("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampConsumerConfig [" + config2 + "].");
        }
        SoapSecurityException sse = null;
        try {
            NonceUtil.checkTimestamp(target, nsWsu, config2.getTimestampMaxAge(), config2.getTimestampClockSkew(), true);
        }
        catch (SoapSecurityException e) {
            sse = e;
        }
        ResultPool.add(context, new TimestampResult((OMElement)target, sse));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element target, Map context)");
        }
    }
}

