/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.time.TimestampResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(target) + "]," + "Map context)");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        OMDocument doc = null;
        doc = DOMUtil.getOwnerDocument(target);
        TimestampConsumerConfig config2 = (TimestampConsumerConfig)context.remove("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampConsumerConfig [" + config2 + "].");
        }
        Set<RequiredPart> requiredParts = TimestampChecker.preprocess(doc, config2, this._selectors, nsWsu, context);
        Result[] results = ResultPool.get(context, TimestampResult.class);
        if (results != null && results.length > 0) {
            ResultPool.remove(context, results);
            for (int i = 0; i < results.length; ++i) {
                TimestampResult result = (TimestampResult)results[i];
                RequiredPart rpart = TimestampChecker.getRelatedPart(result._element, requiredParts);
                if (rpart == null) continue;
                if (result._ex != null) {
                    throw result._ex;
                }
                rpart._processed = true;
            }
        }
        for (RequiredPart rpart : requiredParts) {
            if (rpart._processed) continue;
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredPart> preprocess(OMDocument doc, TimestampConsumerConfig tconfig, Map<Object, Object> selectors, String nsWsu, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preprocess(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "TimestampConsumerConfig tconfig," + "Set selectors[" + selectors + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)");
        }
        HashSet<RequiredPart> requiredParts = new HashSet<RequiredPart>();
        Map<Object, Object> properties = tconfig.getProperties();
        String value = (String)properties.get(Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
        boolean isSOAPHeaderElement = ConfigUtil.isTrue(value);
        String dialect = (String)properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String keyword = (String)properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (dialect == null) {
            dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
            keyword = isSOAPHeaderElement ? TimestampDialectElementSelector.WASDIALECTS[5] : TimestampDialectElementSelector.WASDIALECTS[4];
        }
        if ((list = TimestampGenerator.getTimestamp(doc, dialect, keyword, "check", null, null, null, selectors, context)) != null && list.size() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                OMElement element = (OMElement)list.get(j);
                String ns = element.getNamespace() == null ? null : element.getNamespace().getName();
                String ln = element.getLocalName();
                if (!nsWsu.equals(ns) || !"Timestamp".equals(ln)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", keyword);
                }
                RequiredPart rpart = new RequiredPart(element);
                requiredParts.add(rpart);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preprocess(OMDocument doc,TimestampConsumerConfig tconfig,Set selectors,String nsWsu,Map context)");
        }
        return requiredParts;
    }

    private static RequiredPart getRelatedPart(OMElement element, Set<RequiredPart> requiredParts) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatedPart(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "Set requiredParts[" + requiredParts + "])");
        }
        RequiredPart rpart = null;
        for (RequiredPart part : requiredParts) {
            if (DOMUtils.equals(part._element, element)) {
                rpart = part;
                break;
            }
            if (rpart == null) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatedPart(Element, Set)");
        }
        return rpart;
    }

    private static class RequiredPart {
        private OMElement _element;
        private boolean _processed;

        RequiredPart(OMElement element) {
            this._element = element;
            this._processed = false;
        }
    }
}

