/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class wssLtpaLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private ContextManager contextManager;
    private LoginModule lm = null;
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.contextManager = ContextManagerFactory.getInstance();
        if (!this.contextManager.isServerSecurityEnabled()) {
            return;
        }
        Callback[] callbacks = new Callback[]{new WSCredTokenCallbackImpl("Credential Token: ")};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] credByte = ((WSCredTokenCallbackImpl)callbacks[0]).getCredToken();
        if (credByte == null || credByte.length == 0) {
            return;
        }
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        String className = "com.ibm.ws.security.server.lm.ltpaLoginModule";
        try {
            this.lm = cl != null ? (LoginModule)cl.loadClass(className).newInstance() : (LoginModule)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.lm.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        if (this.lm != null) {
            this.lm.login();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.lm != null) {
            this.lm.commit();
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.lm != null) {
            this.lm.abort();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.lm != null) {
            this.lm.logout();
        }
        return true;
    }
}

