/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSIdentityCallback;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenPropagationCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(TokenPropagationCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map _context = null;
    private String userName = null;
    private String password = null;
    private String realm = null;
    private byte[] credToken = null;
    private Map _appContext = null;
    private HttpServletRequest _req = null;
    private HttpServletResponse _resp = null;
    private String _identity = null;
    private List _tokenHolderList = null;
    private Object _protocolPolicy = null;
    private X509Certificate[] certChain;

    public TokenPropagationCallbackHandler(Map context, Object policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
        this._context = context;
        this._protocolPolicy = policy;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, Object policy)");
        }
    }

    public TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
        this._context = context;
        this._tokenHolderList = tokenHolderList;
        this.credToken = CredentialsHelper.copyCredToken(credBytes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
    }

    public TokenPropagationCallbackHandler(List tokenHolderList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
        this._tokenHolderList = tokenHolderList;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenPropagationCallbackHandler(Map context, List tokenHolderList, byte[] credBytes)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)c).setCredToken(this.credToken);
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realm);
                continue;
            }
            if (c instanceof WSAppContextCallback) {
                ((WSAppContextCallback)c).setContext(this._appContext);
                continue;
            }
            if (c instanceof WSIdentityCallback) {
                ((WSIdentityCallback)c).setClientIdentity(this._identity);
                continue;
            }
            if (c instanceof WSServletRequestCallback) {
                ((WSServletRequestCallback)c).setHttpServletRequest(this._req);
                continue;
            }
            if (c instanceof WSServletResponseCallback) {
                ((WSServletResponseCallback)c).setHttpServletResponse(this._resp);
                continue;
            }
            if (c instanceof WSTokenHolderCallback) {
                ((WSTokenHolderCallback)c).setTokenHolderList(this._tokenHolderList);
                continue;
            }
            if (c instanceof WSProtocolPolicyCallback) {
                ((WSProtocolPolicyCallback)c).setProtocolPolicy(this._protocolPolicy);
                continue;
            }
            if (c instanceof WSX509CertificateChainCallback) {
                ((WSX509CertificateChainCallback)c).setX509CertificateChain(this.certChain);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Ignoring Callback: " + c);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

