/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.wssecurity.platform.util.KeyStoreUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.KeyStore;
import java.security.Provider;

public class WasKeyStoreUtilImpl
implements KeyStoreUtil {
    private static final TraceComponent tc = Tr.register(WasKeyStoreUtilImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasKeyStoreUtilImpl.class.getName();

    public KeyStore getKeyStore(String keyStoreRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore(String keyStoreRef[" + keyStoreRef + "])");
        }
        KeyStore keystore = null;
        try {
            if (KeyStoreManager.getInstance() != null) {
                WSKeyStore wsk = KeyStoreManager.getInstance().getKeyStore(keyStoreRef);
                if (wsk != null) {
                    keystore = wsk.getKeyStore(false, false);
                } else if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "WSKeyStore is null. Cannot retrieve keystore with keyStoreRef[" + keyStoreRef + "]");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.entry(tc, "KeyStoreManager is null. Cannot retrieve keystore with keyStoreRef[" + keyStoreRef + "]");
            }
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".createKeyStore", "281");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreRef, e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String)");
        }
        return keystore;
    }

    public boolean isValidWSKeyStore(String keyStoreName) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidWSKeyStore(String keyStoreName[" + keyStoreName + "])");
        }
        boolean bl = ret = KeyStoreManager.getInstance().getKeyStore(keyStoreName) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidWSKeyStore(String) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public boolean isHWKeyStore(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHWKeyStore(String keyStoreName[" + keyStoreName + "])");
        }
        boolean ret = KeyStoreManager.getInstance().isHWKeyStore(keyStoreName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHWKeyStore(String) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public Provider getHWCryptoProviderInstance(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String keyStoreName[" + keyStoreName + "])");
        }
        Provider ret = KeyStoreManager.getInstance().getHWCryptoProviderInstance(keyStoreName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHWCryptoProviderInstance(Provider)");
        }
        return ret;
    }

    public void returnHWCryptoProviderInstance(String keyStoreName, Provider hwProviderInstance) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnHWCryptoProviderInstance(String keyStoreName[" + keyStoreName + "], Provider)");
        }
        KeyStoreManager.getInstance().returnHWCryptoProviderInstance(keyStoreName, hwProviderInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance(String,Provider)");
        }
    }
}

