/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.etools.webservice.wscommonbnd.NonceCaching;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wssecurity.core.CertManagerFactory;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.platform.util.ConfigHelper;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasConfigHelperImpl
implements ConfigHelper {
    private static final TraceComponent tc = Tr.register(WasConfigHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasConfigHelperImpl.class.getName();
    private WSSecurityDefaultConfiguration cachedConfig = null;
    private String szHardwareCacheEntryRefresh = null;

    @Override
    public boolean loadConfig(VariableExpander varMap, WSSecurityDefaultConfiguration defaultConfig, Object securityDefaultBindings, DefaultBinding defaultBinding) throws Exception {
        HWKeyCache fHWKeyCache;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig(boolean ndEnvironment, VariableExpander vm, WSSecurityDefaultConfiguration securityDefaultConfig, SecurityBindings securityDefaultBindings, DefaultBinding defaultBinding): ", new Object[]{varMap, defaultConfig, securityDefaultBindings, defaultBinding});
        }
        boolean ret = false;
        SoapSecurityException loadException = null;
        WSSecurity wssec = null;
        long hardwareCacheEntryRefresh = 8L;
        if (this.cachedConfig == null) {
            boolean ndEnvironment = false;
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (processType != null && processType.length() > 0 && (processType.equals("ManagedProcess") || processType.equals("DeploymentManager") || processType.equals("NodeAgent"))) {
                ndEnvironment = true;
            }
            this.cachedConfig = new WSSecurityDefaultConfiguration();
            wssec = this.getWSSecurityObject(ndEnvironment);
            if (wssec != null) {
                NonceCaching nonceCaching;
                EList p;
                boolean isHWAccEnabled = wssec.isUseHardwareAcceleration();
                if (isHWAccEnabled) {
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(isHWAccEnabled)});
                        isHWAccEnabled = false;
                    } else if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
                        Tr.error(tc, "security.wssecurityHardware Crypto is not supported on this platform, continues to use software crypto provider");
                    }
                }
                if (isHWAccEnabled) {
                    this.cachedConfig.setUseHardwareAcceleration(isHWAccEnabled);
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(isHWAccEnabled)});
                    String hwConfigName = wssec.getHardwareConfigRef();
                    if (hwConfigName != null && hwConfigName.length() != 0) {
                        this.cachedConfig.setHardwareConfigName(hwConfigName);
                        Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{hwConfigName});
                    }
                }
                if ((p = wssec.getProperties()) != null) {
                    String preV70InteropMode;
                    String clockSkew;
                    String maxAge;
                    String offloadRSAPubKeyCrypto;
                    String cryptoOffload;
                    String v;
                    String useCache;
                    Map<?, ?> map;
                    block81: {
                        int i;
                        map = WasConfigHelperImpl.getProperties(p, varMap);
                        useCache = (String)map.get("com.ibm.ws.wssecurity.handler.useConfigCache");
                        if (useCache != null) {
                            this.cachedConfig.setUseConfigCache(ConfigUtil.isTrue(useCache));
                        } else {
                            this.cachedConfig.setUseConfigCache(true);
                        }
                        v = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout");
                        if (v != null && (v = v.trim()).length() != 0) {
                            try {
                                i = Integer.parseInt(v);
                                this.cachedConfig.setNonceCacheTimeout(ConfigConstants.validNonceCacheTimeout(i));
                            }
                            catch (NumberFormatException e) {
                                this.cachedConfig.setNonceCacheTimeout(600);
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                                Tr.warning(tc, "security.wssecurity.WSEC0115W", new Object[]{v, new Integer(600)});
                            }
                        }
                        if ((v = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout")) != null && (v = v.trim()).length() != 0) {
                            try {
                                i = Integer.parseInt(v);
                                this.cachedConfig.setCertCacheTimeOut(ConfigConstants.validCertCacheTimeout(i));
                            }
                            catch (NumberFormatException e) {
                                this.cachedConfig.setCertCacheTimeOut(900);
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (!tc.isDebugEnabled()) break block81;
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache timeout " + v + "seconds, default " + 900 + " seconds is used instead.");
                            }
                        }
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheTimeToLive")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i = Integer.parseInt(v);
                                this.cachedConfig.setConfigCacheTimeToLive(i);
                            }
                            catch (NumberFormatException e) {
                                this.cachedConfig.setConfigCacheTimeToLive(900);
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache timeToLive " + v + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        this.cachedConfig.setConfigCacheTimeToLive(900);
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheTimeout")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i = Integer.parseInt(v);
                                this.cachedConfig.setTokenCacheTimeOut(ConfigConstants.validTokenCacheTimeout(i));
                            }
                            catch (NumberFormatException e) {
                                this.cachedConfig.setTokenCacheTimeOut(900);
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache timeout " + v + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        this.cachedConfig.setTokenCacheTimeOut(900);
                    }
                    if ((v = (String)map.get("com.ibm.ws.wssecurity.handler.token.cushion")) != null) {
                        if ((v = v.trim()).length() != 0) {
                            try {
                                int i = Integer.parseInt(v);
                                this.cachedConfig.setTokenCacheCushion(ConfigConstants.validTokenCushion(i * 1000));
                            }
                            catch (NumberFormatException e) {
                                this.cachedConfig.setTokenCacheCushion(600000L);
                                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cushion " + v + "seconds, default " + 600 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        this.cachedConfig.setTokenCacheCushion(600000L);
                    }
                    if ((cryptoOffload = (String)map.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography")) != null) {
                        this.cachedConfig.setUseOffloadAllCrypto(cryptoOffload);
                    }
                    if ((offloadRSAPubKeyCrypto = (String)map.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography")) != null) {
                        this.cachedConfig.setOffloadRSAPublicKeyCrypto(ConfigUtil.isTrue(offloadRSAPubKeyCrypto));
                    } else {
                        this.cachedConfig.setOffloadRSAPublicKeyCrypto(true);
                    }
                    String hardwareCacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                    if (hardwareCacheSize != null) {
                        this.cachedConfig.setHardwareCacheSize(ConfigConstants.processHardwareCacheSize(hardwareCacheSize));
                    } else {
                        this.cachedConfig.setHardwareCacheSize(1000);
                    }
                    this.szHardwareCacheEntryRefresh = (String)map.get("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
                    useCache = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.useCache");
                    if (useCache != null) {
                        this.cachedConfig.setUseCertCache(ConfigUtil.isTrue(useCache));
                    }
                    if ((useCache = (String)map.get("com.ibm.ws.wssecurity.handler.useConfigCache")) != null) {
                        this.cachedConfig.setUseConfigCache(ConfigUtil.isTrue(useCache));
                    } else {
                        this.cachedConfig.setUseConfigCache(true);
                    }
                    useCache = (String)map.get("com.ibm.ws.wssecurity.handler.token.useCache");
                    if (useCache != null) {
                        this.cachedConfig.setUseTokenCache(ConfigUtil.isTrue(useCache));
                    } else {
                        this.cachedConfig.setUseTokenCache(true);
                    }
                    String cacheName = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
                    if (cacheName != null) {
                        this.cachedConfig.setNonceCacheName(cacheName);
                    }
                    if ((cacheName = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheName")) != null) {
                        this.cachedConfig.setCertCacheName(cacheName);
                    }
                    if ((cacheName = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheName")) != null) {
                        this.cachedConfig.setConfigCacheName(cacheName);
                    } else {
                        this.cachedConfig.setConfigCacheName("WSSReqGeneratorConfigMap");
                    }
                    cacheName = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheName");
                    if (cacheName != null) {
                        this.cachedConfig.setTokenCacheName(cacheName);
                    } else {
                        this.cachedConfig.setTokenCacheName("WSSTokenCache");
                    }
                    String cacheSize = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
                    if (cacheSize != null) {
                        this.cachedConfig.setNonceCacheSize(ConfigConstants.processNonceCacheSize(cacheSize));
                    }
                    if ((cacheSize = (String)map.get("com.ibm.ws.wssecurity.config.token.certificate.cacheSize")) != null) {
                        this.cachedConfig.setCertCacheSize(ConfigConstants.processCertCacheSize(cacheSize));
                    }
                    if ((cacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.configCacheSize")) != null) {
                        try {
                            int i = Integer.parseInt(cacheSize);
                            this.cachedConfig.setConfigCacheSize(i);
                        }
                        catch (NumberFormatException e) {
                            this.cachedConfig.setConfigCacheSize(128);
                            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".loadConfig", "%C", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache size " + cacheSize + "default size" + 128 + " is used instead.");
                            }
                        }
                    } else {
                        this.cachedConfig.setConfigCacheSize(128);
                    }
                    cacheSize = (String)map.get("com.ibm.ws.wssecurity.handler.token.cacheSize");
                    if (cacheSize != null) {
                        this.cachedConfig.setTokenCacheSize(ConfigConstants.processTokenCacheSize(cacheSize));
                    }
                    if ((maxAge = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge")) != null) {
                        this.cachedConfig.setNonceMaxAge(ConfigConstants.processNonceMaxAge(maxAge, this.cachedConfig.getNonceCacheTimeout()));
                    }
                    if ((clockSkew = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                        this.cachedConfig.setNonceClockSkew(ConfigConstants.processNonceClockSkew(clockSkew, this.cachedConfig.getNonceMaxAge()));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce cache timeout = " + this.cachedConfig.getNonceCacheTimeout() + ", Nonce max age = " + this.cachedConfig.getNonceMaxAge() + ", Nonce clock skew = " + this.cachedConfig.getNonceClockSkew());
                    }
                    if ((preV70InteropMode = (String)map.get("com.ibm.ws.wssecurity.distributedcache.PreV70InteropMode")) != null) {
                        CacheableTokenCacheFactory.getInstance().setPreV70InteropMode(ConfigUtil.isTrue(preV70InteropMode));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Distributed Cache preV70InteropMode = " + preV70InteropMode + "[" + (ConfigUtil.isTrue(preV70InteropMode) ? "true" : "false") + "]");
                    }
                }
                if ((nonceCaching = wssec.getNonceCaching()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No NonceCaching found.");
                    }
                } else {
                    this.cachedConfig.setNonceCacheDistributed(nonceCaching.isDistributed());
                }
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s04");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s04");
            }
        }
        ret = true;
        if (this.szHardwareCacheEntryRefresh != null) {
            hardwareCacheEntryRefresh = ConfigConstants.processHardwareCacheEntryRefresh(this.szHardwareCacheEntryRefresh);
        }
        if ((fHWKeyCache = HWKeyCache.getInstance()) != null) {
            fHWKeyCache.setScanParameters(hardwareCacheEntryRefresh);
        }
        defaultConfig.setUseHardwareAcceleration(this.cachedConfig.getUseHardwareAcceleration());
        defaultConfig.setHardwareConfigName(this.cachedConfig.getHardwareConfigName());
        defaultConfig.setUseConfigCache(this.cachedConfig.getUseConfigCache());
        defaultConfig.setNonceCacheTimeout(this.cachedConfig.getNonceCacheTimeout());
        defaultConfig.setCertCacheTimeOut(this.cachedConfig.getCertCacheTimeOut());
        defaultConfig.setConfigCacheTimeToLive(this.cachedConfig.getConfigCacheTimeToLive());
        defaultConfig.setTokenCacheTimeOut(this.cachedConfig.getTokenCacheTimeOut());
        defaultConfig.setTokenCacheCushion(this.cachedConfig.getTokenCacheCushion());
        defaultConfig.setUseOffloadAllCrypto(this.cachedConfig.getUseOffloadAllCrypto());
        defaultConfig.setOffloadRSAPublicKeyCrypto(this.cachedConfig.getOffloadRSAPublicKeyCrypto());
        defaultConfig.setHardwareCacheSize(this.cachedConfig.getHardwareCacheSize());
        defaultConfig.setUseCertCache(this.cachedConfig.getUseCertCache());
        defaultConfig.setUseConfigCache(this.cachedConfig.getUseConfigCache());
        defaultConfig.setUseTokenCache(this.cachedConfig.getUseTokenCache());
        defaultConfig.setNonceCacheName(this.cachedConfig.getNonceCacheName());
        defaultConfig.setCertCacheName(this.cachedConfig.getCertCacheName());
        defaultConfig.setConfigCacheName(this.cachedConfig.getConfigCacheName());
        defaultConfig.setTokenCacheName(this.cachedConfig.getTokenCacheName());
        defaultConfig.setNonceCacheSize(this.cachedConfig.getNonceCacheSize());
        defaultConfig.setCertCacheSize(this.cachedConfig.getCertCacheSize());
        defaultConfig.setConfigCacheSize(this.cachedConfig.getConfigCacheSize());
        defaultConfig.setTokenCacheSize(this.cachedConfig.getTokenCacheSize());
        defaultConfig.setNonceMaxAge(this.cachedConfig.getNonceMaxAge());
        defaultConfig.setNonceClockSkew(this.cachedConfig.getNonceClockSkew());
        defaultConfig.setNonceCacheDistributed(this.cachedConfig.getNonceCacheDistributed());
        if (!NonceManagerFactory.isInitialized()) {
            NonceManagerFactory.init(defaultConfig.getUseNonceCache(), defaultConfig.getNonceCacheName(), defaultConfig.getNonceCacheSize(), defaultConfig.getNonceCacheTimeout(), defaultConfig.getNonceLength(), defaultConfig.getNonceCacheDistributed());
        }
        if (!CertManagerFactory.isInitialized()) {
            CertManagerFactory.init(defaultConfig.getUseCertCache(), defaultConfig.getCertCacheName(), defaultConfig.getCertCacheSize(), defaultConfig.getCertCacheTimeOut());
        }
        if (securityDefaultBindings == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No default bindings found.");
            }
        } else {
            try {
                WSSBindings wssDefaultBindings = new WSSBindings(securityDefaultBindings);
                defaultConfig.setDefaultConsumerBinding(new WSSecurityDefaultConsumerConfig(wssDefaultBindings));
                defaultConfig.setDefaultGeneratorBinding(new WSSecurityDefaultGeneratorConfig(wssDefaultBindings));
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WasConfigHelperImpl.s01", e.toString());
                Tr.processException((Throwable)e, clsName + ".loadConfig", "%C", this);
                loadException = SoapSecurityException.format("security.wssecurity.WasConfigHelperImpl.s01", e.toString());
            }
            if (loadException != null) {
                defaultConfig.setDefaultBindingsLoadingException(loadException);
            }
            defaultBinding.setDefaultBinding(Constants.WS_SECURITY_DEFAULT_BINDING_KEY, defaultConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig returns boolean[" + ret + "]", new Object[]{wssec, defaultConfig});
        }
        return ret;
    }

    private WSSecurity getWSSecurityObject(boolean ndEnvironment) {
        WSSecurity wssec;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWSSecurityObject(boolean ndEnvironment [" + ndEnvironment + "])");
            }
            wssec = null;
            Repository repository = null;
            ConfigRoot cfgRoot = null;
            try {
                Resource r2;
                block14: {
                    String path;
                    repository = WsServiceRegistry.getService(this, Repository.class);
                    cfgRoot = repository.getConfigRoot();
                    if (ndEnvironment) {
                        Resource r1 = null;
                        try {
                            r1 = cfgRoot.getResource(0, "ws-security.xml");
                        }
                        catch (Exception e) {
                            path = cfgRoot.getAbsolutePath(0, "ws-security.xml");
                            Tr.processException((Throwable)e, clsName + ".getWSSecurityObject", "%C", this);
                            Tr.warning(tc, "ws.wssecurity.load.cell.wssecurity.xml", new Object[]{path});
                        }
                        if (r1 != null) {
                            wssec = (WSSecurity)r1.getContents().get(0);
                        }
                    }
                    r2 = null;
                    try {
                        r2 = cfgRoot.getResource(4, "ws-security.xml");
                    }
                    catch (Exception e) {
                        if (ndEnvironment) break block14;
                        path = cfgRoot.getAbsolutePath(4, "ws-security.xml");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Can not load server level configuration file: " + path, new Object[]{e});
                        }
                        Tr.warning(tc, "ws.wssecurity.load.server.wssecurity.xml", new Object[]{path});
                    }
                }
                if (r2 != null) {
                    wssec = (WSSecurity)r2.getContents().get(0);
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".getWSSecurityObject", "%C", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in getWSSecurityObject().  Error while loading ws-security.xml.");
                }
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".getWSSecurityObject", "%C", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception caught in getWSSecurityObject().  Error while loading ws-security.xml.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSecurityObject");
        }
        return wssec;
    }

    public static Map<?, ?> getProperties(EList props, VariableExpander varMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(EList, VariableExpander):", new Object[]{props, varMap});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (props != null && !props.isEmpty()) {
            int size = props.size();
            for (int j = 0; j < size; ++j) {
                String value;
                EObject p;
                Object object = props.get(j);
                if (object instanceof Property) {
                    p = (Property)object;
                    value = varMap == null ? p.getValue() : varMap.expand(p.getValue());
                    map.put(p.getName(), value);
                    continue;
                }
                p = (com.ibm.etools.webservice.wscommonext.Property)object;
                value = varMap == null ? p.getValue() : varMap.expand(p.getValue());
                map.put(p.getName(), value);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(EList, VariableExpander)");
        }
        return map;
    }

    @Override
    public boolean isWebInboundPropagationEnabled() {
        return WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled();
    }
}

