/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelper;
import com.ibm.ws.wssecurity.platform.websphere.util.WSSOpaqueTokenHelper;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.axis2.util.ObjectStateUtils;

public class WSSSubjectHelperImpl
implements WSSSubjectHelper,
Externalizable {
    private static final long serialVersionUID = -7832034184844111080L;
    private static final int VERSION = 1;
    private static final TraceComponent tc = Tr.register(WSSSubjectHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final ContextManager mgr = ContextManagerFactory.getInstance();
    private static final WSOpaqueTokenHelper wsOpaHelper = WSOpaqueTokenHelper.getInstance();
    private static final WSSOpaqueTokenHelper wssOpaHelper = WSSOpaqueTokenHelper.getInstance();
    private static final boolean isServerSecurityEnabled = WSSSubjectHelperImpl.isServerSecurityEnabled();
    public static final String DESERIALIZE_ASYNCH_CONTEXT = "system.DESERIALIZE_ASYNCH_CONTEXT";
    private int version = 1;
    private byte[] opaqueToken;
    private byte[] loginToken;
    private Subject subject = null;

    public void setSubject(Subject sub) {
        this.subject = sub;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public byte[] serializeSubject(Subject sub) {
        this.subject = sub;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outObjStream = new ObjectOutputStream(byteStream);
            this.writeExternal(outObjStream);
            outObjStream.close();
            byteStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to serialize Token. ", e.getStackTrace());
            }
            return null;
        }
    }

    public Subject deserializeSubject(byte[] bt) {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bt);
            ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
            this.readExternal(inObjStream);
            inObjStream.close();
            byteStream.close();
            this.subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    return WSSSubjectHelperImpl.this.doLogin();
                }
            });
            return this.subject;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to de-serialize Token. ", e.getStackTrace());
            }
            return null;
        }
    }

    public Subject doLogin() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doLogin", new Object[]{"Login token=" + this.loginToken, "Subject token=" + this.opaqueToken});
        }
        Subject result = null;
        try {
            ArrayList tokenList = null;
            tokenList = isServerSecurityEnabled ? wsOpaHelper.createTokenHolderListFromOpaqueToken(this.opaqueToken) : wssOpaHelper.createTokenHolderListFromOpaqueToken(this.opaqueToken);
            String jaasConfig = "system.wss.inbound.deserialize";
            TokenPropagationCallbackHandler cbh = new TokenPropagationCallbackHandler(null, tokenList, this.loginToken);
            LoginContext lc = new LoginContext(jaasConfig, cbh);
            lc.login();
            result = lc.getSubject();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "doLogin", "493", this);
            LoginException ex = new LoginException("Failed to deserialize Context.");
            ex.initCause(e);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doLogin");
        }
        return result;
    }

    private byte[] createSubjectToken(Subject subj) throws WSLoginFailedException, WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubjectToken", "Subject is null? " + (subj == null));
        }
        byte[] result = null;
        if (subj != null) {
            result = isServerSecurityEnabled ? wsOpaHelper.createOpaqueTokenFromSubject(subj) : wssOpaHelper.createOpaqueTokenFromSubject(subj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectToken", "Token created is null? " + (result == null));
        }
        return result;
    }

    private ArrayList createAndCacheTokenHolderList(byte[] subj) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAndCacheTokenHolderList", subj);
        }
        ArrayList tokenList = wsOpaHelper.createTokenHolderListFromOpaqueToken(subj);
        String cacheKey = wsOpaHelper.getOpaqueTokenLookup();
        mgr.put(cacheKey, tokenList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAndCacheTokenHolderList", "tokenList=" + tokenList);
        }
        return tokenList;
    }

    private void removeTokenHolderListFromCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTokenHolderListFromCache");
        }
        String cacheKey = wsOpaHelper.getOpaqueTokenLookup();
        mgr.put(cacheKey, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTokenHolderListFromCache");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "writeObject", out);
            }
            try {
                this.loginToken = null;
                this.opaqueToken = null;
                if (this.subject != null) {
                    WSCredential cred;
                    this.opaqueToken = this.createSubjectToken(this.subject);
                    if (isServerSecurityEnabled && (cred = SubjectHelper.getWSCredentialFromSubject(this.subject)) != null) {
                        WSCredentialTokenMapperInterface mapper = mgr.getWSCredTokenMapper();
                        AuthenticationToken token = mapper.createAuthTokenFromWSCredential(cred);
                        this.loginToken = token != null ? token.getBytes() : null;
                    }
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "writeObject", "592", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writeObject", e);
                }
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "writeObject", "597", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "writeObject", e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeObject", "Serializing Context version: " + this.version + ", serialVersionUID=" + -7832034184844111080L);
        }
        out.writeInt(this.version);
        ObjectStateUtils.writeObject(out, this.opaqueToken, "opaqueToken");
        ObjectStateUtils.writeObject(out, this.loginToken, "loginToken");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", in);
        }
        this.version = in.readInt();
        switch (this.version) {
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "readObject", "Deserializing Context version: " + this.version + ", serialVersionUID=" + -7832034184844111080L);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported Context version: " + this.version);
            }
        }
        Object tmp = null;
        tmp = ObjectStateUtils.readObject(in, "opaqueToken");
        if (tmp != null) {
            this.opaqueToken = (byte[])tmp;
        }
        if ((tmp = ObjectStateUtils.readObject(in, "loginToken")) != null) {
            this.loginToken = (byte[])tmp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    private static final boolean isServerSecurityEnabled() {
        try {
            return mgr.isServerSecurityEnabled();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServerSecurityEnabled ", e.getMessage());
            }
            return false;
        }
    }
}

