/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedData;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelper;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelperFactory;
import com.ibm.ws.wssecurity.platform.websphere.util.WSSOpaqueTokenHelper;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSSelfManagedDataImpl
implements WSSSelfManagedData {
    private static final TraceComponent tc = Tr.register(WSSSelfManagedDataImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static WSSOpaqueTokenHelper opaqueTokenHelper = WSSOpaqueTokenHelper.getInstance();
    public static final String WSSSubject = Constants.WSSECURITY_TOKEN_WSSSUBJECT;

    public synchronized byte[] getSerializedSelfManagedData(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<TokenHolder> tokenHolderList = new ArrayList<TokenHolder>();
        Object obj = map.get(WSSSubject);
        if (obj != null && obj instanceof Subject) {
            byte[] subjectByte = null;
            Subject sub = (Subject)obj;
            WSSSubjectHelper subHelper = WSSSubjectHelperFactory.getInstance();
            subjectByte = subHelper.serializeSubject(sub);
            TokenHolder tokenholder = new TokenHolder(subjectByte, WSSSubject, 1);
            tokenHolderList.add(tokenholder);
        }
        return opaqueTokenHelper.createOpaqueTokenFromTokenHolderList(null, tokenHolderList);
    }

    public synchronized Map getDeserializedSelfManagedData(byte[] subjByte) {
        HashMap<String, Subject> map = new HashMap<String, Subject>();
        ArrayList tokenHolderList = new ArrayList();
        try {
            tokenHolderList = opaqueTokenHelper.createTokenHolderListFromOpaqueToken(subjByte);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDeserializedSelfManagedData(byte[] subjByte) fails with " + e.getMessage());
            }
            return null;
        }
        ListIterator it = tokenHolderList.listIterator();
        while (it.hasNext()) {
            TokenHolder tbh = (TokenHolder)it.next();
            if (!tbh.getName().equals(WSSSubject)) continue;
            try {
                WSSSubjectHelper subHelper = WSSSubjectHelperFactory.getInstance();
                Subject subj = subHelper.deserializeSubject(tbh.getBytes());
                map.put(WSSSubject, subj);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Fail to deserialize Token. ", e.getStackTrace());
            }
        }
        return map;
    }

    public boolean serializeWSSProperty(MessageContext _mc) throws IOException {
        if (!PlatformContextUtil.isWebSphereServerProcess()) {
            return false;
        }
        Subject subj = (Subject)_mc.getProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (subj == null) {
            return false;
        }
        try {
            HashMap<String, Subject> map = new HashMap<String, Subject>();
            map.put(WSSSubject, subj);
            WSSSelfManagedDataImpl wsSelf = new WSSSelfManagedDataImpl();
            byte[] byteData = wsSelf.getSerializedSelfManagedData(map);
            _mc.setProperty(WSSSubject, byteData);
            return true;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to serialize WSSSubject. ", e);
            }
            return false;
        }
    }

    public boolean deserializeWSSProperty(MessageContext _mc) {
        if (!PlatformContextUtil.isWebSphereServerProcess()) {
            return true;
        }
        byte[] dataByte = null;
        Object obj = _mc.getProperty(WSSSubject);
        if (obj == null) {
            return false;
        }
        WSSSelfManagedDataImpl wsSelf = new WSSSelfManagedDataImpl();
        dataByte = (byte[])obj;
        Map map = wsSelf.getDeserializedSelfManagedData(dataByte);
        if ((obj = map.get(WSSSubject)) != null && obj instanceof Subject) {
            _mc.setProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT, (Subject)obj);
        }
        return true;
    }
}

