/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.wssecurity.platform.util.PlatformContext;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformContextImpl
implements PlatformContext {
    private static final TraceComponent tc = Tr.register(PlatformContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean isWebSphereServerProcess = false;
    private static boolean isWebSphereThinClient = false;
    private static boolean initialized = false;

    private static boolean initialize() {
        initialized = false;
        AdminService adminService = null;
        try {
            adminService = (AdminService)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AdminServiceFactory.getAdminService();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (adminService != null) {
            isWebSphereServerProcess = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebSphereServerProcess = " + isWebSphereServerProcess);
            }
        } else {
            isWebSphereThinClient = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebSphereThinClient:" + isWebSphereThinClient);
            }
        }
        initialized = true;
        return true;
    }

    public boolean isServerProcess() {
        if (!initialized) {
            PlatformContextImpl.initialize();
        }
        return isWebSphereServerProcess;
    }

    public boolean isClientProcess() {
        if (!initialized) {
            PlatformContextImpl.initialize();
        }
        return isWebSphereThinClient;
    }
}

