/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.trust.server.sts;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSConfigurationMapLoader;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class STSConfigurationMapLoaderImpl
implements STSConfigurationMapLoader {
    private static final TraceComponent tc = Tr.register(STSConfigurationMapLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public STSConfigGroup loadSTSConfigurationMap() {
        String method = "loadSTSConfigurationMap";
        STSConfigurationMapLoaderImpl.trEntry(method);
        STSConfigGroup stsConfigMap = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        String fileName = "stsconfig.xml";
        String packageName = "com.ibm.xmlns.prod.websphere._200608.securitytokenservice";
        STSConfigurationMapLoaderImpl.trDebug("fileNameConfig: " + fileName);
        STSConfigurationMapLoaderImpl.trDebug("packageNameConfig: " + packageName);
        String userInstallRoot = System.getProperty("user.install.root");
        String wasCellName = adminService.getCellName();
        String absolutePath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + "sts" + File.separator + fileName;
        STSConfigurationMapLoaderImpl.trDebug("absolutePathConfig: " + absolutePath);
        try {
            JAXBContext jcPlugins = JAXBContext.newInstance((String)packageName);
            Unmarshaller umPlugins = jcPlugins.createUnmarshaller();
            stsConfigMap = (STSConfigGroup)umPlugins.unmarshal(new File(absolutePath));
        }
        catch (JAXBException e) {
            FFDCFilter.processException(e, STSConfigurationMapLoaderImpl.class.getName(), "78");
            STSConfigurationMapLoaderImpl.trDebug("Error occurred while loading plugin configuration: " + e.getLocalizedMessage());
        }
        STSConfigurationMapLoaderImpl.trExit(method);
        return stsConfigMap;
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }

    private static void trDebug(String msg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, msg);
        }
    }
}

