/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.registry;

import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.platform.registry.Result;
import com.ibm.ws.wssecurity.platform.registry.UserRegistry;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.security.auth.Subject;

public class WasUserRegistry
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(WasUserRegistry.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void initialize(Properties props) throws SoapSecurityException {
    }

    public String checkPassword(String userSecurityName, String password) throws SoapSecurityException {
        if (tc.isDebugEnabled()) {
            String pwd = password == null ? "null" : "not null";
            Tr.debug(tc, "Username [" + userSecurityName + "], password [" + pwd + "]");
        }
        try {
            Subject subject;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticating using ContextManager login()");
            }
            if ((subject = ContextManagerFactory.getInstance().login(ContextManagerFactory.getInstance().getDefaultRealm(), userSecurityName, password)) != null) {
                return userSecurityName;
            }
            return null;
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String mapCertificate(X509Certificate[] cert) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).mapCertificate(cert);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String getRealm() {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getRealm();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Result getUsers(String pattern, int limit) throws SoapSecurityException {
        return null;
    }

    public String getUserDisplayName(String userSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getUserDisplayName(userSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String getUniqueUserId(String userSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getUniqueUserId(userSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String getUserSecurityName(String uniqueUserId) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getUserSecurityName(uniqueUserId);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public boolean isValidUser(String userSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).isValidUser(userSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public Result getGroups(String pattern, int limit) throws SoapSecurityException {
        return null;
    }

    public String getGroupDisplayName(String groupSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getGroupDisplayName(groupSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String getUniqueGroupId(String groupSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getUniqueGroupId(groupSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public List getUniqueGroupIds(String uniqueUserId) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getUniqueGroupIds(uniqueUserId);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String getGroupSecurityName(String uniqueGroupId) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getGroupSecurityName(uniqueGroupId);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public boolean isValidGroup(String groupSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).isValidGroup(groupSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public List getGroupsForUser(String userSecurityName) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getRegistry(ContextManagerFactory.getInstance().getDefaultRealm()).getGroupsForUser(userSecurityName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public Result getUsersForGroup(String groupSecurityName, int limit) throws SoapSecurityException {
        return null;
    }
}

