/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSRealm;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.registry.RegistryHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSRealmImpl
implements WSSRealm {
    private static final TraceComponent tc = Tr.register(WSSRealmImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    public boolean isUserFromTrustedRealm(String qualifiedIdentity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserFromTrustedRealm: " + qualifiedIdentity);
        }
        boolean trusted = false;
        if (qualifiedIdentity != null) {
            int last_index;
            int index = qualifiedIdentity.indexOf(":realm:");
            if (index != (last_index = qualifiedIdentity.lastIndexOf(":realm:"))) {
                Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
            } else if (index > 0 && index < qualifiedIdentity.length() - ":realm:".length()) {
                String uniqueId = qualifiedIdentity.substring(index + ":realm:".length());
                String realm = WSSecurityPropagationHelper.getRealmFromUniqueID((String)uniqueId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "asserted uniqueId = " + uniqueId + " realm = " + realm);
                }
                trusted = RegistryHelper.isRealmInboundTrusted((String)realm, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trusted = " + trusted);
        }
        return trusted;
    }

    public String getRealmQualifiedIdentity(final Subject subject, final boolean sendRealm, final boolean trustedRealm) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmQualifiedIdentity");
        }
        String qualifiedIdentity = null;
        try {
            if (subject != null) {
                qualifiedIdentity = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return WSSRealmImpl.this.getRealmQualifiedIdentityHelper(subject, sendRealm, trustedRealm);
                        }
                        catch (Exception e) {
                            throw new SecurityException(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
        if (qualifiedIdentity != null && trustedRealm && !this.isIdentityRealmQualified(qualifiedIdentity)) {
            Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
            qualifiedIdentity = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmQualifiedIdentity: " + qualifiedIdentity);
        }
        if (qualifiedIdentity == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSRealmImpl.s01");
        }
        return qualifiedIdentity;
    }

    public String getRealmQualifiedIdentity(String username, final String password, final boolean sendRealm, final boolean trustedRealm) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmQualifiedIdentity " + username);
        }
        String qualifiedIdentity = null;
        try {
            if (username != null) {
                final String tmp_username = RealmSecurityName.getSecurityName(username);
                qualifiedIdentity = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
                            Subject subject = null;
                            subject = password == null ? ctxMgr.login(ctxMgr.getDefaultRealm(), tmp_username) : ctxMgr.login(ctxMgr.getDefaultRealm(), tmp_username, password);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "subject = " + subject.toString());
                            }
                            return WSSRealmImpl.this.getRealmQualifiedIdentityHelper(subject, sendRealm, trustedRealm);
                        }
                        catch (Exception e) {
                            throw new SecurityException(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
        if (qualifiedIdentity != null && trustedRealm && !this.isIdentityRealmQualified(qualifiedIdentity)) {
            Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
            qualifiedIdentity = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmQualifiedIdentity: " + qualifiedIdentity);
        }
        if (qualifiedIdentity == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSRealmImpl.s01");
        }
        return qualifiedIdentity;
    }

    public String getRealmQualifiedRunAsIdentity(final MessageContext messageContext, final boolean sendRealm, final boolean trustedRealm) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmQualifiedRusAsIdentity");
        }
        String qualifiedIdentity = null;
        try {
            qualifiedIdentity = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        WSSContext secContext = WSSContextFactory.getInstance();
                        Subject subject = secContext.getRunAsSubject(messageContext);
                        if (subject != null) {
                            return WSSRealmImpl.this.getRealmQualifiedIdentityHelper(subject, sendRealm, trustedRealm);
                        }
                        return null;
                    }
                    catch (SoapSecurityException e) {
                        throw new SecurityException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
        if (qualifiedIdentity != null && trustedRealm && !this.isIdentityRealmQualified(qualifiedIdentity)) {
            Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
            qualifiedIdentity = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmQualifiedRunAsIdentity: " + qualifiedIdentity);
        }
        if (qualifiedIdentity == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSRealmImpl.s01");
        }
        return qualifiedIdentity;
    }

    public String getIdentity(String qualifiedIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdentity: " + qualifiedIdentity);
        }
        String identity = null;
        if (qualifiedIdentity != null) {
            int last_index;
            int index = qualifiedIdentity.indexOf(":realm:");
            if (index != (last_index = qualifiedIdentity.lastIndexOf(":realm:"))) {
                Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
            } else {
                identity = index < 0 || index >= qualifiedIdentity.length() - MINIMUM_QUALIFIED_IDENTITY_LENGTH ? qualifiedIdentity : qualifiedIdentity.substring(0, index);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentity: " + identity);
        }
        return identity;
    }

    public int getNumberOfDelimiters(String qualifiedIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfDelimiters: " + qualifiedIdentity);
        }
        int numberDelimiters = 0;
        if (qualifiedIdentity != null) {
            int index = 0;
            while (index >= 0 && index <= qualifiedIdentity.length() - ":realm:".length()) {
                if ((index = qualifiedIdentity.indexOf(":realm:", index)) <= 0 || index > qualifiedIdentity.length() - ":realm:".length()) continue;
                ++numberDelimiters;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfDelimiters: " + numberDelimiters);
        }
        return numberDelimiters;
    }

    public boolean isIdentityRealmQualified(String qualifiedIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isIdentityRealmQualified: " + qualifiedIdentity);
        }
        boolean realmQualified = false;
        if (qualifiedIdentity != null && qualifiedIdentity.length() >= MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
            int index = qualifiedIdentity.indexOf(":realm:");
            int last_index = qualifiedIdentity.lastIndexOf(":realm:");
            if (index >= 0 && index == last_index && index < qualifiedIdentity.length() - MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
                realmQualified = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isIdentityRealmQualified: " + realmQualified);
        }
        return realmQualified;
    }

    public boolean isIdentityLocal(String qualifiedIdentity) {
        boolean local;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isIdentityLocal: " + qualifiedIdentity);
        }
        boolean bl = local = !this.isIdentityRealmQualified(qualifiedIdentity);
        if (!local) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isIdentityRealmQualified, inspect realm ...");
            }
            if (qualifiedIdentity != null && qualifiedIdentity.length() >= MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
                int index = qualifiedIdentity.indexOf(":realm:");
                int last_index = qualifiedIdentity.lastIndexOf(":realm:");
                if (index > 0 && index != last_index) {
                    Tr.error(tc, "security.wssecurity.WSSRealmImpl.s02", new Object[]{qualifiedIdentity, ":realm:"});
                } else if (index < qualifiedIdentity.length() - MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
                    String uniqueId = qualifiedIdentity.substring(index + ":realm:".length());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "uniqueId = " + uniqueId);
                    }
                    String realm = RealmSecurityName.getRealm(uniqueId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "realm = " + realm);
                    }
                    if (realm != null && realm.equalsIgnoreCase(WSSContextManagerFactory.getInstance().getDefaultRealm())) {
                        local = true;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isIdentityLocal: " + local);
        }
        return local;
    }

    public void addIdentityAssertionProperties(String qualifiedIdentity, Map customProperties) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addIdentityAssertionProperties: " + qualifiedIdentity);
        }
        if (customProperties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties cannot be null");
            }
            return;
        }
        if (qualifiedIdentity != null && qualifiedIdentity.length() >= MINIMUM_QUALIFIED_IDENTITY_LENGTH && (index = qualifiedIdentity.indexOf(":realm:")) >= 0 && index < qualifiedIdentity.length() - MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
            String username = qualifiedIdentity.substring(0, index);
            String uniqueId = qualifiedIdentity.substring(index + ":realm:".length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "username = " + username + "  uniqueId = " + uniqueId);
            }
            customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueId);
            customProperties.put("com.ibm.wsspi.security.cred.securityName", username);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addIdentityAssertionProperties: " + customProperties.toString());
        }
    }

    private String getRealmQualifiedIdentityHelper(Subject subject, boolean sendRealm, boolean trustedRealm) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmQualifiedIdentityHelper: subject " + (subject == null ? "null" : "not null"));
        }
        String qualifiedIdentity = null;
        String uniqueId = null;
        if (subject != null) {
            try {
                Set<Principal> principals;
                Set<Object> creds;
                if (trustedRealm && (creds = subject.getPublicCredentials()) != null) {
                    for (Object cred : creds) {
                        if (!(cred instanceof WSCredential)) continue;
                        uniqueId = ((WSCredential)cred).getRealmUniqueSecurityName();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "uniqueId = " + uniqueId);
                        break;
                    }
                }
                if ((principals = subject.getPrincipals()) != null) {
                    for (Principal principal : principals) {
                        if (!(principal instanceof WSPrincipal)) continue;
                        if (sendRealm || trustedRealm) {
                            qualifiedIdentity = ((WSPrincipal)principal).getName();
                            break;
                        }
                        qualifiedIdentity = RealmSecurityName.getSecurityName(((WSPrincipal)principal).getName());
                        break;
                    }
                }
                if (trustedRealm && uniqueId != null && uniqueId.length() > 0) {
                    qualifiedIdentity = qualifiedIdentity + ":realm:" + uniqueId;
                }
            }
            catch (Exception e) {
                throw new SoapSecurityException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmQualifiedIdentityHelper: " + qualifiedIdentity);
        }
        return qualifiedIdentity;
    }
}

