/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSContextImpl
implements WSSContext {
    private static final TraceComponent tc = Tr.register(WSSContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private Context _context = null;

    public Object runWith(PrivilegedExceptionAction action, MessageContext mc) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runWith MessageContext = " + mc);
        }
        if (mc == null || action == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.runWith))");
            }
            sm.checkPermission(RUNWITH_PERM);
        }
        if ((obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) != null && obj instanceof Context) {
            if (this._context == null) {
                this._context = (Context)obj;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retriving security context on MessageContext");
            }
            try {
                return ((Context)obj).runWith(action);
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - runWith");
                }
                throw new SoapSecurityException("security.wssecurity.WSSContextImpl.s02", e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security context object missing in Message Context");
        }
        return null;
    }

    public Subject getCallerSubject(MessageContext mc) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject MessageContext = " + mc);
        }
        if (mc == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        if ((obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving security context on MessageContext");
            }
            Context context = (Context)obj;
            try {
                return context.getCallerSubject();
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - Retriving caller subject from Context");
                }
                throw new SoapSecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public void setCallerSubject(Subject caller, MessageContext mc) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject MessageContext = " + mc);
        }
        if (mc == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        if ((obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving security context on MessageContext");
            }
            Context context = (Context)obj;
            if (this._context == null) {
                this._context = context;
            }
            try {
                context.setCallerSubject(caller);
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - Setting caller subject to Context");
                }
                throw new SoapSecurityException(e.getMessage(), e);
            }
        }
    }

    public Subject getRunAsSubject(MessageContext mc) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSubject MessageContext = " + mc);
        }
        if (mc == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        if ((obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving security context on MessageContext");
            }
            Context context = (Context)obj;
            if (this._context == null) {
                this._context = context;
            }
            try {
                return context.getRunAsSubject();
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - Retriving runAs subject from Context");
                }
                throw new SoapSecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public void setRunAsSubject(Subject runAsSubject, MessageContext mc) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsSubject MessageContext = " + mc);
        }
        if (mc == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        if ((obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving security context on MessageContext");
            }
            Context context = (Context)obj;
            if (this._context == null) {
                this._context = context;
            }
            try {
                context.setRunAsSubject(runAsSubject);
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - Setting RunAs subject to Context");
                }
                throw new SoapSecurityException(e.getMessage(), e);
            }
        }
    }

    public WSSContext clone(WSSContext context, MessageContext mc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clone, MessageContext = " + mc);
        }
        if (mc == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        Object obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
        Context ctx = null;
        if (obj != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving security context on MessageContext");
            }
            ctx = (Context)obj;
            if (this._context == null) {
                this._context = ctx;
            }
        } else if (this._context != null) {
            ctx = this._context;
        }
        if (ctx != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Serializing security context object for deep copy");
                }
                oos.writeObject(context);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                WSSContextImpl newCtx = new WSSContextImpl();
                newCtx._context = (Context)ois.readObject();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "clone");
                }
                return newCtx;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - clone WSSContext: " + e.getMessage());
                }
                throw new SoapSecurityException(e.getMessage(), e);
            }
        }
        throw new SoapSecurityException("security.wssecurity.WSSContextImpl.s01");
    }

    public void setContextContent(Object object) throws SoapSecurityException {
        Context context;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        if (object == null) {
            return;
        }
        if (!(object instanceof Context)) {
            throw new SoapSecurityException("security.wssecurity.WSSContextImpl.s03");
        }
        this._context = context = (Context)object;
    }
}

