/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.wssecurity.platform.websphere.auth.WSSDistributedCache;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanCacheableTokenCache {
    private DistributedMap distributedMap = WSSDistributedCache.getDistributedCacheForService();
    private static final boolean distributedEnabled = CacheConfigFactory.getInstance().isDistributedCache();
    private static MBeanCacheableTokenCache mbeanCacheableTokenCache = null;
    private static final long MBEAN_TIMEOUT = CacheConfigFactory.getInstance().synchronousClusterTimeoutMilliseconds();
    private static final String CLASS_NAME = MBeanCacheableTokenCache.class.getName();
    private static final TraceComponent tc = Tr.register(MBeanCacheableTokenCache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static MBeanCacheableTokenCache getInstance() {
        if (mbeanCacheableTokenCache == null) {
            mbeanCacheableTokenCache = new MBeanCacheableTokenCache();
        }
        return mbeanCacheableTokenCache;
    }

    private MBeanCacheableTokenCache() {
    }

    public CacheableToken getToken(String uuid) {
        CacheableToken token;
        block9: {
            String methodName = "getToken";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getToken", uuid);
            }
            token = null;
            try {
                List<Properties> serversProperties = this.getClusterServersProperties();
                if (serversProperties.isEmpty()) break block9;
                for (final Properties serverProps : serversProperties) {
                    block10: {
                        final String fIdentifier = uuid;
                        try {
                            token = (CacheableToken)ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    ObjectName queryName;
                                    CacheableToken token = null;
                                    AdminClient adminClient = AdminClientFactory.createAdminClient(serverProps);
                                    Set s = adminClient.queryNames(queryName = new ObjectName("*:*,type=CacheableTokenMBean"), null);
                                    if (!s.isEmpty()) {
                                        ObjectName cacheableTokenMBean = (ObjectName)s.iterator().next();
                                        String opName = "getLocalToken";
                                        String[] signature = new String[]{"java.lang.String"};
                                        Object[] params = new Object[]{fIdentifier};
                                        token = (CacheableToken)adminClient.invoke(cacheableTokenMBean, opName, params, signature);
                                        MBeanCacheableTokenCache.trDebug("getToken found identifier: " + fIdentifier + " token: " + token);
                                    } else {
                                        MBeanCacheableTokenCache.trDebug("CacheableTokenMBean not found");
                                    }
                                    return token;
                                }
                            });
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getToken", "215", this);
                            if (!tc.isDebugEnabled()) break block10;
                            Tr.debug(tc, "Failed to find token in MBean", e.getStackTrace());
                        }
                    }
                    if (token != null) {
                        MBeanCacheableTokenCache.trDebug("token found in MBean");
                    } else {
                        if (!distributedEnabled || (token = (CacheableToken)this.distributedMap.get((Object)uuid)) == null) continue;
                        MBeanCacheableTokenCache.trDebug("Token found in distributed cache");
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getToken", "237", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Failed to find token in MBeans. ", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken", token);
        }
        return token;
    }

    public void removeTokenFromClusterMembers(String uuid) {
        block8: {
            String methodName = "removeToken";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeToken", uuid);
            }
            try {
                List<Properties> serversProperties = this.getClusterServersProperties();
                if (serversProperties.isEmpty()) break block8;
                ArrayList<InvokeCacheableTokenMBean> threads = new ArrayList<InvokeCacheableTokenMBean>();
                for (Properties properties : serversProperties) {
                    String opName = "removeLocalToken";
                    String[] signature = new String[]{"java.lang.String"};
                    Object[] params = new Object[]{uuid};
                    InvokeCacheableTokenMBean t = new InvokeCacheableTokenMBean(properties, opName, params, signature);
                    threads.add(t);
                    MBeanCacheableTokenCache.trDebug("Starting thread: " + t.getName());
                    t.start();
                }
                for (Thread thread : threads) {
                    block9: {
                        MBeanCacheableTokenCache.trDebug("Waiting for thread: " + thread.getName() + " to complete");
                        try {
                            thread.join();
                        }
                        catch (InterruptedException e) {
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "Thread interrupted, continuing to check other threads... ");
                        }
                    }
                    MBeanCacheableTokenCache.trDebug("Thread: " + thread.getName() + " complete");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "removeToken", "380", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Failed to remove token in MBeans. ", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeToken");
        }
    }

    public void updateTokenInClusterMembers(String uuid, CacheableToken token, long cacheTimeout) {
        block8: {
            String methodName = "updateToken";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateToken", uuid);
            }
            try {
                List<Properties> serversProperties = this.getClusterServersProperties();
                if (serversProperties.isEmpty()) break block8;
                ArrayList<InvokeCacheableTokenMBean> threads = new ArrayList<InvokeCacheableTokenMBean>();
                for (Properties properties : serversProperties) {
                    String opName = "updateLocalToken";
                    String[] signature = new String[]{"java.lang.String", "com.ibm.ws.wssecurity.token.CacheableToken", "long"};
                    Object[] params = new Object[]{uuid, token, cacheTimeout};
                    InvokeCacheableTokenMBean t = new InvokeCacheableTokenMBean(properties, opName, params, signature);
                    threads.add(t);
                    MBeanCacheableTokenCache.trDebug("Starting thread: " + t.getName());
                    t.start();
                }
                for (Thread thread : threads) {
                    block9: {
                        MBeanCacheableTokenCache.trDebug("Waiting for thread: " + thread.getName() + " to complete");
                        try {
                            thread.join();
                        }
                        catch (InterruptedException e) {
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "Thread interrupted, continuing to check other threads... ");
                        }
                    }
                    MBeanCacheableTokenCache.trDebug("Thread: " + thread.getName() + " complete");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "updateToken", "470", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Failed to update token in MBeans. ", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateToken");
        }
    }

    private List<Properties> getClusterServersProperties() {
        ArrayList<Properties> serversProperties;
        block12: {
            String methodName = "getClusterServersProperties";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterServersProperties");
            }
            serversProperties = new ArrayList<Properties>();
            Map clusterMap = new HashMap();
            try {
                block11: {
                    EndPointMgr ivEndPointMgr = WsServiceRegistry.getService(this, EndPointMgr.class);
                    Map endpoints = ivEndPointMgr.getNodeEndPoints();
                    Iterator nodeIter = endpoints.values().iterator();
                    String dmHost = null;
                    String dmPort = null;
                    boolean found = false;
                    while (nodeIter.hasNext() && !found) {
                        EndPointMgr.NodeEndPoints currentNode = (EndPointMgr.NodeEndPoints)nodeIter.next();
                        Map serverEndPoints = currentNode.getServerEndPoints();
                        Iterator serverIter = serverEndPoints.values().iterator();
                        while (serverIter.hasNext() && !found) {
                            EndPointMgr.ServerEndPoints currentServer = (EndPointMgr.ServerEndPoints)serverIter.next();
                            if (!currentServer.getType().equals("DEPLOYMENT_MANAGER")) continue;
                            EndPoint ep = currentServer.getEndPoint("SOAP_CONNECTOR_ADDRESS");
                            dmHost = ep.getHost();
                            dmPort = new Integer(ep.getPort()).toString();
                            found = true;
                        }
                    }
                    MBeanCacheableTokenCache.trDebug("dmHost: " + dmHost + " dmPort: " + dmPort);
                    if (dmHost == null || dmPort == null) {
                        MBeanCacheableTokenCache.trDebug("Unable to find dmHost and dmPort, returning empty properties");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getClusterServersProperties", serversProperties);
                        }
                        return serversProperties;
                    }
                    Properties connectionProps = new Properties();
                    connectionProps.setProperty("type", "SOAP");
                    connectionProps.setProperty("host", dmHost);
                    connectionProps.setProperty("port", dmPort);
                    connectionProps.setProperty("isInternal", "true");
                    try {
                        final Properties fConnectionProps = connectionProps;
                        Object fCluster = ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                AdminClient adminClient = AdminClientFactory.createAdminClient(fConnectionProps);
                                ObjectName queryName = new ObjectName("WebSphere:*,type=ClusterMgr");
                                Set s = adminClient.queryNames(queryName, null);
                                ObjectName clusterMgrMBean = null;
                                if (!s.isEmpty()) {
                                    clusterMgrMBean = (ObjectName)s.iterator().next();
                                } else {
                                    MBeanCacheableTokenCache.trDebug("ClusterMgr was not found, clustering not enabled.");
                                }
                                HashMap<String, String> clusterMap = new HashMap<String, String>();
                                if (clusterMgrMBean != null) {
                                    Server server = WsServiceRegistry.getService(this, Server.class);
                                    String myServerName = server.getName();
                                    MBeanCacheableTokenCache.trDebug("myServerName: " + myServerName);
                                    String opName = "retrieveClusters";
                                    ClusterData[] clusterData = (ClusterData[])adminClient.invoke(clusterMgrMBean, opName, null, null);
                                    for (int i = 0; i < clusterData.length; ++i) {
                                        ClusterMemberData[] clusterMemberData = clusterData[i].clusterMembers;
                                        for (int j = 0; j < clusterMemberData.length; ++j) {
                                            if (clusterMemberData[j].memberName.equals(myServerName)) continue;
                                            clusterMap.put(clusterMemberData[j].memberName, clusterMemberData[j].nodeName);
                                            MBeanCacheableTokenCache.trDebug("added serverName: " + clusterMemberData[j].memberName + " nodeName: " + clusterMemberData[j].nodeName);
                                        }
                                    }
                                }
                                return clusterMap;
                            }
                        });
                        clusterMap = (Map)fCluster;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getClusterServersProperties", "706", this);
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Failed to get cluster members", e.getStackTrace());
                    }
                }
                for (String serverName : clusterMap.keySet()) {
                    String nodeName = (String)clusterMap.get(serverName);
                    serversProperties.add(this.getServerAdminProps(serverName, nodeName));
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getClusterServersProperties", "669", this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Failed to get server properties", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterServersProperties", serversProperties);
        }
        return serversProperties;
    }

    private Properties getServerAdminProps(String serverName, String nodeName) {
        Properties p;
        block28: {
            String methodName = "getServerAdminProps";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerAdminProps", new Object[]{serverName, nodeName});
            }
            p = new Properties();
            String remoteAdminProtocol = null;
            String canonicalHostName = null;
            String rmiPort = null;
            try {
                List list = null;
                String resourceName = "server.xml";
                ConfigService service = WsServiceRegistry.getService(this, ConfigService.class);
                list = service.getDocumentObjects(service.getScope(4), resourceName);
                ConfigObject server = (ConfigObject)list.get(0);
                p.setProperty("isInternal", "true");
                List customServices = server.getObjectList("services");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of custom services: " + customServices.size());
                }
                ConfigObject adminService = null;
                for (ConfigObject obj : customServices) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom service: " + obj);
                    }
                    if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
                    adminService = obj;
                    break;
                }
                if (adminService != null) {
                    List jmxProperties;
                    ConfigObject jmxConnector = adminService.getObject("remoteAdminProtocol");
                    if (jmxConnector != null && jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "remoteAdminProtocol connector type is SOAP.");
                        }
                        p.setProperty("type", "SOAP");
                        remoteAdminProtocol = "SOAP";
                        jmxProperties = jmxConnector.getObjectList("properties");
                        for (ConfigObject prop : jmxProperties) {
                            if (prop.getString("name", null).equals("sslConfig")) {
                                String sslConfig = prop.getString("value", null);
                                p.setProperty("sslConfig", sslConfig);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SSLConfig alias to use: " + sslConfig);
                                }
                                if (sslConfig == null) continue;
                                SecurityService secSvc = null;
                                try {
                                    Properties sslProps;
                                    secSvc = WsServiceRegistry.getService(this, SecurityService.class);
                                    if (secSvc == null || (sslProps = secSvc.getSecureSocketLayer(sslConfig)) == null) continue;
                                    Enumeration<?> sslPropsEnum = sslProps.propertyNames();
                                    while (sslPropsEnum.hasMoreElements()) {
                                        String name = (String)sslPropsEnum.nextElement();
                                        String value = sslProps.getProperty(name);
                                        if (name == null || value == null) continue;
                                        p.setProperty(name, value);
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getServerAdminProps", "767", this);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Exception occurred getting SSLProps.", new Object[]{e});
                                    continue;
                                }
                            }
                            p.setProperty(prop.getString("name", null), prop.getString("value", null));
                        }
                    } else if (jmxConnector != null && (jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "RMIConnector") || jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "JSR160RMIConnector"))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "remoteAdminProtocol connector type is RMI or JSR160RMI.");
                        }
                        p.setProperty("type", "RMI");
                        remoteAdminProtocol = "RMI";
                        jmxProperties = jmxConnector.getObjectList("properties");
                        for (ConfigObject prop : jmxProperties) {
                            p.setProperty(prop.getString("name", null), prop.getString("value", null));
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin service is null.");
                }
                ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                ConfigScope scope = configService.createScope(3);
                scope.set(3, nodeName);
                List resource = configService.getDocumentObjects(scope, "serverindex.xml");
                ConfigObject doc = (ConfigObject)resource.get(0);
                List servers = doc.getObjectList("serverEntries");
                for (int j = 0; j < servers.size(); ++j) {
                    String type;
                    ConfigObject s = (ConfigObject)servers.get(j);
                    if (s == null || !(type = s.getString("serverType", null)).equals("APPLICATION_SERVER") || !s.getString("serverName", null).equals(serverName)) continue;
                    ConfigObject soapEP = null;
                    ConfigObject rmiEP = null;
                    List endpoints = s.getObjectList("specialEndpoints");
                    for (int k = 0; k < endpoints.size(); ++k) {
                        ConfigObject nep = (ConfigObject)endpoints.get(k);
                        if (nep.getString("endPointName", null).equals("SOAP_CONNECTOR_ADDRESS")) {
                            soapEP = nep.getObject("endPoint");
                        }
                        if (!nep.getString("endPointName", null).equals("BOOTSTRAP_ADDRESS") || (rmiEP = nep.getObject("endPoint")) == null) continue;
                        rmiPort = new Integer(rmiEP.getInt("port", 0)).toString();
                        canonicalHostName = rmiEP.getString("host", null);
                        p.setProperty("java.naming.provider.url", "corbaloc:iiop:" + canonicalHostName + ":" + rmiPort + "/WsnAdminNameService");
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "PROVIDER_URL: corbaloc:iiop:" + canonicalHostName + ":" + rmiPort);
                    }
                    if (soapEP != null && remoteAdminProtocol.equals("SOAP")) {
                        p.setProperty("port", new Integer(soapEP.getInt("port", 0)).toString());
                        p.setProperty("host", soapEP.getString("host", null));
                    } else if (rmiEP != null && (remoteAdminProtocol.equals("RMI") || remoteAdminProtocol.equals("JSR160RMI"))) {
                        p.setProperty("port", new Integer(rmiEP.getInt("port", 0)).toString());
                        p.setProperty("host", rmiEP.getString("host", null));
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getServerAdminProps", "858", this);
                if (!tc.isDebugEnabled()) break block28;
                Tr.debug(tc, "Exception occurred getting server connection props.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAdminProps", p);
        }
        return p;
    }

    private static void trDebug(String msg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, msg);
        }
    }

    private class InvokeCacheableTokenMBean
    extends Thread {
        private static final String mbeanName = "CacheableTokenMBean";
        private static final String INNER_CLASS_NAME = "InvokeCacheableTokenMBean";
        private Properties connectionProps = null;
        private String operationName = null;
        private Object[] params = null;
        private String[] signature = null;
        private Object result = null;

        public InvokeCacheableTokenMBean(Properties connectionProps, String operationName, Object[] params, String[] signature) {
            this.connectionProps = connectionProps;
            this.operationName = operationName;
            this.params = params;
            this.signature = signature;
        }

        public void run() {
            block4: {
                String methodName = "run";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                try {
                    this.result = ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ObjectName queryName;
                            AdminClient adminClient = AdminClientFactory.createAdminClient(InvokeCacheableTokenMBean.this.connectionProps);
                            Set s = adminClient.queryNames(queryName = new ObjectName("*:*,type=CacheableTokenMBean"), null);
                            if (!s.isEmpty()) {
                                ObjectName cacheableTokenMBean = (ObjectName)s.iterator().next();
                                InvokeCacheableTokenMBean.this.result = adminClient.invoke(cacheableTokenMBean, InvokeCacheableTokenMBean.this.operationName, InvokeCacheableTokenMBean.this.params, InvokeCacheableTokenMBean.this.signature);
                            } else {
                                MBeanCacheableTokenCache.trDebug("CacheableTokenMBean not found");
                            }
                            return InvokeCacheableTokenMBean.this.result;
                        }
                    });
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "InvokeCacheableTokenMBean.run", "927", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Failed to run operation: " + this.operationName + " on " + mbeanName, e.getStackTrace());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        public Object getResult() {
            return this.result;
        }
    }
}

