/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCCacheableTokenCache {
    private Map<String, Alarm> activeAlarms = new HashMap<String, Alarm>();
    private String TABLE_NAME = null;
    private static final String TABLE_NAME_BASE = "IBM_WAS_WSS_CT";
    private String authnName = null;
    private static final String UUID = "UUID";
    private static final String TOKEN = "CACHEABLE_TOKEN";
    private static final String CACHE_TIMEOUT = "CACHE_TIMEOUT";
    private static final String TIMESTAMP = "tc_TIMESTAMP";
    private static JDBCCacheableTokenCache jdbcCacheableTokenCache = null;
    private static final String JNDI_DATA_SOURCE_NAME = CacheConfigFactory.getInstance().getJNDIName();
    private static final String CLASS_NAME = JDBCCacheableTokenCache.class.getName();
    private static final TraceComponent tc = Tr.register(JDBCCacheableTokenCache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private DBVENDOR dbVendor = DBVENDOR.UNSPECIFIED;
    private final String MICROSOFT = "MICROSOFT";
    private final String DB2 = "DB2";
    private final String ORACLE = "ORACLE";
    private final String INFORMIX = "INFORMIX";
    private final String SYBASE = "ADAPTIVE SERVER";

    public static JDBCCacheableTokenCache getInstance() {
        String methodName = "getInstance";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (jdbcCacheableTokenCache == null) {
            jdbcCacheableTokenCache = new JDBCCacheableTokenCache();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", jdbcCacheableTokenCache);
        }
        return jdbcCacheableTokenCache;
    }

    private JDBCCacheableTokenCache() {
        String methodName = "JDBCCacheableTokenCache";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JDBCCacheableTokenCache");
        }
        this.createCacheableTokenTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JDBCCacheableTokenCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean cacheToken(String uuid, CacheableToken token, long cacheTimeout) {
        boolean cache;
        block28: {
            SQLException e222;
            Statement preparedStatement;
            Connection connection;
            block24: {
                String methodName = "cacheToken";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "cacheToken", new Object[]{uuid, token, cacheTimeout});
                }
                cache = false;
                if (this.getToken(uuid = this.makeUUIDValid(uuid)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "cacheToken");
                    }
                    return this.updateToken(uuid, token, cacheTimeout);
                }
                connection = null;
                preparedStatement = null;
                connection = this.getConnection();
                byte[] tokenBytes = this.getSerializationBytes(token);
                GregorianCalendar currentTimeCalendar = new GregorianCalendar();
                String insert = "INSERT INTO " + this.TABLE_NAME + " VALUES ( ?, ?, ?, ? )";
                preparedStatement = connection.prepareStatement(insert);
                preparedStatement.setString(1, uuid);
                preparedStatement.setBytes(2, tokenBytes);
                preparedStatement.setLong(3, cacheTimeout);
                preparedStatement.setLong(4, currentTimeCalendar.getTimeInMillis());
                preparedStatement.executeUpdate();
                this.addAlarm(uuid, cacheTimeout);
                cache = true;
                Object var13_12 = null;
                if (preparedStatement == null) break block24;
                try {
                    preparedStatement.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "124", this);
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "115", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                    }
                }
            }
            break block28;
            {
                catch (SQLException e3) {
                    SQLException e222;
                    block25: {
                        FFDCFilter.processException((Throwable)e3, CLASS_NAME + "." + "cacheToken", "107", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to cache token using JDBC", e3.getStackTrace());
                        }
                        Object var13_13 = null;
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "124", this);
                                if (!tc.isDebugEnabled()) break block25;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "115", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block27: {
                    SQLException e222;
                    block26: {
                        Object var13_14 = null;
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "124", this);
                                if (!tc.isDebugEnabled()) break block26;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "cacheToken", "115", this);
                            if (!tc.isDebugEnabled()) break block27;
                            Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheToken", cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CacheableToken getToken(String uuid) {
        CacheableToken token;
        block28: {
            SQLException e222;
            Statement statement;
            Connection connection;
            block24: {
                block23: {
                    ResultSet resultSet;
                    String methodName = "getToken";
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getToken", uuid);
                    }
                    token = null;
                    uuid = this.makeUUIDValid(uuid);
                    connection = null;
                    statement = null;
                    connection = this.getConnection();
                    statement = connection.createStatement();
                    String getTokenSQL = "SELECT CACHEABLE_TOKEN FROM " + this.TABLE_NAME + " WHERE " + UUID + "='" + uuid + "'";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getTokenSQL: " + getTokenSQL);
                    }
                    if (!(resultSet = statement.executeQuery(getTokenSQL)).next()) break block23;
                    token = this.deserializeBytes(resultSet.getBytes(TOKEN));
                }
                Object var9_9 = null;
                if (statement == null) break block24;
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "179", this);
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "170", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                    }
                }
            }
            break block28;
            {
                catch (SQLException e3) {
                    SQLException e222;
                    block25: {
                        FFDCFilter.processException((Throwable)e3, CLASS_NAME + "." + "getToken", "162", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get token using JDBC", e3.getStackTrace());
                        }
                        Object var9_10 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "179", this);
                                if (!tc.isDebugEnabled()) break block25;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "170", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block27: {
                    SQLException e222;
                    block26: {
                        Object var9_11 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "179", this);
                                if (!tc.isDebugEnabled()) break block26;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "getToken", "170", this);
                            if (!tc.isDebugEnabled()) break block27;
                            Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken", token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CacheableToken removeToken(String uuid) {
        CacheableToken token;
        block26: {
            SQLException e222;
            Statement statement;
            Connection connection;
            block22: {
                String methodName = "removeToken";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeToken", uuid);
                }
                token = null;
                uuid = this.makeUUIDValid(uuid);
                connection = null;
                statement = null;
                token = this.getToken(uuid);
                connection = this.getConnection();
                statement = connection.createStatement(1003, 1008);
                String deleteToken = "DELETE FROM " + this.TABLE_NAME + " WHERE " + UUID + "='" + uuid + "'";
                statement.executeUpdate(deleteToken);
                this.removeAlarm(uuid);
                Object var8_8 = null;
                if (statement == null) break block22;
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "236", this);
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "227", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                    }
                }
            }
            break block26;
            {
                catch (SQLException e3) {
                    SQLException e222;
                    block23: {
                        FFDCFilter.processException((Throwable)e3, CLASS_NAME + "." + "removeToken", "219", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to remove token using JDBC", e3.getStackTrace());
                        }
                        Object var8_9 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "236", this);
                                if (!tc.isDebugEnabled()) break block23;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "227", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block25: {
                    SQLException e222;
                    block24: {
                        Object var8_10 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "236", this);
                                if (!tc.isDebugEnabled()) break block24;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "removeToken", "227", this);
                            if (!tc.isDebugEnabled()) break block25;
                            Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeToken", token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateToken(String uuid, CacheableToken token, long cacheTimeout) {
        boolean update;
        block27: {
            SQLException e222;
            Statement preparedStatement;
            Connection connection;
            block23: {
                String methodName = "updateToken";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "updateToken", new Object[]{uuid, token, cacheTimeout});
                }
                update = false;
                uuid = this.makeUUIDValid(uuid);
                connection = null;
                preparedStatement = null;
                connection = this.getConnection();
                String updateSQL = "UPDATE " + this.TABLE_NAME + " set " + TOKEN + " = ?, " + CACHE_TIMEOUT + " = ?, " + TIMESTAMP + " = ? WHERE UUID  = '" + uuid + "'";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateSQL: " + updateSQL);
                }
                preparedStatement = connection.prepareStatement(updateSQL);
                byte[] tokenBytes = this.getSerializationBytes(token);
                GregorianCalendar currentTimeCalendar = new GregorianCalendar();
                preparedStatement.setBytes(1, tokenBytes);
                preparedStatement.setLong(2, cacheTimeout);
                preparedStatement.setLong(3, currentTimeCalendar.getTimeInMillis());
                preparedStatement.executeUpdate();
                this.addAlarm(uuid, cacheTimeout);
                update = true;
                Object var13_12 = null;
                if (preparedStatement == null) break block23;
                try {
                    preparedStatement.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "295", this);
                    if (!tc.isDebugEnabled()) break block23;
                    Tr.debug(tc, "Failed to close JDBC PreparedStatement", e222.getStackTrace());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "286", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                    }
                }
            }
            break block27;
            {
                catch (SQLException e3) {
                    SQLException e222;
                    block24: {
                        FFDCFilter.processException((Throwable)e3, CLASS_NAME + "." + "updateToken", "278", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to update token using JDBC", e3.getStackTrace());
                        }
                        Object var13_13 = null;
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "295", this);
                                if (!tc.isDebugEnabled()) break block24;
                                Tr.debug(tc, "Failed to close JDBC PreparedStatement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "286", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block26: {
                    SQLException e222;
                    block25: {
                        Object var13_14 = null;
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "295", this);
                                if (!tc.isDebugEnabled()) break block25;
                                Tr.debug(tc, "Failed to close JDBC PreparedStatement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "updateToken", "286", this);
                            if (!tc.isDebugEnabled()) break block26;
                            Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateToken", update);
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createCacheableTokenTable() {
        block44: {
            SQLException e222;
            Statement statement;
            Connection connection;
            block40: {
                block39: {
                    String methodName = "createCacheableTokenTable";
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "createCacheableTokenTable");
                    }
                    connection = null;
                    statement = null;
                    connection = this.getConnection();
                    statement = connection.createStatement();
                    String dbp = connection.getMetaData().getDatabaseProductName();
                    if (dbp != null) {
                        if ((dbp = dbp.toUpperCase()).contains("MICROSOFT")) {
                            this.dbVendor = DBVENDOR.MICROSOFT;
                        } else if (dbp.contains("DB2")) {
                            this.dbVendor = DBVENDOR.DB2;
                        } else if (dbp.contains("ORACLE")) {
                            this.dbVendor = DBVENDOR.ORACLE;
                        } else if (dbp.contains("INFORMIX")) {
                            this.dbVendor = DBVENDOR.INFORMIX;
                        } else if (dbp.contains("ADAPTIVE SERVER")) {
                            this.dbVendor = DBVENDOR.SYBASE;
                        }
                    }
                    boolean tableExists = false;
                    this.authnName = connection.getMetaData().getUserName();
                    String localname = this.getCellAndClusterName();
                    this.TABLE_NAME = "IBM_WAS_WSS_CT_" + localname;
                    ResultSet resultSet = connection.getMetaData().getTables(null, null, this.TABLE_NAME, new String[]{"TABLE"});
                    while (resultSet.next()) {
                        String schema = resultSet.getString("TABLE_SCHEM");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found table schema=" + schema);
                        }
                        if (this.authnName == null && null == schema) {
                            tableExists = true;
                            break;
                        }
                        if (this.authnName == null || !this.authnName.equalsIgnoreCase(schema)) continue;
                        tableExists = true;
                        this.authnName = schema;
                        this.TABLE_NAME = this.authnName + "." + TABLE_NAME_BASE + "_" + localname;
                        break;
                    }
                    if (!tableExists && this.authnName != null && !this.authnName.isEmpty()) {
                        this.TABLE_NAME = this.dbVendor.equals((Object)DBVENDOR.MICROSOFT) || this.dbVendor.equals((Object)DBVENDOR.SYBASE) ? this.authnName + "." + TABLE_NAME_BASE + "_" + localname : this.authnName.toUpperCase() + "." + TABLE_NAME_BASE + "_" + localname;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tableExists: " + tableExists);
                    }
                    if (tableExists) {
                        this.cleanTable(statement);
                        break block39;
                    }
                    String createTable = null;
                    createTable = this.dbVendor.equals((Object)DBVENDOR.ORACLE) ? "CREATE TABLE " + this.TABLE_NAME + " (" + UUID + " VARCHAR(1024), " + TOKEN + " BLOB, " + CACHE_TIMEOUT + " NUMBER(19), " + TIMESTAMP + " NUMBER(19))" : (this.dbVendor.equals((Object)DBVENDOR.MICROSOFT) || this.dbVendor.equals((Object)DBVENDOR.SYBASE) ? "CREATE TABLE " + this.TABLE_NAME + " (" + UUID + " VARCHAR(1024), " + TOKEN + " IMAGE, " + CACHE_TIMEOUT + " BIGINT, " + TIMESTAMP + " BIGINT)" : (this.dbVendor.equals((Object)DBVENDOR.INFORMIX) ? "CREATE TABLE " + this.TABLE_NAME + " (" + UUID + " LVARCHAR(1024), " + TOKEN + " BLOB, " + CACHE_TIMEOUT + " INT8, " + TIMESTAMP + " INT8)" : "CREATE TABLE " + this.TABLE_NAME + " (" + UUID + " VARCHAR(1024), " + TOKEN + " BLOB, " + CACHE_TIMEOUT + " BIGINT, " + TIMESTAMP + " BIGINT)"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createTable: " + createTable);
                    }
                    statement.executeUpdate(createTable);
                }
                Object var10_10 = null;
                if (statement == null) break block40;
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "362", this);
                    if (!tc.isDebugEnabled()) break block40;
                    Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e222) {
                    FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "353", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                    }
                }
            }
            break block44;
            {
                catch (SQLException e3) {
                    SQLException e222;
                    block41: {
                        FFDCFilter.processException((Throwable)e3, CLASS_NAME + "." + "createCacheableTokenTable", "345", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to create JDBC Cache table", e3.getStackTrace());
                        }
                        Object var10_11 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "362", this);
                                if (!tc.isDebugEnabled()) break block41;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "353", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block43: {
                    SQLException e222;
                    block42: {
                        Object var10_12 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e222) {
                                FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "362", this);
                                if (!tc.isDebugEnabled()) break block42;
                                Tr.debug(tc, "Failed to close JDBC Statement", e222.getStackTrace());
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e222) {
                            FFDCFilter.processException((Throwable)e222, CLASS_NAME + "." + "createCacheableTokenTable", "353", this);
                            if (!tc.isDebugEnabled()) break block43;
                            Tr.debug(tc, "Failed to close JDBC Connection", e222.getStackTrace());
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCacheableTokenTable");
        }
    }

    private void cleanTable(Statement statement) {
        block14: {
            String methodName = "cleanTable";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanTable");
            }
            GregorianCalendar currentTimeCalendar = new GregorianCalendar();
            long currentTime = currentTimeCalendar.getTimeInMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentTime.getTime(): " + currentTime);
            }
            try {
                long cacheTimeout;
                String allElements = "SELECT * FROM " + this.TABLE_NAME;
                ResultSet resultSet = statement.executeQuery(allElements);
                ArrayList<String> uuidsToRemove = new ArrayList<String>();
                HashMap<String, Long> uuidsToAddAlarm = new HashMap<String, Long>();
                while (resultSet.next()) {
                    long timestamp = resultSet.getLong(TIMESTAMP);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timestamp.getTime(): " + timestamp);
                    }
                    cacheTimeout = resultSet.getLong(CACHE_TIMEOUT);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cacheTimeout: " + cacheTimeout);
                    }
                    long expireTime = timestamp + cacheTimeout;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "expireTime: " + expireTime);
                        GregorianCalendar expireTimeCalendar = new GregorianCalendar();
                        expireTimeCalendar.setTimeInMillis(expireTime);
                        Tr.debug(tc, "This token will expire on: " + expireTimeCalendar.getTime());
                    }
                    String uuid = resultSet.getString(UUID);
                    if (expireTime < currentTime) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "will remove UUID: " + uuid);
                        }
                        uuidsToRemove.add(uuid);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating Alarm for UUID: " + uuid);
                    }
                    long newCacheTimeout = cacheTimeout - (currentTime - timestamp);
                    uuidsToAddAlarm.put(uuid, new Long(newCacheTimeout));
                }
                for (String uuid : uuidsToRemove) {
                    this.removeToken(uuid);
                }
                for (String uuid : uuidsToAddAlarm.keySet()) {
                    cacheTimeout = (Long)uuidsToAddAlarm.get(uuid);
                    this.addAlarm(uuid, cacheTimeout);
                }
            }
            catch (SQLException e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "cleanTable", "162", this);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "Failed to get token using JDBC", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanTable");
        }
    }

    private Connection getConnection() {
        Connection connection;
        block6: {
            String methodName = "getConnection";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConnection");
            }
            connection = null;
            try {
                Properties p = new Properties();
                p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                InitialContext ic = new InitialContext(p);
                DataSource dataSource = (DataSource)ic.lookup(JNDI_DATA_SOURCE_NAME);
                connection = dataSource.getConnection();
            }
            catch (SQLException e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getConnection", "400", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get JDBC Connection", e.getStackTrace());
                }
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + "getConnection", "476", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Failed to get JDBC Connection", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection", connection);
        }
        return connection;
    }

    private void addAlarm(String uuid, long cacheTimeout) {
        this.removeAlarm(uuid);
        Alarm alarm = null;
        if (cacheTimeout > 0L) {
            alarm = AlarmManager.createDeferrable(cacheTimeout, new AlarmListener(){

                public void alarm(Object alarmContext) {
                    JDBCCacheableTokenCache.this.removeToken((String)alarmContext);
                }
            }, uuid);
            this.activeAlarms.put(uuid, alarm);
        }
    }

    private void removeAlarm(String uuid) {
        Alarm alarm = this.activeAlarms.get(uuid);
        if (alarm != null) {
            this.activeAlarms.remove(uuid);
            alarm.cancel();
        }
    }

    private String makeUUIDValid(String uuid) {
        String secondHalf;
        String firstHalf;
        String methodName = "makeUUIDValid";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeUUIDValid", uuid);
        }
        String invalidChars = ":";
        int index = 0;
        while (uuid.contains(invalidChars)) {
            index = uuid.indexOf(":");
            if (index == -1) continue;
            firstHalf = uuid.substring(0, index);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "firstHalf: " + firstHalf);
            }
            secondHalf = uuid.substring(index + 1, uuid.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "secondHalf: " + secondHalf);
            }
            uuid = firstHalf + secondHalf;
        }
        invalidChars = "/";
        while (uuid.contains(invalidChars)) {
            index = uuid.indexOf("/");
            if (index == -1) continue;
            firstHalf = uuid.substring(0, index);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "firstHalf: " + firstHalf);
            }
            secondHalf = uuid.substring(index + 1, uuid.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "secondHalf: " + secondHalf);
            }
            uuid = firstHalf + secondHalf;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeUUIDValid", uuid);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] getSerializationBytes(CacheableToken token) {
        byte[] serializationBytes;
        block13: {
            String methodName = "getSerializationBytes";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSerializationBytes", token);
            }
            ByteArrayOutputStream byteStream = null;
            ObjectOutputStream outObjStream = null;
            serializationBytes = null;
            byteStream = new ByteArrayOutputStream();
            outObjStream = new ObjectOutputStream(byteStream);
            outObjStream.writeObject(token);
            serializationBytes = byteStream.toByteArray();
            Object var8_6 = null;
            try {
                outObjStream.flush();
                outObjStream.close();
                byteStream.close();
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                }
                break block13;
            }
            {
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Fail to serialize Token. ", e.getStackTrace());
                    }
                    Object var8_7 = null;
                    try {
                        outObjStream.flush();
                        outObjStream.close();
                        byteStream.close();
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block14: {
                    Object var8_8 = null;
                    try {
                        outObjStream.flush();
                        outObjStream.close();
                        byteStream.close();
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializationBytes");
        }
        return serializationBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CacheableToken deserializeBytes(byte[] serializedToken) {
        CacheableToken token;
        block13: {
            String methodName = "deserializeBytes";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deserializeBytes", serializedToken);
            }
            token = null;
            ByteArrayInputStream byteStream = null;
            ObjectInputStream inObjStream = null;
            byteStream = new ByteArrayInputStream(serializedToken);
            inObjStream = new ObjectInputStream(byteStream);
            token = (CacheableToken)inObjStream.readObject();
            Object var8_6 = null;
            try {
                inObjStream.close();
                byteStream.close();
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                }
                break block13;
            }
            {
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Fail to deserialize Token. ", e.getStackTrace());
                    }
                    Object var8_7 = null;
                    try {
                        inObjStream.close();
                        byteStream.close();
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block14: {
                    Object var8_8 = null;
                    try {
                        inObjStream.close();
                        byteStream.close();
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Failed to close stream. ", e2.getStackTrace());
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeBytes", token);
        }
        return token;
    }

    private String getCellAndClusterName() {
        String name;
        block7: {
            String methodName = "getCellAndClusterName()";
            name = null;
            try {
                name = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Server server = WsServiceRegistry.getService(this, Server.class);
                        if (server != null) {
                            String clusterName = server.getClusterName();
                            String cellName = server.getCellName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster name from server service=" + clusterName);
                                Tr.debug(tc, "cell name from server service=" + cellName);
                            }
                            if (clusterName == null) {
                                clusterName = server.getName();
                            }
                            return cellName + ":" + clusterName;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                FFDCFilter.processException((Throwable)e, CLASS_NAME + "." + methodName, "476", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Failed to get JDBC Connection", e.getStackTrace());
            }
        }
        if (name == null) {
            name = "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell and cluster name from server service=" + name);
        }
        int hash = name.hashCode();
        boolean neg = false;
        if (hash < 0) {
            neg = true;
            hash *= -1;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(hash);
        if (neg) {
            sb.append("n");
        }
        name = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell and cluster name hash from server service=" + name);
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBVENDOR {
        UNSPECIFIED,
        DB2,
        MICROSOFT,
        ORACLE,
        INFORMIX,
        SYBASE;

    }
}

