/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.Token;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;

public class CacheableSubjectHelperImpl
implements CacheableSubjectHelper {
    private static long DEFAULT_EXPIRATION = 300000L;
    private static final TraceComponent tc = Tr.register(CacheableSubjectHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public String getIdentifier(final Subject subject) {
        String identifier;
        block8: {
            identifier = null;
            try {
                identifier = ContextManagerFactory.getInstance().getWSCredTokenMapper().createSubjectUniqueID(subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subject identifier = " + identifier);
                }
                if (identifier == null) {
                    try {
                        identifier = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws Exception {
                                Subject subject2 = subject;
                                synchronized (subject2) {
                                    Set<Token> publicCredentials;
                                    Set<Token> privateCredentials = subject.getPrivateCredentials(Token.class);
                                    if (privateCredentials != null && privateCredentials.size() > 0) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug(tc, "Got some private credentials to iterate through.");
                                        }
                                        for (Token token : privateCredentials) {
                                            if (token == null || !(token instanceof Token)) continue;
                                            if (tc.isEntryEnabled()) {
                                                Tr.debug(tc, "Getting uniqueID from token.");
                                            }
                                            String id = token.getUniqueID();
                                            String principal = token.getPrincipal();
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Token found, ID/Principal: ", new Object[]{id, principal});
                                            }
                                            if (id == null || id.length() <= 0) continue;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "uniqueID: " + id);
                                            }
                                            return id;
                                        }
                                    }
                                    if ((publicCredentials = subject.getPublicCredentials(Token.class)) != null && publicCredentials.size() > 0) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug(tc, "Got some public credentials to iterate through.");
                                        }
                                        for (Token token : publicCredentials) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "token found, looking for uniqueID.", new Object[]{token});
                                            }
                                            if (token == null || !(token instanceof Token)) continue;
                                            String id = token.getUniqueID();
                                            String principal = token.getPrincipal();
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "ID/Principal: ", new Object[]{id, principal});
                                            }
                                            if (id == null || id.length() <= 0) continue;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "uniqueID: " + id);
                                            }
                                            return id;
                                        }
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught: " + e.getMessage());
                        }
                    }
                }
            }
            catch (WSSecurityException e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception caught: " + e.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adjusted subject identifier = " + identifier);
        }
        return identifier;
    }

    public long getExpiration(Subject subject) {
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        long expiration_time = System.currentTimeMillis();
        try {
            if (wsCred != null && wsCred.isForwardable()) {
                expiration_time = wsCred.getExpiration();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subject expiration in " + (expiration_time - System.currentTimeMillis()) + " ms");
        }
        return expiration_time;
    }
}

