/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.audit;

import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.websphere.audit.WSSAuditServiceImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.audit.ContextObj;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSAuditEventGeneratorImpl
implements WSSAuditEventGenerator {
    private static final TraceComponent tc = Tr.register(WSSAuditEventGeneratorImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String MSG_ID = "MsgId";
    private static final String REQ_MSG_ID = "ReqMsgId";
    private static final String SVC_ENDPOINT = "SvcEndPoint";
    private static final String SOAP_ACTION = "SoapAction";
    private static final String WSA_ACTION = "WsaAction";
    private static final String PROVIDER = "Provider";
    private static final String PROVIDER_STATUS = "ProviderStatus";
    private static final String EXTENDED_EVENT_DATA = "EXTENDED_EVENT_DATA";

    @Override
    public void sendEvent(WSSAuditService.WSSAuditEventType eventType, MessageContext msgContext, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("sendEvent(");
            buf.append("WSSAuditService.WSSAuditEventType eventType[" + (Object)((Object)eventType) + "], ");
            buf.append("MessageContext msgContext, ");
            buf.append("Map<Object, Object> context)");
            Tr.entry(tc, buf.toString());
        }
        if (msgContext == null || context == null) {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageContext = " + msgContext + "  context = " + context);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendEvent");
            }
            return;
        }
        HashMap auditContext = (HashMap)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
        if (auditContext == null) {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditContext does not exist");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendEvent");
            }
            return;
        }
        Boolean dontSend = (Boolean)auditContext.remove("DontSendEvent");
        if (dontSend == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sending event");
            }
            try {
                AuditService auditService = ContextManagerFactory.getInstance().getAuditService();
                ContextHandler contextHandler = auditService.getContextHandler();
                this.buildCommonEventData(msgContext, context, auditService, contextHandler, auditContext);
                this.buildExtendedEventData(msgContext, context, auditService, contextHandler, auditContext);
                String outcome = auditContext.get("Outcome") == null ? null : ((AuditOutcome)auditContext.remove("Outcome")).getOutcomeStr();
                Long reason_code = auditContext.get("ReasonCode") == null ? null : Long.valueOf((Long)auditContext.remove("ReasonCode"));
                ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData((String)"SUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)outcome, (long)reason_code);
                WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                wssAuditService.sendEvent(eventType, auditOutcome, context);
            }
            catch (Exception e) {
                Tr.warning(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s02", new Object[]{e});
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dontSend is true, discarding audit data");
            }
            this.clearAuditData(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendEvent");
        }
    }

    @Override
    public Map<String, Object> setAuditEventContext(Map<Object, Object> context, WSSAuditService.WSSAuditOutcome outcome, WSSAuditService.WSSAuditReason reason, String description) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("setAuditEventContext(");
            buf.append("Map<Object, Object> context, ");
            buf.append("WSSAuditService.WSSAuditOutcome outcome, ");
            buf.append("WSSAuditService.WSSAuditReason reason,[" + (Object)((Object)reason) + "], ");
            buf.append("String description)");
            Tr.entry(tc, buf.toString());
        }
        if (context != null) {
            HashMap<String, Object> auditContext = (HashMap<String, Object>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Object>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            auditContext.put("Outcome", WSSAuditServiceImpl.getAuditOutcome(outcome));
            auditContext.put("Reason", WSSAuditServiceImpl.getReason(reason));
            if (auditContext.get("ReasonCode") == null) {
                auditContext.put("ReasonCode", WSSAuditServiceImpl.getReasonCode(reason));
            }
            auditContext.put("Description", description);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setAuditEventContext return (auditContext)");
            }
            return auditContext;
        }
        Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuditEventContext return (null)");
        }
        return null;
    }

    @Override
    public void setAuditOutcomeReasonCode(Map<Object, Object> context, WSSAuditService.WSSAuditReason reason) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("setAuditOutcomeReasonCode(");
            buf.append("Map<Object, Object> context, ");
            buf.append("WSSAuditService.WSSAuditReason reason[" + (Object)((Object)reason) + "])");
            Tr.entry(tc, buf.toString());
        }
        if (context != null) {
            HashMap<String, Long> auditContext = (HashMap<String, Long>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Long>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            auditContext.put("ReasonCode", WSSAuditServiceImpl.getReasonCode(reason));
        } else {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuditOutcomeReasonCode");
        }
    }

    @Override
    public Map<String, Object> setExtendedAuditData(Map<Object, Object> context, String key, String value) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("setExtendedAuditData(");
            buf.append("Map<Object, Object> context, ");
            buf.append("String key[" + key + "], ");
            buf.append("String value[" + value + "])");
            Tr.entry(tc, buf.toString());
        }
        if (context != null) {
            HashMap<String, String> extendedAuditContext;
            HashMap<String, Object> auditContext = (HashMap<String, Object>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Object>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            if ((extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA)) == null) {
                extendedAuditContext = new HashMap<String, String>();
                auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
            }
            extendedAuditContext.put(key, value);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setExtendedAuditData return (auditContext)");
            }
            return auditContext;
        }
        Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExtendedAuditData return (null)");
        }
        return null;
    }

    @Override
    public void addExtendedAuditData(Map<String, Object> auditContext, String key, String value) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addExtendedAuditData(");
            buf.append("Map<String, Object> auditContext, ");
            buf.append("String key[" + key + "], ");
            buf.append("String value[" + value + "])");
            Tr.entry(tc, buf.toString());
        }
        if (auditContext == null || key == null) {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            return;
        }
        HashMap<String, String> extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA);
        if (extendedAuditContext == null) {
            extendedAuditContext = new HashMap<String, String>();
            auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
        }
        extendedAuditContext.put(key, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addExtendedAuditData");
        }
    }

    @Override
    public void addProviderData(Map<String, Object> auditContext, String provider, String providerStatus) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addProviderData(");
            buf.append("Map<String, Object> auditContext, ");
            buf.append("String provider[" + provider + "], ");
            buf.append("String providerStatus[" + providerStatus + "])");
            Tr.entry(tc, buf.toString());
        }
        if (auditContext == null || provider == null) {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            return;
        }
        HashMap<String, String> extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA);
        if (extendedAuditContext == null) {
            extendedAuditContext = new HashMap<String, String>();
            auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
        }
        extendedAuditContext.put(PROVIDER, provider);
        extendedAuditContext.put(PROVIDER_STATUS, providerStatus);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProviderData");
        }
    }

    @Override
    public void clearAuditData(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("clearAuditData(");
            buf.append("Map<Object, Object> context])");
            Tr.entry(tc, buf.toString());
        }
        context.remove("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAuditData");
        }
    }

    private void buildCommonEventData(MessageContext msgContext, Map<Object, Object> context, AuditService auditService, ContextHandler contextHandler, HashMap<String, Object> auditContext) {
        MessageContext origMsgContext;
        HashMap data;
        String uriName;
        HttpServletRequest req;
        block15: {
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("buildCommonEventData(");
                buf.append("MessageContext msgContext, ");
                buf.append("Map<Object, Object> context, ");
                buf.append("AuditService auditService, ");
                buf.append("ContextHandler contextHandler, ");
                buf.append("HashMap<String, Object> auditContext[" + auditContext.toString() + "])");
                Tr.entry(tc, buf.toString());
            }
            req = null;
            HttpSession session = null;
            uriName = null;
            Object obj = msgContext.getProperty("transport.http.servletRequest");
            if (obj != null && obj instanceof HttpServletRequest) {
                req = (HttpServletRequest)obj;
                uriName = req.getServletPath() + req.getPathInfo();
                session = req.getSession();
                if (tc.isDebugEnabled()) {
                    if (session != null) {
                        Tr.debug(tc, "HTTP session is " + session.getId());
                    } else {
                        Tr.debug(tc, "HTTP session is null");
                    }
                }
            }
            data = null;
            if (session != null) {
                data = DataHelper.buildSessionData((String)req.getSession().getId(), (String)req.getRemoteAddr(), (String)req.getRemoteHost(), (String)new Integer(req.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
            }
            origMsgContext = null;
            OperationContext opCtx = msgContext.getOperationContext();
            try {
                if (opCtx == null) {
                    opCtx = (OperationContext)msgContext.getProperty("unverifiedOperationContext");
                }
                if (opCtx != null) {
                    origMsgContext = opCtx.getMessageContext("In");
                }
            }
            catch (AxisFault f) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Caucght exception: " + f.getMessage());
            }
        }
        String[] eventTrailIds = auditService.getEventTrailIds();
        String lastTrailId = msgContext.getLogIDString();
        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
        contextHandler.buildContextObject("EVENT_CONTEXT", data);
        String method = req == null ? null : req.getMethod();
        String outcome = (AuditOutcome)auditContext.get("Outcome") == null ? null : ((AuditOutcome)auditContext.get("Outcome")).getOutcomeStr();
        data = DataHelper.buildAccessData((String)uriName, (String)"resourceAccess", null, null, (String)outcome, (String)method, (String)"soap", (Long)new Long(0L), null, null, null, null);
        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
        data = new HashMap();
        data.put(MSG_ID, msgContext.getLogCorrelationID());
        if (origMsgContext != null) {
            data.put(REQ_MSG_ID, origMsgContext.getLogCorrelationID());
        }
        if (msgContext.getAxisService() != null) {
            data.put(SVC_ENDPOINT, msgContext.getAxisService().getEndpointName());
        }
        data.put(SOAP_ACTION, msgContext.getSoapAction());
        data.put(WSA_ACTION, msgContext.getWSAAction());
        if (WSSContextManagerFactory.getInstance().getAuditService().isVerbose()) {
            data.put("Reason", auditContext.get("Reason"));
            auditContext.remove("Reason");
            if (auditContext.get("Description") != null) {
                data.put("Description", auditContext.get("Description"));
                auditContext.remove("Description");
            }
        }
        data = DataHelper.buildCustomData(data);
        contextHandler.buildContextObject("CUSTOM_PROPERTY_CONTEXT", data);
        data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
        data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)ContextManagerFactory.getInstance().getDefaultRealm());
        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
        SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
        String activeUserRegistry = security.getActiveUserRegistry().getType();
        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)activeUserRegistry));
        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildCommonEventData");
        }
    }

    private void buildExtendedEventData(MessageContext msgContext, Map<Object, Object> context, AuditService auditService, ContextHandler contextHandler, HashMap<String, Object> auditContext) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("buildExtendedEventData(");
            buf.append("MessageContext msgContext, ");
            buf.append("Map<Object, Object> context, ");
            buf.append("AuditService auditService, ");
            buf.append("ContextHandler contextHandler, ");
            buf.append("HashMap<String, Object> auditContext[" + auditContext.toString() + "])");
            Tr.entry(tc, buf.toString());
        }
        if (context != null) {
            HashMap extendedAuditContext = null;
            if (auditContext != null && (extendedAuditContext = (HashMap)auditContext.get(EXTENDED_EVENT_DATA)) == null) {
                Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
                return;
            }
            ContextObj contextObj = (ContextObj)contextHandler.getContextObject("CUSTOM_PROPERTY_CONTEXT");
            if (contextObj != null) {
                Set keySet = extendedAuditContext.keySet();
                for (String key : keySet) {
                    contextObj.setEntry(key, extendedAuditContext.get(key));
                }
                auditContext.remove(EXTENDED_EVENT_DATA);
            } else {
                HashMap massagedCustomDataMap = DataHelper.buildCustomData((HashMap)extendedAuditContext);
                auditContext.remove(EXTENDED_EVENT_DATA);
                contextHandler.buildContextObject("CUSTOM_PROPERTY_CONTEXT", massagedCustomDataMap);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created custom context with extendedAuditContext [" + massagedCustomDataMap + "]");
                }
            }
        } else {
            Tr.error(tc, "security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildExtendedEventData");
        }
    }
}

