/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditServiceFactory;
import com.ibm.ws.wssecurity.platform.auth.JaasLoginHelper;
import com.ibm.ws.wssecurity.platform.auth.StateOfCurrentObject;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.SubjectCacheFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.registry.UserMapFactory;
import com.ibm.ws.wssecurity.platform.registry.UserMapping;
import com.ibm.ws.wssecurity.platform.registry.UserRegistry;
import com.ibm.ws.wssecurity.platform.registry.UserRegistryFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.axis2.context.MessageContext;

public abstract class WSSContextManagerBaseImpl
implements WSSContextManager {
    private static final TraceComponent tc = Tr.register(WSSContextManagerBaseImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_REALM = "customRealm";
    private static final ThreadLocal ThreadLocalStorage = new SecurityThreadLocal();
    private JaasLoginHelper jaasLoginHelper = null;
    private static UserRegistry registry = null;
    private static UserMapping userMapping = null;
    private static String DEFAULT_LOGIN_MODULE = "WSSLoginModule";
    private static String DEFAULT_AUTHENTICATION_METHOD = "WSSLogin";
    private static final HashMap originalCallerSubject = new HashMap();
    private static final HashMap originalInvocationSubject = new HashMap();
    private static final HashMap originalSecurityName = new HashMap();
    private static final HashMap originalSubject = new HashMap();
    private static SubjectCache authCache = null;
    private static WSSAuditService auditService = null;

    public WSSContextManagerBaseImpl() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean processIsServer() {
        return false;
    }

    public boolean runInWebSphere() {
        return false;
    }

    public String getDefaultRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm", DEFAULT_REALM);
        }
        return DEFAULT_REALM;
    }

    public String getDefaultLoginModule() {
        return DEFAULT_LOGIN_MODULE;
    }

    public String getLoginModule(String method) {
        return this.getDefaultLoginModule();
    }

    public String getAuthenticationMethod() {
        return DEFAULT_AUTHENTICATION_METHOD;
    }

    private JaasLoginHelper getJaasLoginHelper() throws LoginException {
        if (this.jaasLoginHelper == null) {
            try {
                this.jaasLoginHelper = new JaasLoginHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JaasLoginHelper()");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "", e);
                }
                this.jaasLoginHelper = null;
                throw new LoginException(e.getMessage() + e);
            }
        }
        return this.jaasLoginHelper;
    }

    public UserRegistry getRegistry(String realm) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getRegistry", realm);
            }
            if (registry == null) {
                try {
                    registry = UserRegistryFactory.getInstance();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Fail to get user registry)");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry", registry);
        }
        return registry;
    }

    public UserMapping getUserMapping() {
        if (userMapping == null) {
            userMapping = UserMapFactory.getInstance();
        }
        return userMapping;
    }

    public SubjectCache getSubjectCache() {
        if (authCache == null) {
            authCache = SubjectCacheFactory.getInstance();
        }
        return authCache;
    }

    public WSSAuditService getAuditService() {
        if (auditService == null) {
            auditService = WSSAuditServiceFactory.getInstance();
        }
        return auditService;
    }

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void initialize(Object value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Subject login(String realm, byte[] token) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{realm, token});
        }
        Subject subject = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, token, authMech, . . .)");
        }
        return subject;
    }

    public Subject login(String realm, String user) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user) -> login(" + realm + ", " + user + ")");
        }
        Subject subject = this.login(realm, user, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user)");
        }
        return subject;
    }

    public Subject login(String realm, String user, String password) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user, password) -> login(" + realm + ", " + user + ", " + "xxxx" + ")");
        }
        Subject subject = this.getJaasLoginHelper().jaas_login(realm, user, password);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user, password)");
        }
        return subject;
    }

    public Object get(String key) {
        return this.getThreadLocal().get_property(key);
    }

    public Subject getCallerSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject");
        }
        Subject subject = null;
        try {
            subject = this.getThreadLocal().getCallerSubject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subject;
    }

    public boolean getServerSecurityEnabled() throws SoapSecurityException {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.WSSContextManagerImpl.s02", new String[]{methodName}));
    }

    public Subject getInvocationSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject");
        }
        Subject subject = null;
        try {
            subject = this.getThreadLocal().getInvocationSubject();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject");
        }
        return subject;
    }

    public Subject getSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        Subject subject = null;
        try {
            subject = this.getThreadLocal().getSubject();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject");
        }
        return subject;
    }

    public String getSecurityName() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        String name = null;
        try {
            name = this.getThreadLocal().getSecurityName();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject");
        }
        return name;
    }

    public void setSecurityName(String name) {
        this.getThreadLocal().setSecurityName(name);
    }

    public Object put(String key, Object value) {
        return this.getThreadLocal().set_property(key, value);
    }

    public void setCallerSubject(Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject");
        }
        this.getThreadLocal().setCallerSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject");
        }
    }

    public void setInvocationSubject(Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject");
        }
        this.getThreadLocal().setInvocationSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject");
        }
    }

    public void setSubject(Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject");
        }
        this.getThreadLocal().setSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject");
        }
    }

    public Throwable getRootException() {
        return this.getThreadLocal().get_root_exception();
    }

    public void setRootException(Throwable t) {
        Throwable e = this.getThreadLocal().get_root_exception();
        if (e == null) {
            this.getThreadLocal().set_root_exception(t);
        }
    }

    public void clearRootException() {
        this.setRootException(null);
    }

    public synchronized void pushCredential(Subject subject, MessageContext ctx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushCredential(" + subject + ", " + ctx + ")");
        }
        try {
            Subject origInvocationSubj = this.getThreadLocal().getInvocationSubject();
            Subject origCallerSubj = this.getThreadLocal().getCallerSubject();
            Subject originalsubject = this.getThreadLocal().getSubject();
            String originalUserName = this.getThreadLocal().getSecurityName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original Caller Subject", origCallerSubj);
                Tr.debug(tc, "Original Invocation Subject", origInvocationSubj);
                Tr.debug(tc, "Replace Caller and Invocation Subjects with", subject);
            }
            this.getThreadLocal().setInvocationSubject(subject);
            this.getThreadLocal().setCallerSubject(subject);
            originalInvocationSubject.put(ctx, origInvocationSubj);
            originalCallerSubject.put(ctx, origCallerSubj);
            originalSubject.put(ctx, originalSubject);
            originalSecurityName.put(ctx, originalUserName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                Tr.debug(tc, "Exception in set Caller/Invocation Subject" + sw.toString());
            }
            throw new SoapSecurityException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushCredential()");
        }
    }

    public synchronized void popCredential(MessageContext ctx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popCredential(" + ctx + ")");
        }
        Subject callerSubject = (Subject)originalCallerSubject.remove(ctx);
        Subject invocationSubject = (Subject)originalInvocationSubject.remove(ctx);
        Subject subject = (Subject)originalSubject.remove(ctx);
        String name = (String)originalSecurityName.remove(ctx);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original caller subject", callerSubject);
            Tr.debug(tc, "Original Invocation Subject", invocationSubject);
        }
        this.getThreadLocal().setCallerSubject(callerSubject);
        this.getThreadLocal().setInvocationSubject(invocationSubject);
        this.getThreadLocal().setSubject(subject);
        this.getThreadLocal().setSecurityName(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popCredential()");
        }
    }

    private final void clear() {
        ThreadLocalStorage.set(null);
    }

    private StateOfCurrentObject getThreadLocal() {
        StateOfCurrentObject obj = (StateOfCurrentObject)ThreadLocalStorage.get();
        if (obj == null) {
            obj = new StateOfCurrentObject();
            ThreadLocalStorage.set(obj);
        }
        return obj;
    }

    public boolean getSSOInteropModeEnabled() {
        return false;
    }

    public WSSContext getSerializableContext() throws SoapSecurityException {
        WSSContext context = WSSContextFactory.getInstance();
        if (this.getCallerSubject() == null) {
            this.setCallerSubject(new Subject());
        }
        if (this.getInvocationSubject() == null) {
            this.setInvocationSubject(new Subject());
        }
        context.setCallerSubject(this.getCallerSubject(), null);
        context.setRunAsSubject(this.getCallerSubject(), null);
        return context;
    }

    private static final class SecurityThreadLocal
    extends ThreadLocal {
        private SecurityThreadLocal() {
        }

        protected Object initialValue() {
            return new StateOfCurrentObject();
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

