/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSContextImpl
implements Externalizable,
WSSContext {
    private static final TraceComponent tc = Tr.register(WSSContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 1L;
    private Subject callerSubject = new Subject();
    private Subject runAsSubject = new Subject();
    private static final short CURRENT_VERSION = 1;
    private short version = 1;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readShort();
        this.callerSubject = (Subject)in.readObject();
        this.runAsSubject = (Subject)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.version);
        out.writeObject(this.callerSubject);
        out.writeObject(this.runAsSubject);
    }

    public Subject getCallerSubject(MessageContext mc) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        return this.callerSubject;
    }

    public Subject getRunAsSubject(MessageContext mc) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        return this.runAsSubject;
    }

    public Object runWith(PrivilegedExceptionAction action, MessageContext mc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runWith(" + action + ")");
        }
        if (action == null) {
            SoapSecurityException ex = SoapSecurityException.format("security.wssecurity.WSSContextImpl.s01");
            throw ex;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.runWith))");
            }
            sm.checkPermission(RUNWITH_PERM);
        }
        try {
            Object t = action.run();
            return t;
        }
        catch (Exception e) {
            throw SoapSecurityException.format("security.wssecurity.WSSContextImpl.s02", e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runWith");
            }
        }
    }

    public void setCallerSubject(Subject caller, MessageContext mc) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        this.callerSubject = caller;
    }

    public void setRunAsSubject(Subject runAs_Subject, MessageContext mc) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        this.runAsSubject = runAs_Subject;
    }

    public WSSContext clone(WSSContext context, MessageContext mc) throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clone");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.getSubject))");
            }
            sm.checkPermission(GET_SUBJECT_PERM);
        }
        if (context == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Serializing security context object for deep copy");
            }
            oos.writeObject(context);
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            WSSContext newCtx = (WSSContext)ois.readObject();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "clone");
            }
            return newCtx;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - clone WSSContext: " + e.getMessage());
            }
            throw new SoapSecurityException(e.getMessage(), e);
        }
    }

    public void setContextContent(Object object) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkPermission(java.security.SecurityPermission(platform.wsscontext.setSubject))");
            }
            sm.checkPermission(SET_SUBJECT_PERM);
        }
        if (object == null) {
            return;
        }
        if (!(object instanceof WSSContext)) {
            throw SoapSecurityException.format("security.wssecurity.WSSContextImpl.s03");
        }
        final WSSContext context = (WSSContext)object;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    WSSContextImpl.this.callerSubject = context.getCallerSubject(null);
                    WSSContextImpl.this.runAsSubject = context.getRunAsSubject(null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw SoapSecurityException.format(e.getMessage(), e);
        }
    }
}

