/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.impl.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.wssecurity.impl.auth.callback.WSX509CertificateChainCallback;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSSCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSSCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String userName = null;
    private String password = null;
    private String realm = null;
    private byte[] credToken = null;
    private X509Certificate[] certChain = null;

    public WSSCallbackHandler(String userName, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(userName = \"" + userName + "\", password = \"********\")");
        }
        this.userName = userName;
        this.password = password;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WsCallbackHandler(userName, password)");
        }
    }

    public WSSCallbackHandler(String userName, String realmName, String password) {
        this(userName, password);
        this.realm = realmName;
    }

    public WSSCallbackHandler(String realmName, X509Certificate[] chain) {
        this.realm = realmName;
        this.certChain = chain;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)c).setCredToken(this.credToken);
                continue;
            }
            if (c instanceof WSX509CertificateChainCallback) {
                ((WSX509CertificateChainCallback)c).setX509CertificateChain(this.certChain);
                continue;
            }
            throw new UnsupportedCallbackException(c, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

