/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.auth.WSSCallbackHandler;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class JaasLoginHelper {
    public static WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
    private static final TraceComponent tc = Tr.register(JaasLoginHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    protected Subject jaas_login(String realm, String user, String passwd) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,user,password)");
        }
        Subject subject = null;
        LoginContext lc = null;
        String loginMethod = ctxMgr.getDefaultLoginModule();
        lc = new LoginContext(loginMethod, new WSSCallbackHandler(user, realm, passwd));
        lc.login();
        subject = lc.getSubject();
        if (subject == null) {
            Tr.error(tc, "security.jaas.nosubect", new Object[]{user});
            throw new LoginException("Subject returned from login module is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,user,password)");
        }
        return subject;
    }

    protected Subject jaas_login(String realm, X509Certificate[] certChain) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,certChain)");
        }
        Subject subject = null;
        String loginMethod = ctxMgr.getDefaultLoginModule();
        LoginContext lc = null;
        lc = new LoginContext(loginMethod, new WSSCallbackHandler(realm, certChain));
        lc.login();
        subject = lc.getSubject();
        if (subject == null) {
            Tr.error(tc, "security.jaas.nosubect", new Object[]{certChain});
            throw new LoginException("Subject returned from login module is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,certChain, auth_mech) for web");
        }
        return subject;
    }
}

