/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CacheableTokenCacheImpl
implements CacheableTokenCache {
    private Map<String, Object> nonDistributedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> activeAlarms = Collections.synchronizedMap(new HashMap());
    private static final TraceComponent tc = Tr.register(CacheableTokenCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public CacheableTokenCacheImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CacheableTokenCacheImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheableTokenCacheImpl");
        }
    }

    public CacheableToken getToken(String identifier) {
        String methodName = "getToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken", identifier);
        }
        CacheableToken token = (CacheableToken)this.nonDistributedMap.get(identifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken", token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableToken removeToken(String identifier) {
        String methodName = "removeToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeToken", identifier);
        }
        CacheableToken token = null;
        Map<String, Object> map = this.nonDistributedMap;
        synchronized (map) {
            token = (CacheableToken)this.nonDistributedMap.remove(identifier);
        }
        this.removeAlarm(identifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeToken", token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheToken(String identifier, CacheableToken token, long cacheTimeout) {
        String methodName = "cacheToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheToken", new Object[]{identifier, token, cacheTimeout});
        }
        Map<String, Object> map = this.nonDistributedMap;
        synchronized (map) {
            this.nonDistributedMap.put(identifier, token);
        }
        this.removeAlarm(identifier);
        Alarm alarm = null;
        if (cacheTimeout > 0L) {
            alarm = AlarmManager.createDeferrable(cacheTimeout, new AlarmListener(){

                public void alarm(Object alarmContext) {
                    CacheableTokenCacheImpl.this.removeToken((String)alarmContext);
                }
            }, identifier);
            Map<String, Object> map2 = this.activeAlarms;
            synchronized (map2) {
                this.activeAlarms.put(identifier, alarm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheToken", true);
        }
        return true;
    }

    public boolean containsToken(String identifier) {
        String methodName = "containsToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsToken", identifier);
        }
        boolean exists = false;
        if (this.nonDistributedMap.containsKey(identifier)) {
            exists = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsToken", exists);
        }
        return exists;
    }

    public boolean containsToken(String identifier, CacheableToken token, long cacheTimeout) {
        boolean foundToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsToken", new Object[]{identifier, token, cacheTimeout});
        }
        if (!(foundToken = this.containsToken(identifier))) {
            boolean cacheSuccess = this.cacheToken(identifier, token, cacheTimeout);
            if (tc.isDebugEnabled()) {
                if (cacheSuccess) {
                    Tr.debug(tc, "Addition of token " + token.toString() + " to cache was succesful");
                } else {
                    Tr.debug(tc, "Addition of token" + token.toString() + " to cache was unsuccesful");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsToken", foundToken);
        }
        return foundToken;
    }

    public boolean updateToken(String identifier, CacheableToken token, long cacheTimeout) {
        String methodName = "updateToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateToken", new Object[]{identifier, token, cacheTimeout});
        }
        boolean update = this.cacheToken(identifier, token, cacheTimeout);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateToken", update);
        }
        return update;
    }

    public CacheableToken getLocalToken(String identifier) {
        return this.getToken(identifier);
    }

    public CacheableToken getTokenFromDatabase(String identifier, long timeout) {
        return this.getToken(identifier);
    }

    public CacheableToken removeLocalToken(String identifier) {
        return this.removeToken(identifier);
    }

    public boolean updateLocalToken(String identifier, CacheableToken token, long cacheTimeout) {
        return this.updateToken(identifier, token, cacheTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAlarm(String id) {
        Alarm alarm = (Alarm)this.activeAlarms.get(id);
        if (alarm != null) {
            Map<String, Object> map = this.activeAlarms;
            synchronized (map) {
                this.activeAlarms.remove(id);
            }
            alarm.cancel();
        }
    }

    public void setPreV70InteropMode(boolean preV70InteropMode) {
    }

    public boolean getPreV70InteropMode() {
        return false;
    }

    public void setDistributedMap(int type) {
    }
}

