/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.keyinfo;

import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGeneratorComponent;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.KeyInfo;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedType;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSObjectKeyInfoGenerator
implements KeyInfoGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectKeyInfoGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;
    private Map<Object, Object> _selectors = null;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMDocument doc, OMElement parent, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        KeyInfoContentGeneratorComponent kgen;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map type," + "Map context)");
        }
        Key key = null;
        KeyInfoGeneratorConfig config2 = (KeyInfoGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoGeneratorConfig [" + config2 + "].");
        }
        WSSObjectElement wssObjectParent = (WSSObjectElement)context.get("com.ibm.ws.wssecurity.WSSObjectKeyInfoParent");
        KeyInfo elem = new KeyInfo(wssObjectParent.getWSSObjectDocument());
        String ktype = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        boolean encrypt = false;
        if ("EncryptingKey".equals(ktype)) {
            encrypt = true;
        }
        if (encrypt) {
            ArrayList<WSSObject> children = wssObjectParent.getChildren();
            EncryptedType et = (EncryptedType)wssObjectParent;
            CipherData child = et.getCipherData();
            if (child != null) {
                int index = children.indexOf(child);
                wssObjectParent.insertChildBefore(index, elem);
            } else {
                wssObjectParent.addChild(elem);
            }
        } else {
            wssObjectParent.addChild(elem);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Selector map contains: " + this._selectors);
        }
        if ((kgen = config2.getContentGenerator().getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey01");
        }
        KeyInfoContentGeneratorComponent tmp = (KeyInfoContentGeneratorComponent)this._selectors.get(kgen.getClass());
        if (tmp != null) {
            kgen = tmp;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Will invoke KeyInfoContentGenerator of type " + kgen);
        }
        context.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey", config2.getContentGenerator());
        context.put("com.ibm.ws.wssecurity.WSSObjectKeyInfo", elem);
        key = kgen.getKey(doc, null, type, context);
        context.remove("com.ibm.ws.wssecurity.WSSObjectKeyInfo");
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + elem + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(OMDocument doc,OMElement parent,Map type,Map context) returns Key[key]");
        }
        return key;
    }
}

