/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.keyinfo;

import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGeneratorComponent;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Key;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoGenerator
implements KeyInfoGeneratorComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMDocument doc, OMElement parent, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map type," + "Map context)");
        }
        Key key = null;
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        KeyInfoGeneratorConfig config2 = (KeyInfoGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoGeneratorConfig [" + config2 + "].");
        }
        OMElement elem = null;
        elem = doc.getOMDocumentElement().getOMFactory().createOMElement("KeyInfo", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "ds");
        String ktype = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        boolean encrypt = false;
        if ("EncryptingKey".equals(ktype)) {
            encrypt = true;
            elem.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "ds");
        }
        if (gconfig.isUserDefinedComponentsUsed()) {
            OMElement old = DOMUtils.getOneChildElement(parent, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "KeyInfo");
            OMNode node = old.getNextOMSibling();
            old.detach();
            if (node == null) {
                parent.addChild(elem);
            } else {
                node.insertSiblingBefore(elem);
            }
        } else if (encrypt) {
            OMElement child = DOMUtils.getOneChildElement(parent, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "CipherData");
            if (child == null) {
                parent.addChild(elem);
            } else {
                child.insertSiblingBefore(elem);
            }
        } else {
            parent.addChild(elem);
        }
        KeyInfoContentGeneratorComponent kgen = config2.getContentGenerator().getInstance();
        if (kgen == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey01");
        }
        context.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey", config2.getContentGenerator());
        key = kgen.getKey(doc, elem, type, context);
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + DOMUtils.getDisplayName(elem) + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(OMDocument doc,OMElement parent,Map type,Map context) returns Key[key]");
        }
        return key;
    }
}

