/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.keyinfo;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonContentConsumer;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoConsumer
implements KeyInfoConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final String KEYNAME = "KEYNAME";
    public static final String KEYID = "KEYID";
    public static final String STRREF = "STRREF";
    public static final String EMB = "EMB";
    public static final String X509ISSUER = "X509ISSUER";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String THUMBPRINT = "THUMBPRINT";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(CommonContentConsumer.ResolvedKeyInfo kinfo, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        KeyInfoResult result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(ResolvedKeyInfo kinfo[" + kinfo.toString() + "]," + "Map type," + "Map context)");
        }
        Key key = null;
        KeyInfoConsumerConfig config2 = (KeyInfoConsumerConfig)context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoConsumerConfig [" + config2 + "].");
        }
        boolean succeeded = false;
        KeyInfoContentConsumerConfig kicconfig = null;
        Exception[] exceptions = new Exception[config2.getContentConsumers().size()];
        int exPos = 0;
        Iterator<KeyInfoContentConsumerConfig> it = config2.getContentConsumers().iterator();
        while (it != null && it.hasNext()) {
            SecurityTokenWrapper tokenWrapper;
            kicconfig = it.next();
            result = KeyInfoConsumer.getProcessedResult(context, kicconfig);
            if (result != null) {
                if (result.getError() != null) {
                    exceptions[exPos++] = result.getError();
                    continue;
                }
                key = result.getKey();
                Map<Object, Object> props = kicconfig.getProperties();
                String keyStoreName = (String)props.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW keystore name is : " + keyStoreName);
                }
                context.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName);
                if (succeeded) continue;
                result.setUsed(true);
                succeeded = true;
                continue;
            }
            SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            try {
                KeyInfoContentConsumerComponent kcon = kicconfig.getInstance();
                TokenConsumerConfig tconfig = kicconfig.getTokenConsumer();
                if (tconfig != null) {
                    String ref = kinfo.getTokenReference();
                    HashMap tokensToConsume = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCache");
                    if (tokensToConsume.get(ref) != null) {
                        WSSConsumer.callStoredTokenConsumer(tconfig, context, ref);
                    }
                }
                context.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey", kicconfig);
                Key tmpkey = kcon.getKey(kinfo, type, context);
                if (tmpkey == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (key == null) {
                    key = tmpkey;
                    Map<Object, Object> props = kicconfig.getProperties();
                    String keyStoreName = (String)props.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HW keystorename is : " + keyStoreName);
                    }
                    context.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName);
                }
                if ((tokenWrapper = securityTokenManager.getUnprocessedTokenWrapper()) != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            tokenWrapper.setProcessed(true);
                            return null;
                        }
                    });
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) != null) {
                    result.setProcessed(true);
                    if (!succeeded) {
                        result.setUsed(true);
                    }
                    result.setKey(key);
                }
                succeeded = true;
            }
            catch (Exception e) {
                exceptions[exPos++] = e;
                Object object = context.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
                if (object != null && object instanceof SecurityToken) {
                    SecurityToken token = (SecurityToken)object;
                    tokenWrapper = new SecurityTokenWrapper(token);
                    TokenConsumerConfig tconfig = kicconfig.getTokenConsumer();
                    tokenWrapper.setUsedTokenConsumer(tconfig.hashCode(), tconfig.getClass().getName().hashCode());
                    tokenWrapper.setKeyInfoType(null);
                    if (e instanceof SoapSecurityException) {
                        tokenWrapper.setError((SoapSecurityException)e);
                    }
                    tokenWrapper.setProcessed(true);
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) == null) continue;
                result.setError(e);
                result.setProcessed(true);
            }
        }
        it = config2.getOtherContentConsumers().iterator();
        while (it != null && it.hasNext()) {
            kicconfig = it.next();
            result = KeyInfoConsumer.getProcessedResult(context, kicconfig);
            if (result != null) continue;
            try {
                KeyInfoContentConsumerComponent kcon = kicconfig.getInstance();
                context.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey", kicconfig);
                Key tmpkey = kcon.getKey(kinfo, type, context);
                if (tmpkey == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (key == null) {
                    key = tmpkey;
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) == null) continue;
                result.setProcessed(true);
            }
            catch (Exception e) {
                result = KeyInfoConsumer.getUnprocessedResult(context);
                if (result == null) continue;
                result.setError(e);
                result.setProcessed(true);
            }
        }
        if (!succeeded) {
            if (exPos == 1) {
                if (exceptions[0] instanceof SoapSecurityException) {
                    throw (SoapSecurityException)exceptions[0];
                }
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{exceptions[0].getMessage()}, (Throwable)exceptions[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, exPos + " exceptions were catched.");
                for (int i = 0; i < exPos; ++i) {
                    Tr.debug(tc, "No." + i + "'s exception: " + exceptions[i]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey03", new String[]{exceptions[exPos - 1].getMessage()}, (Throwable)exceptions[exPos - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getkey(ResolvedKeyInfo kinfo,Map type,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getKeyInfoType(OMElement target, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoType(OMElement target[" + DOMUtils.getDisplayName(target) + "]," + "String [" + nsWsse + "])");
        }
        String kitype = UNKNOWN;
        OMElement child = DOMUtils.getFirstElement(target);
        if (child != null && DOMUtils.equals(child, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "KeyName")) {
            kitype = KEYNAME;
        } else {
            if (!DOMUtils.equals(child, nsWsse, "SecurityTokenReference")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
            if (DOMUtils.equals(child = DOMUtils.getFirstElement(child), nsWsse, "KeyIdentifier")) {
                String valueType = DOMUtils.getAttribute(child, "ValueType");
                kitype = valueType.equals(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.getLocalPart()) ? THUMBPRINT : KEYID;
            } else if (DOMUtils.equals(child, nsWsse, "Reference")) {
                kitype = STRREF;
            } else if (DOMUtils.equals(child, nsWsse, "Embedded")) {
                kitype = EMB;
            } else {
                if (!DOMUtils.equals(child, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509Data")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
                kitype = X509ISSUER;
            }
        }
        if (!tc.isEntryEnabled()) return kitype;
        Tr.exit(tc, "getKeyInfoType(OMElement target,String  nsWsse) returns String[" + kitype + "]");
        return kitype;
    }

    public static QName getValueType(OMElement target, String kitype, String nsWsse, int wssVersion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueType(OMElement target[" + DOMUtils.getDisplayName(target) + "]," + "String kitype[" + kitype + "]," + "String nsWsse[" + nsWsse + "]," + "int wssVersion[" + wssVersion + "])");
        }
        QName vtype = null;
        if (kitype == STRREF) {
            OMElement child = DOMUtils.getOneElement(target, nsWsse, "Reference");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType01");
            }
            String vts = DOMUtils.getAttribute(child, "ValueType");
            vtype = DOMUtils.getQName(target, vts, wssVersion);
        } else if (kitype == KEYID || kitype == THUMBPRINT) {
            OMElement child = DOMUtils.getOneElement(target, nsWsse, "KeyIdentifier");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType02");
            }
            String vts = DOMUtils.getAttribute(child, "ValueType");
            vtype = DOMUtils.getQName(target, vts, wssVersion);
        } else if (kitype == EMB) {
            OMElement child = DOMUtils.getOneElement(target, nsWsse, "Embedded");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType03");
            }
            OMElement child2 = DOMUtils.getFirstElement(child);
            if (child2 != null) {
                if (child2.getLocalName().equals("BinarySecurityToken") && nsWsse.equals(child2.getNamespace() == null ? null : child2.getNamespace().getName())) {
                    String vts = DOMUtils.getAttribute(child2, "ValueType");
                    vtype = DOMUtils.getQName(target, vts, wssVersion);
                } else {
                    String string = child2.getLocalName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueType(OMElement target,String kitype,String nsWsse) returns QName[" + vtype + "]");
        }
        return vtype;
    }

    private static KeyInfoResult getUnprocessedResult(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnprocessedResult(Map context)");
        }
        KeyInfoResult result = null;
        Result[] results = ResultPool.get(context, KeyInfoResult.class);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = (KeyInfoResult)results[i];
                if (r.isProcessed()) continue;
                result = r;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnprocessedResult(Map context) returns KeyInfoResult[" + result + "]");
        }
        return result;
    }

    private static KeyInfoResult getProcessedResult(Map<Object, Object> context, KeyInfoContentConsumerConfig kconfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig");
        }
        KeyInfoResult result = null;
        Result[] results = ResultPool.get(context, KeyInfoResult.class);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = (KeyInfoResult)results[i];
                if (!kconfig.equals(r.getKeyInfoContentConsumer())) continue;
                result = r;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig) returns KeyInfoResult[" + result + "]");
        }
        return result;
    }
}

