/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.impl.auth.callback.STSRulesCallback;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSDefaultLoginModule
implements LoginModule {
    private CallbackHandler handler;
    private static final TraceComponent tc = Tr.register(STSDefaultLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize: callbackHandler.getClass(): " + callbackHandler.getClass().getName());
        }
        this.handler = callbackHandler;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize: handler.getClass(): " + this.handler.getClass().getName());
        }
    }

    @Override
    public boolean login() throws LoginException {
        IdentityList rules;
        String method = "login";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (this.handler == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Login module has not yet been initialized (CallbackHandler is null).");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new LoginException();
        }
        Callback[] callbacks = new Callback[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handler.getClass(): " + this.handler.getClass().getName());
            if (this.handler instanceof STSCallbackHandler) {
                Tr.debug(tc, "handler instanceof STSCallbackHandler is true");
            } else {
                Tr.debug(tc, "handler instanceof STSCallbackHandler is false");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding STSRulesCallback callback to list of callbacks to handle.");
        }
        callbacks[0] = new STSRulesCallback();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking the CallbackHandler.");
        }
        try {
            this.handler.handle(callbacks);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandler failed with exception: " + e.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new LoginException();
        }
        STSRulesCallback stsCallback = (STSRulesCallback)callbacks[0];
        if (stsCallback.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandler returned successfully.");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CallbackHandler returned with failure.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new LoginException();
            }
        }
        if ((rules = stsCallback.getRules()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No rules exist therefore bypassing security check");
            }
        } else {
            SecurityToken token = stsCallback.getToken();
            if (token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Rules exist and token is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new LoginException();
            }
            ArrayList<String> principalList = null;
            Class<?> tokenClass = token.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token is of type: " + tokenClass.getName());
            }
            try {
                String principal;
                if (SCT.class.isAssignableFrom(tokenClass)) {
                    principalList = ((SCT)token).getAppliesToList();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "principalList: " + principalList);
                    }
                }
                if (SecurityTokenImpl.class.isAssignableFrom(tokenClass)) {
                    principal = token.getPrincipal();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "token.getPrincipal(): " + principal);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "token not a SecurityTokenImpl, unable to getPrincipal");
                    }
                    throw new LoginException();
                }
                principalList = new ArrayList<String>();
                principalList.add(principal);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught while getting token principal: " + e.getMessage());
                }
                throw new LoginException();
            }
            if (tc.isDebugEnabled()) {
                int loop = 0;
                while (loop < principalList.size()) {
                    Tr.debug(tc, "principal.get(" + loop + "): " + principalList.get(loop));
                }
                Tr.debug(tc, "Searching through identity rules for match to principal.");
                Tr.debug(tc, "This login module implementation requires matching principal values to pass. All IdentityParts of an Identity must be satisfied.");
            }
            List<Identity> idList = rules.getIdentity();
            Iterator<Identity> idsIter = idList.iterator();
            boolean matched = false;
            block5: while (idsIter.hasNext()) {
                Identity currentID = idsIter.next();
                List<IdentityPart> parts = currentID.getIdentityPart();
                if (parts.size() != 1) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found an Identity with more than one IdentityPart. This will not be satisfied. Moving on to the next Identity.");
                    continue;
                }
                IdentityPart idPart = parts.get(0);
                String partName = idPart.getName();
                String partValue = idPart.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Listing IdentityPart.");
                    Tr.debug(tc, "  Name: " + partName + "  Value: " + partValue);
                }
                int loop2 = 0;
                while (loop2 < principalList.size()) {
                    if (partName.equals("Principal") && partValue.equals(principalList.get(loop2))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found a match!");
                        }
                        matched = true;
                        continue block5;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Does not match.");
                }
            }
            if (!matched) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find a match. Login failed.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                throw new LoginException();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Login successful!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

