/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.impl.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.wssecurity.impl.auth.callback.WSStdinLoginPrompt;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSStdinCallbackHandlerImpl
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSStdinCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String realmNamePrompt = "Realm Name";
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i;
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i2 = 0; i2 < len; ++i2) {
                sb.append(callbacks[i2].getClass().getName());
                if (i2 >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                this.userNamePrompt = ((NameCallback)c).getPrompt();
                this.userName = ((NameCallback)c).getDefaultName();
                continue;
            }
            if (c instanceof PasswordCallback) {
                this.passwordPrompt = ((PasswordCallback)c).getPrompt();
                this.passwordEcho = ((PasswordCallback)c).isEchoOn();
                continue;
            }
            if (!(c instanceof WSRealmNameCallbackImpl)) continue;
            this.realmName = ((WSRealmNameCallbackImpl)c).getRealmName();
            if (this.realmName != null && !this.realmName.equals("")) continue;
            this.realmName = ((WSRealmNameCallbackImpl)c).getDefaultRealmName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        String[] usernameAndPassword = null;
        try {
            if (stdinRetry < 1) {
                System.out.print("Realm Name: " + this.realmName + NEW_LINE);
                System.out.flush();
                WSStdinLoginPrompt wstd = new WSStdinLoginPrompt(this.userNamePrompt, this.passwordPrompt);
                usernameAndPassword = wstd.getUidAndPassword();
                if (usernameAndPassword != null) {
                    this.password = usernameAndPassword[1];
                    this.userName = usernameAndPassword[0];
                    stdinRetry = 0;
                } else {
                    ++stdinRetry;
                    this.userName = null;
                    this.password = null;
                }
            } else {
                stdinRetry = 0;
                this.userName = null;
                this.password = null;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.jaas.SystemInputError", new Object[]{e});
        }
        for (i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(c, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

