/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import javax.security.auth.callback.Callback;

public class WSRealmNameCallbackImpl
implements Callback {
    private String defaultRealmName = null;
    private String realmName = null;
    private String prompt;
    private static final TraceComponent tc = Tr.register(WSRealmNameCallbackImpl.class, null, "com.ibm.ejs.resources.security");

    public WSRealmNameCallbackImpl(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSRealmNameCallbackImpl(prompt = \"" + prompt + "\")");
        }
        this.prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRealmNameCallbackImpl(prompt)");
        }
    }

    public WSRealmNameCallbackImpl(String prompt, String defaultRealmName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSRealmNameCallbackImpl(prompt = \"" + prompt + "\", defaultRealmName = \"" + defaultRealmName + "\")");
        }
        this.prompt = prompt;
        this.defaultRealmName = defaultRealmName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRealmNameCallbackImpl(prompt, defaultRealmName)");
        }
    }

    public void setRealmName(String realmName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRealmName(realmName = \"" + realmName + "\")");
        }
        this.realmName = realmName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRealmName(realmName)");
        }
    }

    public String getRealmName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmName()");
        }
        if (this.realmName == null || this.realmName.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realm name not set, use default value");
            }
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "DEFAULT_REALM";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmName() -> " + this.realmName);
        }
        return this.realmName;
    }

    public String getDefaultRealmName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealmName()");
        }
        if (this.defaultRealmName == null || this.defaultRealmName.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "default realm name not set, use default value");
            }
            if (this.defaultRealmName == null || this.defaultRealmName.length() == 0) {
                this.defaultRealmName = "DEFAULT_REALM";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealmName() -> " + this.defaultRealmName);
        }
        return this.defaultRealmName;
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this.prompt);
        }
        return this.prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }
}

