/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.util.CredentialsHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import javax.security.auth.callback.Callback;

public class WSCredTokenCallbackImpl
implements Callback {
    private byte[] defaultCredToken;
    private byte[] credToken;
    private String prompt;
    private static final TraceComponent tc = Tr.register(WSCredTokenCallbackImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public WSCredTokenCallbackImpl(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCredTokenCallbackImpl(prompt = \"" + prompt + "\")");
        }
        this.prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCredTokenCallbackImpl(prompt)");
        }
    }

    public WSCredTokenCallbackImpl(String prompt, byte[] defaultCredToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCredTokenCallbackImpl(prompt = \"" + prompt + "\", defaultCredToken)");
        }
        this.prompt = prompt;
        this.defaultCredToken = CredentialsHelper.copyCredToken(defaultCredToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCredTokenCallbackImpl(prompt, defaultCredToken)");
        }
    }

    public void setCredToken(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCredToken(credToken)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCredToken(credToken)");
        }
    }

    public byte[] getCredToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredToken()");
            Tr.exit(tc, "getCredToken()");
        }
        return CredentialsHelper.copyCredToken(this.credToken);
    }

    public byte[] getDefaultCredToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCredToken()");
            Tr.exit(tc, "getDefaultCredToken()");
        }
        return CredentialsHelper.copyCredToken(this.defaultCredToken);
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this.prompt);
        }
        return this.prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }
}

